#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-lib
version:              1.50.3
visibility:           public
id:                   hledger-lib-1.50.3-6miiNpjRrbFLLEM0qAFSI3
key:                  hledger-lib-1.50.3-6miiNpjRrbFLLEM0qAFSI3
license:              GPL-3.0-or-later
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             A library providing the core functionality of hledger
description:
    This library contains hledger'\''s core functionality.
    It is used by most hledger* packages so that they support the same
    command line options, file formats, reports, etc.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting.

    See also:

    - https://hledger.org - hledger'\''s home page

    - https://hledger.org/dev.html - starting point for hledger'\''s developer docs

    - https://hackage.haskell.org/package/hledger-lib/docs/Hledger.html - starting point for hledger'\''s haddock docs

category:             Finance
abi:                  a88a658205bd43642c87f2926e77198d
exposed:              True
exposed-modules:
    Hledger Hledger.Data Hledger.Data.Account Hledger.Data.AccountName
    Hledger.Data.Amount Hledger.Data.Balancing Hledger.Data.Currency
    Hledger.Data.Dates Hledger.Data.Errors Hledger.Data.Journal
    Hledger.Data.JournalChecks Hledger.Data.JournalChecks.Ordereddates
    Hledger.Data.JournalChecks.Uniqueleafnames Hledger.Data.Json
    Hledger.Data.Ledger Hledger.Data.Period
    Hledger.Data.PeriodicTransaction Hledger.Data.Posting
    Hledger.Data.RawOptions Hledger.Data.StringFormat
    Hledger.Data.Timeclock Hledger.Data.Transaction
    Hledger.Data.TransactionModifier Hledger.Data.Types
    Hledger.Data.Valuation Hledger.Query Hledger.Read
    Hledger.Read.Common Hledger.Read.CsvReader
    Hledger.Read.InputOptions Hledger.Read.JournalReader
    Hledger.Read.RulesReader Hledger.Read.TimeclockReader
    Hledger.Read.TimedotReader Hledger.Reports
    Hledger.Reports.AccountTransactionsReport
    Hledger.Reports.BalanceReport Hledger.Reports.BudgetReport
    Hledger.Reports.EntriesReport Hledger.Reports.MultiBalanceReport
    Hledger.Reports.PostingsReport Hledger.Reports.ReportOptions
    Hledger.Reports.ReportTypes Hledger.Utils Hledger.Utils.Debug
    Hledger.Utils.IO Hledger.Utils.Parse Hledger.Utils.Regex
    Hledger.Utils.String Hledger.Utils.Test Hledger.Utils.Text
    Hledger.Write.Beancount Hledger.Write.Csv Hledger.Write.Html
    Hledger.Write.Html.Attribute Hledger.Write.Html.Blaze
    Hledger.Write.Html.HtmlCommon Hledger.Write.Html.Lucid
    Hledger.Write.Ods Hledger.Write.Spreadsheet Text.Tabular.AsciiWide
    Text.WideString

hidden-modules:
    Hledger.Data.BalanceData Hledger.Data.DayPartition
    Hledger.Data.PeriodData Paths_hledger_lib

import-dirs:          /usr/lib/ghc-9.6.6/site-local/hledger-lib-1.50.3
library-dirs:         /usr/lib/ghc-9.6.6/site-local/hledger-lib-1.50.3
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/hledger-lib-1.50.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hledger-lib
hs-libraries:         HShledger-lib-1.50.3-6miiNpjRrbFLLEM0qAFSI3
depends:
    Decimal-0.5.2-IIe9wLiWUhH4Fx4Eysbzm9
    Glob-0.10.2-2ocPujhthTrK7apkiFGGkz
    aeson-2.1.2.1-JZeWX2s1eQL7Ta3HF3w6fW
    aeson-pretty-0.8.10-LBJ177aL2uN3HrqwVlBpw9
    ansi-terminal-1.0.2-3wM6DfsGeit89xAznbDC0C array-0.5.6.0
    base-4.18.2.1 blaze-html-0.9.2.0-LUjYdeknUl1Ef7LhdtXXgs
    blaze-markup-0.8.3.0-Donjg3mDQKIJPFMPJHNoUU bytestring-0.11.5.3
    call-stack-0.4.0-2bP2isqo6m56I7hpBeHX0O
    cassava-0.5.4.1-BNFig0Nv1LW4b1LMaP7WiA
    cassava-megaparsec-2.1.1-JTsnoiFXnH12tK5bShOWwj
    cmdargs-0.10.22-E2EkQI5shziHkHOdPiVHiM
    colour-2.3.6-Kk9wswfvZAl3ejH6JnCqlz containers-0.6.7
    data-default-0.7.1.3-EtVHsfbH5oIpJ9umzYHUz deepseq-1.4.8.1
    directory-1.3.8.5 doclayout-0.5-3uEvNcwSawAKaZhYDKWTsB
    encoding-0.10.2-6HjbjZySVvkIRgw5Mx3ZhB
    extra-1.7.16-LWra3MmVE7hIjr4mBFp6lZ
    file-embed-0.0.16.0-6A32wX7iXBC7ZTuLWlLLWz filepath-1.4.300.1
    hashtables-1.4.2-KphVIsegdeCBgWEAOa1hC8
    lucid-2.11.20250303-BJeJa0SFmGhB7OczsClXHe
    megaparsec-9.7.0-I0qZdfD2x7QA5TPaNUjmTK
    microlens-0.4.14.0-IP2Uuhm3qTnDhkfYobH8B3
    microlens-th-0.4.3.17-IPbJLKFzpBF3M0tXA6bBdw mtl-2.3.1
    parser-combinators-1.3.0-20UTEUZ5CKDJdRu747ID48
    pretty-simple-4.1.3.0-xeyhKTj2sqCUH1sULWC64 process-1.6.19.0
    regex-tdfa-1.3.2.5-qZoXOptISAJcpXFSPLOTl
    safe-0.3.21-EsRFO8M87PCEtDqVSuBNfo
    tabular-0.2.2.8-Ly9fepE9sHFB2l1Bgv9bkV
    tasty-1.5.2-QJSnUao0iU3Q0YGBz8WKt
    tasty-hunit-0.10.2-EQswFNRObMV4VV4yQgsVWK template-haskell-2.20.0.0
    terminal-size-0.3.4-RfZxi4foNwK9w669pzI7h text-2.0.2
    these-1.2.1-Jr1OKOvwflFL3mHngmLVvf time-1.12.2
    timeit-2.0-DwmItJuhuSm6aktMh1S1ZM transformers-0.6.1.0
    uglymemo-0.1.0.1-9CTAG7WaUP4YIMm3gIN93
    unordered-containers-0.2.20.1-8SON4238u8N3rDHPceHjHx
    utf8-string-1.0.2-2At7L47Qsbs4rlGLlJEQb1

haddock-interfaces:   /usr/share/doc/haskell-hledger-lib/html/hledger-lib.haddock
haddock-html:         /usr/share/doc/haskell-hledger-lib/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

