/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.ir;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.JsSymbols;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.utils.OperatorNames;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rH\u0002J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\rH\u0002J\u0016\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rJ\u0016\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rJ\u0016\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rJ\u0016\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rJ\u0016\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rJ\u0016\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rJ\u0016\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rJ\u0016\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rJ\u0016\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rJ\u0016\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rJ\u000e\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\rJ\u000e\u0010\u001f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\rJ\u0016\u0010 \u001a\u00020!2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rJ\u0016\u0010\"\u001a\u00020!2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/ir/JsIrArithBuilder;", "", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "symbols", "Lorg/jetbrains/kotlin/ir/backend/js/JsSymbols;", "getSymbols", "()Lorg/jetbrains/kotlin/ir/backend/js/JsSymbols;", "buildBinaryOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "name", "Lorg/jetbrains/kotlin/name/Name;", "l", "r", "buildUnaryOperator", "v", "add", "sub", "mul", "div", "rem", "and", "or", "shl", "shr", "shru", "not", "inv", "andand", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "oror", "backend.js"})
@SourceDebugExtension(value={"SMAP\nIrArithBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrArithBuilder.kt\norg/jetbrains/kotlin/ir/backend/js/ir/JsIrArithBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,49:1\n1#2:50\n*E\n"})
public final class JsIrArithBuilder {
    @NotNull
    private final JsIrBackendContext context;
    @NotNull
    private final JsSymbols symbols;

    public JsIrArithBuilder(@NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.symbols = this.context.getSymbols();
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final JsSymbols getSymbols() {
        return this.symbols;
    }

    private final IrExpression buildBinaryOperator(Name name, IrExpression l, IrExpression r) {
        IrCall irCall;
        IrSimpleFunctionSymbol symbol;
        IrType irType = l.getType();
        Intrinsics.checkNotNull((Object)irType, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
        IrSimpleType irSimpleType = (IrSimpleType)irType;
        IrType irType2 = r.getType();
        Intrinsics.checkNotNull((Object)irType2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = symbol = this.context.getOperatorByName(name, irSimpleType, (IrSimpleType)irType2);
        Intrinsics.checkNotNull((Object)irSimpleFunctionSymbol);
        IrCall $this$buildBinaryOperator_u24lambda_u240 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, irSimpleFunctionSymbol, null, null, null, null, 0, 0, 126, null);
        boolean bl = false;
        $this$buildBinaryOperator_u24lambda_u240.getArguments().set(0, (Object)l);
        $this$buildBinaryOperator_u24lambda_u240.getArguments().set(1, (Object)r);
        return (IrExpression)irCall;
    }

    private final IrExpression buildUnaryOperator(Name name, IrExpression v) {
        IrCall irCall;
        IrType irType = v.getType();
        Intrinsics.checkNotNull((Object)irType, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.context.getOperatorByName(name, (IrSimpleType)irType, null);
        Intrinsics.checkNotNull((Object)irSimpleFunctionSymbol);
        IrSimpleFunctionSymbol symbol = irSimpleFunctionSymbol;
        IrCall $this$buildUnaryOperator_u24lambda_u241 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, symbol, null, null, null, null, 0, 0, 126, null);
        boolean bl = false;
        $this$buildUnaryOperator_u24lambda_u241.setDispatchReceiver(v);
        return (IrExpression)irCall;
    }

    @NotNull
    public final IrExpression add(@NotNull IrExpression l, @NotNull IrExpression r) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return this.buildBinaryOperator(OperatorNames.INSTANCE.getADD(), l, r);
    }

    @NotNull
    public final IrExpression sub(@NotNull IrExpression l, @NotNull IrExpression r) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return this.buildBinaryOperator(OperatorNames.INSTANCE.getSUB(), l, r);
    }

    @NotNull
    public final IrExpression mul(@NotNull IrExpression l, @NotNull IrExpression r) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return this.buildBinaryOperator(OperatorNames.INSTANCE.getMUL(), l, r);
    }

    @NotNull
    public final IrExpression div(@NotNull IrExpression l, @NotNull IrExpression r) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return this.buildBinaryOperator(OperatorNames.INSTANCE.getDIV(), l, r);
    }

    @NotNull
    public final IrExpression rem(@NotNull IrExpression l, @NotNull IrExpression r) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return this.buildBinaryOperator(OperatorNames.INSTANCE.getREM(), l, r);
    }

    @NotNull
    public final IrExpression and(@NotNull IrExpression l, @NotNull IrExpression r) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return this.buildBinaryOperator(OperatorNames.INSTANCE.getAND(), l, r);
    }

    @NotNull
    public final IrExpression or(@NotNull IrExpression l, @NotNull IrExpression r) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return this.buildBinaryOperator(OperatorNames.INSTANCE.getOR(), l, r);
    }

    @NotNull
    public final IrExpression shl(@NotNull IrExpression l, @NotNull IrExpression r) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return this.buildBinaryOperator(OperatorNames.INSTANCE.getSHL(), l, r);
    }

    @NotNull
    public final IrExpression shr(@NotNull IrExpression l, @NotNull IrExpression r) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return this.buildBinaryOperator(OperatorNames.INSTANCE.getSHR(), l, r);
    }

    @NotNull
    public final IrExpression shru(@NotNull IrExpression l, @NotNull IrExpression r) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return this.buildBinaryOperator(OperatorNames.INSTANCE.getSHRU(), l, r);
    }

    @NotNull
    public final IrExpression not(@NotNull IrExpression v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return this.buildUnaryOperator(OperatorNames.INSTANCE.getNOT(), v);
    }

    @NotNull
    public final IrExpression inv(@NotNull IrExpression v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return this.buildUnaryOperator(OperatorNames.INSTANCE.getINV(), v);
    }

    @NotNull
    public final IrWhen andand(@NotNull IrExpression l, @NotNull IrExpression r) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return JsIrBuilder.buildIfElse$default(JsIrBuilder.INSTANCE, this.context.getIrBuiltIns().getBooleanType(), l, r, (IrExpression)JsIrBuilder.INSTANCE.buildBoolean(this.context.getIrBuiltIns().getBooleanType(), false), 0, 0, 0, 0, 240, null);
    }

    @NotNull
    public final IrWhen oror(@NotNull IrExpression l, @NotNull IrExpression r) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return JsIrBuilder.buildIfElse$default(JsIrBuilder.INSTANCE, this.context.getIrBuiltIns().getBooleanType(), l, (IrExpression)JsIrBuilder.INSTANCE.buildBoolean(this.context.getIrBuiltIns().getBooleanType(), true), r, 0, 0, 0, 0, 240, null);
    }
}

