/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.quantity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;
import javax.measure.Quantity;
import javax.measure.Unit;
import tech.units.indriya.AbstractQuantity;
import tech.units.indriya.ComparableQuantity;
import tech.units.indriya.function.Calculus;
import tech.units.indriya.quantity.Quantities;

final class DecimalQuantity<Q extends Quantity<Q>>
extends AbstractQuantity<Q>
implements Serializable {
    private static final long serialVersionUID = 6504081836032983882L;
    private final BigDecimal value;

    public DecimalQuantity(BigDecimal value, Unit<Q> unit) {
        super(unit);
        this.value = value;
    }

    public DecimalQuantity(double value, Unit<Q> unit) {
        super(unit);
        this.value = BigDecimal.valueOf(value);
    }

    @Override
    public BigDecimal getValue() {
        return this.value;
    }

    @Override
    public double doubleValue(Unit<Q> unit) {
        return this.getUnit().equals(unit) ? this.value.doubleValue() : this.getUnit().getConverterTo(unit).convert(this.value.doubleValue());
    }

    @Override
    public BigDecimal decimalValue(Unit<Q> unit) throws ArithmeticException {
        return Calculus.toBigDecimal(super.getUnit().getConverterTo(unit).convert((Number)this.value));
    }

    @Override
    public ComparableQuantity<Q> add(Quantity<Q> that) {
        if (this.getUnit().equals(that.getUnit())) {
            return Quantities.getQuantity(this.value.add(Calculus.toBigDecimal(that.getValue()), Calculus.MATH_CONTEXT), this.getUnit());
        }
        Quantity converted = that.to(this.getUnit());
        return Quantities.getQuantity(this.value.add(Calculus.toBigDecimal(converted.getValue())), this.getUnit());
    }

    @Override
    public ComparableQuantity<Q> subtract(Quantity<Q> that) {
        if (this.getUnit().equals(that.getUnit())) {
            return Quantities.getQuantity(this.value.subtract(Calculus.toBigDecimal(that.getValue()), Calculus.MATH_CONTEXT), this.getUnit());
        }
        Quantity converted = that.to(this.getUnit());
        return Quantities.getQuantity(this.value.subtract(Calculus.toBigDecimal(converted.getValue()), Calculus.MATH_CONTEXT), this.getUnit());
    }

    @Override
    public ComparableQuantity<?> multiply(Quantity<?> that) {
        return new DecimalQuantity<Q>(this.value.multiply(Calculus.toBigDecimal(that.getValue()), Calculus.MATH_CONTEXT), this.getUnit().multiply(that.getUnit()));
    }

    @Override
    public ComparableQuantity<Q> multiply(Number that) {
        return Quantities.getQuantity(this.value.multiply(Calculus.toBigDecimal(that), Calculus.MATH_CONTEXT), this.getUnit());
    }

    @Override
    public ComparableQuantity<Q> divide(Number that) {
        return Quantities.getQuantity(this.value.divide(Calculus.toBigDecimal(that), Calculus.MATH_CONTEXT), this.getUnit());
    }

    @Override
    public ComparableQuantity<Q> inverse() {
        return Quantities.getQuantity(BigDecimal.ONE.divide(this.value), this.getUnit().inverse());
    }

    @Override
    protected long longValue(Unit<Q> unit) {
        double result = this.doubleValue(unit);
        if (result < -9.223372036854776E18 || result > 9.223372036854776E18) {
            throw new ArithmeticException("Overflow (" + result + ")");
        }
        return (long)result;
    }

    @Override
    public boolean isBig() {
        return true;
    }

    @Override
    public ComparableQuantity<?> divide(Quantity<?> that) {
        return new DecimalQuantity<Q>(this.value.divide(Calculus.toBigDecimal(that.getValue()), Calculus.MATH_CONTEXT), this.getUnit().divide(that.getUnit()));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof Quantity) {
            Quantity that = (Quantity)obj;
            return Objects.equals(this.getUnit(), that.getUnit()) && AbstractQuantity.Equalizer.hasEquality(this.value, that.getValue());
        }
        return false;
    }
}

