/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.error.ClassModifierShouldBe;
import org.assertj.core.error.ShouldBeAbstract;
import org.assertj.core.error.ShouldBeAnnotation;
import org.assertj.core.error.ShouldBeAssignableTo;
import org.assertj.core.error.ShouldBeInterface;
import org.assertj.core.error.ShouldBePrimitive;
import org.assertj.core.error.ShouldBeRecord;
import org.assertj.core.error.ShouldBeSealed;
import org.assertj.core.error.ShouldHaveNoPackage;
import org.assertj.core.error.ShouldHaveNoSuperclass;
import org.assertj.core.error.ShouldHavePackage;
import org.assertj.core.error.ShouldHavePermittedSubclasses;
import org.assertj.core.error.ShouldHaveRecordComponents;
import org.assertj.core.error.ShouldHaveSuperclass;
import org.assertj.core.error.ShouldNotBeNull;
import org.assertj.core.error.ShouldNotBePrimitive;
import org.assertj.core.internal.Classes;
import org.assertj.core.util.Arrays;
import org.assertj.core.util.Sets;

public abstract class AbstractClassAssert<SELF extends AbstractClassAssert<SELF>>
extends AbstractAssert<SELF, Class<?>> {
    Classes classes = Classes.instance();

    protected AbstractClassAssert(Class<?> actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public SELF isAssignableFrom(Class<?> ... others) {
        this.classes.assertIsAssignableFrom(this.info, (Class)this.actual, others);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF isAssignableTo(Class<?> other) {
        this.isNotNull();
        this.assertIsAssignableTo(other);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    private void assertIsAssignableTo(Class<?> other) {
        Objects.requireNonNull(other, ShouldNotBeNull.shouldNotBeNull("other")::create);
        if (!other.isAssignableFrom((Class)this.actual)) {
            throw this.assertionError(ShouldBeAssignableTo.shouldBeAssignableTo((Class)this.actual, other));
        }
    }

    public SELF isNotInterface() {
        this.isNotNull();
        this.assertIsNotInterface();
        return (SELF)((AbstractClassAssert)this.myself);
    }

    private void assertIsNotInterface() {
        if (((Class)this.actual).isInterface()) {
            throw this.assertionError(ShouldBeInterface.shouldNotBeInterface((Class)this.actual));
        }
    }

    public SELF isInterface() {
        this.isNotNull();
        this.assertIsInterface();
        return (SELF)((AbstractClassAssert)this.myself);
    }

    private void assertIsInterface() {
        if (!((Class)this.actual).isInterface()) {
            throw this.assertionError(ShouldBeInterface.shouldBeInterface((Class)this.actual));
        }
    }

    public SELF isAbstract() {
        this.isNotNull();
        this.assertIsAbstract();
        return (SELF)((AbstractClassAssert)this.myself);
    }

    private void assertIsAbstract() {
        if (!Modifier.isAbstract(((Class)this.actual).getModifiers())) {
            throw this.assertionError(ShouldBeAbstract.shouldBeAbstract((Class)this.actual));
        }
    }

    public SELF isAnnotation() {
        this.isNotNull();
        this.assertIsAnnotation();
        return (SELF)((AbstractClassAssert)this.myself);
    }

    private void assertIsAnnotation() {
        if (!((Class)this.actual).isAnnotation()) {
            throw this.assertionError(ShouldBeAnnotation.shouldBeAnnotation((Class)this.actual));
        }
    }

    public SELF isNotAnnotation() {
        this.isNotNull();
        this.assertIsNotAnnotation();
        return (SELF)((AbstractClassAssert)this.myself);
    }

    private void assertIsNotAnnotation() {
        if (((Class)this.actual).isAnnotation()) {
            throw this.assertionError(ShouldBeAnnotation.shouldNotBeAnnotation((Class)this.actual));
        }
    }

    public SELF isRecord() {
        this.isNotNull();
        this.assertIsRecord();
        return (SELF)((AbstractClassAssert)this.myself);
    }

    private void assertIsRecord() {
        if (!AbstractClassAssert.isRecord((Class)this.actual)) {
            throw this.assertionError(ShouldBeRecord.shouldBeRecord((Class)this.actual));
        }
    }

    public SELF isNotRecord() {
        this.isNotNull();
        this.assertIsNotRecord();
        return (SELF)((AbstractClassAssert)this.myself);
    }

    private void assertIsNotRecord() {
        if (AbstractClassAssert.isRecord((Class)this.actual)) {
            throw this.assertionError(ShouldBeRecord.shouldNotBeRecord((Class)this.actual));
        }
    }

    private static boolean isRecord(Class<?> actual) {
        return actual.isRecord();
    }

    public SELF hasRecordComponents(String first, String ... rest) {
        this.isRecord();
        this.assertHasRecordComponents(first, rest);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    private void assertHasRecordComponents(String first, String[] rest) {
        LinkedHashSet<String> expectedRecordComponents = Sets.newLinkedHashSet();
        expectedRecordComponents.add(first);
        if (rest != null) {
            Collections.addAll(expectedRecordComponents, rest);
        }
        LinkedHashSet<String> missingRecordComponents = Sets.newLinkedHashSet();
        Set<String> actualRecordComponents = AbstractClassAssert.getRecordComponentNames((Class)this.actual);
        for (String name : expectedRecordComponents) {
            if (actualRecordComponents.contains(name)) continue;
            missingRecordComponents.add(name);
        }
        if (!missingRecordComponents.isEmpty()) {
            throw this.assertionError(ShouldHaveRecordComponents.shouldHaveRecordComponents((Class)this.actual, expectedRecordComponents, missingRecordComponents));
        }
    }

    private static Set<String> getRecordComponentNames(Class<?> actual) {
        try {
            Method getRecordComponents = Class.class.getMethod("getRecordComponents", new Class[0]);
            Object[] recordComponents = (Object[])getRecordComponents.invoke(actual, new Object[0]);
            LinkedHashSet<String> recordComponentNames = Sets.newLinkedHashSet();
            for (Object recordComponent : recordComponents) {
                Method getName = recordComponent.getClass().getMethod("getName", new Class[0]);
                recordComponentNames.add((String)getName.invoke(recordComponent, new Object[0]));
            }
            return recordComponentNames;
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException(e);
        }
    }

    public SELF isFinal() {
        this.isNotNull();
        this.assertIsFinal();
        return (SELF)((AbstractClassAssert)this.myself);
    }

    private void assertIsFinal() {
        if (!Modifier.isFinal(((Class)this.actual).getModifiers())) {
            throw this.assertionError(ClassModifierShouldBe.shouldBeFinal((Class)this.actual));
        }
    }

    public SELF isNotFinal() {
        this.isNotNull();
        this.assertIsNotFinal();
        return (SELF)((AbstractClassAssert)this.myself);
    }

    private void assertIsNotFinal() {
        if (Modifier.isFinal(((Class)this.actual).getModifiers())) {
            throw this.assertionError(ClassModifierShouldBe.shouldNotBeFinal((Class)this.actual));
        }
    }

    public SELF isPublic() {
        this.isNotNull();
        this.assertIsPublic();
        return (SELF)((AbstractClassAssert)this.myself);
    }

    private void assertIsPublic() {
        if (!Modifier.isPublic(((Class)this.actual).getModifiers())) {
            throw this.assertionError(ClassModifierShouldBe.shouldBePublic((Class)this.actual));
        }
    }

    public SELF isProtected() {
        this.isNotNull();
        this.assertIsProtected();
        return (SELF)((AbstractClassAssert)this.myself);
    }

    private void assertIsProtected() {
        if (!Modifier.isProtected(((Class)this.actual).getModifiers())) {
            throw this.assertionError(ClassModifierShouldBe.shouldBeProtected((Class)this.actual));
        }
    }

    public SELF isPackagePrivate() {
        this.isNotNull();
        this.assertIsPackagePrivate();
        return (SELF)((AbstractClassAssert)this.myself);
    }

    private void assertIsPackagePrivate() {
        int modifiers = ((Class)this.actual).getModifiers();
        if (Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers) || Modifier.isPrivate(modifiers)) {
            throw this.assertionError(ClassModifierShouldBe.shouldBePackagePrivate((Class)this.actual));
        }
    }

    public SELF isPrivate() {
        this.isNotNull();
        this.assertIsPrivate();
        return (SELF)((AbstractClassAssert)this.myself);
    }

    private void assertIsPrivate() {
        if (!Modifier.isPrivate(((Class)this.actual).getModifiers())) {
            throw this.assertionError(ClassModifierShouldBe.shouldBePrivate((Class)this.actual));
        }
    }

    public SELF isStatic() {
        this.isNotNull();
        this.assertIsStatic();
        return (SELF)((AbstractClassAssert)this.myself);
    }

    private void assertIsStatic() {
        if (!Modifier.isStatic(((Class)this.actual).getModifiers())) {
            throw this.assertionError(ClassModifierShouldBe.shouldBeStatic((Class)this.actual));
        }
    }

    public SELF isNotStatic() {
        this.isNotNull();
        this.assertIsNotStatic();
        return (SELF)((AbstractClassAssert)this.myself);
    }

    private void assertIsNotStatic() {
        if (Modifier.isStatic(((Class)this.actual).getModifiers())) {
            throw this.assertionError(ClassModifierShouldBe.shouldNotBeStatic((Class)this.actual));
        }
    }

    @SafeVarargs
    public final SELF hasAnnotations(Class<? extends Annotation> ... annotations) {
        return this.hasAnnotationsForProxy(annotations);
    }

    protected SELF hasAnnotationsForProxy(Class<? extends Annotation>[] annotations) {
        this.classes.assertContainsAnnotations(this.info, (Class)this.actual, annotations);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF hasAnnotation(Class<? extends Annotation> annotation) {
        this.classes.assertContainsAnnotations(this.info, (Class)this.actual, Arrays.array(annotation));
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF hasSuperclass(Class<?> superclass) {
        this.isNotNull();
        this.assertHasSuperclass(superclass);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    private void assertHasSuperclass(Class<?> superclass) {
        Objects.requireNonNull(superclass, ShouldNotBeNull.shouldNotBeNull("superclass")::create);
        Class actualSuperclass = ((Class)this.actual).getSuperclass();
        if (actualSuperclass == null || !actualSuperclass.equals(superclass)) {
            throw this.assertionError(ShouldHaveSuperclass.shouldHaveSuperclass((Class)this.actual, superclass));
        }
    }

    public SELF hasNoSuperclass() {
        this.isNotNull();
        this.assertHasNoSuperclass();
        return (SELF)((AbstractClassAssert)this.myself);
    }

    private void assertHasNoSuperclass() {
        if (((Class)this.actual).getSuperclass() != null) {
            throw this.assertionError(ShouldHaveNoSuperclass.shouldHaveNoSuperclass((Class)this.actual));
        }
    }

    @Deprecated(since="3", forRemoval=true)
    public SELF hasFields(String ... fields) {
        return this.hasPublicFields(fields);
    }

    public SELF hasPublicFields(String ... fields) {
        this.classes.assertHasPublicFields(this.info, (Class)this.actual, fields);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF hasOnlyPublicFields(String ... fields) {
        this.classes.assertHasOnlyPublicFields(this.info, (Class)this.actual, fields);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF hasDeclaredFields(String ... fields) {
        this.classes.assertHasDeclaredFields(this.info, (Class)this.actual, fields);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF hasOnlyDeclaredFields(String ... fields) {
        this.classes.assertHasOnlyDeclaredFields(this.info, (Class)this.actual, fields);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF hasMethods(String ... methodNames) {
        this.classes.assertHasMethods(this.info, (Class)this.actual, methodNames);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF hasDeclaredMethods(String ... methodNames) {
        this.classes.assertHasDeclaredMethods(this.info, (Class)this.actual, methodNames);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF hasPublicMethods(String ... methodNames) {
        this.classes.assertHasPublicMethods(this.info, (Class)this.actual, methodNames);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF hasPackage(String expected) {
        this.isNotNull();
        this.assertHasPackage(expected);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    private void assertHasPackage(String packageName) {
        Objects.requireNonNull(packageName, ShouldNotBeNull.shouldNotBeNull("expected")::create);
        Package actualPackage = ((Class)this.actual).getPackage();
        if (actualPackage == null || !actualPackage.getName().equals(packageName)) {
            throw this.assertionError(ShouldHavePackage.shouldHavePackage((Class)this.actual, packageName));
        }
    }

    public SELF hasPackage(Package expected) {
        this.isNotNull();
        this.assertHasPackage(expected);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    private void assertHasPackage(Package expected) {
        Objects.requireNonNull(expected, ShouldNotBeNull.shouldNotBeNull("expected")::create);
        if (!expected.equals(((Class)this.actual).getPackage())) {
            throw this.assertionError(ShouldHavePackage.shouldHavePackage((Class)this.actual, expected));
        }
    }

    public SELF hasNoPackage() {
        this.isNotNull();
        this.assertHasNoPackage();
        return (SELF)((AbstractClassAssert)this.myself);
    }

    private void assertHasNoPackage() {
        if (((Class)this.actual).getPackage() != null) {
            throw this.assertionError(ShouldHaveNoPackage.shouldHaveNoPackage((Class)this.actual));
        }
    }

    public SELF isSealed() {
        this.isNotNull();
        this.assertIsSealed();
        return (SELF)((AbstractClassAssert)this.myself);
    }

    private void assertIsSealed() {
        if (!AbstractClassAssert.isSealed((Class)this.actual)) {
            throw this.assertionError(ShouldBeSealed.shouldBeSealed((Class)this.actual));
        }
    }

    public SELF isNotSealed() {
        this.isNotNull();
        this.assertIsNotSealed();
        return (SELF)((AbstractClassAssert)this.myself);
    }

    private void assertIsNotSealed() {
        if (AbstractClassAssert.isSealed((Class)this.actual)) {
            throw this.assertionError(ShouldBeSealed.shouldNotBeSealed((Class)this.actual));
        }
    }

    private static boolean isSealed(Class<?> actual) {
        return actual.isSealed();
    }

    public SELF hasPermittedSubclasses(Class<?> ... permittedSubclasses) {
        this.isNotNull();
        this.assertHasPermittedSubclasses(permittedSubclasses);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    private void assertHasPermittedSubclasses(Class<?>[] expectedPermittedSubclasses) {
        for (Class<?> expectedPermittedSubclass2 : expectedPermittedSubclasses) {
            this.classes.classParameterIsNotNull(expectedPermittedSubclass2);
        }
        LinkedHashSet<Class<?>> actualPermittedSubclasses = Sets.newLinkedHashSet(AbstractClassAssert.getPermittedSubclasses((Class)this.actual));
        Set<Class<?>> missingPermittedSubclasses = Stream.of(expectedPermittedSubclasses).filter(expectedPermittedSubclass -> !actualPermittedSubclasses.contains(expectedPermittedSubclass)).collect(Collectors.toSet());
        if (!missingPermittedSubclasses.isEmpty()) {
            throw this.assertionError(ShouldHavePermittedSubclasses.shouldHavePermittedSubclasses((Class)this.actual, expectedPermittedSubclasses, missingPermittedSubclasses));
        }
    }

    private static Class<?>[] getPermittedSubclasses(Class<?> actual) {
        try {
            Method getPermittedSubclasses = Class.class.getMethod("getPermittedSubclasses", new Class[0]);
            Class[] permittedSubclasses = (Class[])getPermittedSubclasses.invoke(actual, new Object[0]);
            return permittedSubclasses == null ? Arrays.array(new Class[0]) : permittedSubclasses;
        }
        catch (NoSuchMethodException e) {
            return new Class[0];
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException(e);
        }
    }

    public SELF isPrimitive() {
        this.isNotNull();
        if (!((Class)this.actual).isPrimitive()) {
            throw this.assertionError(ShouldBePrimitive.shouldBePrimitive((Class)this.actual));
        }
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF isNotPrimitive() {
        this.isNotNull();
        if (((Class)this.actual).isPrimitive()) {
            throw this.assertionError(ShouldNotBePrimitive.shouldNotBePrimitive((Class)this.actual));
        }
        return (SELF)((AbstractClassAssert)this.myself);
    }
}

