/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.validation.checkers.declaration;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.validation.checkers.IrElementChecker;
import org.jetbrains.kotlin.ir.validation.checkers.context.CheckerContext;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/ir/validation/checkers/declaration/IrConstructorReceiverChecker;", "Lorg/jetbrains/kotlin/ir/validation/checkers/IrElementChecker;", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "<init>", "()V", "check", "", "element", "context", "Lorg/jetbrains/kotlin/ir/validation/checkers/context/CheckerContext;", "ir.validation"})
@SourceDebugExtension(value={"SMAP\nIrConstructorReceiverChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrConstructorReceiverChecker.kt\norg/jetbrains/kotlin/ir/validation/checkers/declaration/IrConstructorReceiverChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,24:1\n1807#2,3:25\n*S KotlinDebug\n*F\n+ 1 IrConstructorReceiverChecker.kt\norg/jetbrains/kotlin/ir/validation/checkers/declaration/IrConstructorReceiverChecker\n*L\n19#1:25,3\n*E\n"})
public final class IrConstructorReceiverChecker
extends IrElementChecker<IrConstructor> {
    @NotNull
    public static final IrConstructorReceiverChecker INSTANCE = new IrConstructorReceiverChecker();

    private IrConstructorReceiverChecker() {
        super(Reflection.getOrCreateKotlinClass(IrConstructor.class));
    }

    @Override
    public void check(@NotNull IrConstructor element, @NotNull CheckerContext context2) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            if (!AdditionalIrUtilsKt.getConstructedClass(element).isInner() && element.getDispatchReceiverParameter() != null) {
                context2.error(this, element, "Constructors of non-inner classes can't have dispatch receiver parameters");
            }
            Iterable $this$any$iv = element.getParameters();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrValueParameter it = (IrValueParameter)element$iv;
                    boolean bl2 = false;
                    if (!(it.getKind() == IrParameterKind.ExtensionReceiver)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            context2.error(this, element, "Constructors can't have extension receiver parameters");
        }
    }
}

