/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.settings;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.util.PaintAwarePanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.panels.ListLayout;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.target.GradleRuntimeTargetUI;
import org.jetbrains.plugins.gradle.execution.target.GradleTargetUtil;
import org.jetbrains.plugins.gradle.execution.target.TargetPathFieldWithBrowseButton;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.service.execution.BuildLayoutParameters;
import org.jetbrains.plugins.gradle.service.settings.GradleSettingsControl;
import org.jetbrains.plugins.gradle.service.settings.GradleSystemSettingsControlBuilder;
import org.jetbrains.plugins.gradle.service.settings.IdeaGradleDefaultProjectSettingsControl;
import org.jetbrains.plugins.gradle.service.settings.IdeaGradleProjectSettingsControlBuilder;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.statistics.GradleActionsUsagesCollector;
import org.jetbrains.plugins.gradle.util.GradleBundle;

public class IdeaGradleSystemSettingsControlBuilder
implements GradleSystemSettingsControlBuilder {
    @NotNull
    private final GradleSettings myInitialSettings;
    private boolean dropVmOptions;
    private boolean dropStoreExternallyCheckBox;
    private boolean dropDefaultProjectSettings;
    private boolean dropParallelModelFetchCheckBox;
    @Nullable
    private JBLabel myServiceDirectoryLabel;
    @Nullable
    private JBLabel myServiceDirectoryHint;
    @Nullable
    private TargetPathFieldWithBrowseButton myServiceDirectoryPathField;
    @Nullable
    private JBTextField myGradleVmOptionsField;
    @NotNull
    private List<Component> myGradleVmOptionsComponents;
    @Nullable
    private JBCheckBox myGenerateImlFilesCheckBox;
    @Nullable
    private JBLabel myGenerateImlFilesHint;
    @Nullable
    private JBCheckBox myParallelModelFetchCheckBox;
    @Nullable
    private JPanel myParallelModelFetchPanel;
    @Nullable
    private JBLabel myParallelModelFetchWarning;
    @Nullable
    private JBLabel myParallelModelFetchHint;
    @NotNull
    private final GradleSettingsControl myDefaultProjectSettingsControl;
    private static final Pattern VM_OPTIONS_REGEX = Pattern.compile("^(\\s*\"?org\\.gradle\\.jvmargs\"?\\s*[=:]).*?(?<!\\\\)($)", 40);

    public IdeaGradleSystemSettingsControlBuilder(@NotNull GradleSettings initialSettings) {
        if (initialSettings == null) {
            IdeaGradleSystemSettingsControlBuilder.$$$reportNull$$$0(0);
        }
        this.myGradleVmOptionsComponents = new ArrayList<Component>();
        this.myDefaultProjectSettingsControl = new IdeaGradleDefaultProjectSettingsControl();
        this.myInitialSettings = initialSettings;
    }

    public IdeaGradleSystemSettingsControlBuilder dropStoreExternallyCheckBox() {
        this.dropStoreExternallyCheckBox = true;
        return this;
    }

    public IdeaGradleSystemSettingsControlBuilder dropVmOptions() {
        this.dropVmOptions = true;
        return this;
    }

    public IdeaGradleSystemSettingsControlBuilder dropDefaultProjectSettings() {
        this.dropDefaultProjectSettings = true;
        return this;
    }

    public IdeaGradleSystemSettingsControlBuilder dropParallelModelFetchCheckBox() {
        this.dropParallelModelFetchCheckBox = true;
        return this;
    }

    @Override
    public void fillUi(@NotNull PaintAwarePanel canvas, int indentLevel) {
        if (canvas == null) {
            IdeaGradleSystemSettingsControlBuilder.$$$reportNull$$$0(1);
        }
        this.addServiceDirectoryControl(canvas, indentLevel);
        if (!this.dropVmOptions) {
            this.addVMOptionsControl(canvas, indentLevel);
        }
        if (!this.dropStoreExternallyCheckBox) {
            this.addStoreExternallyCheckBox(canvas, indentLevel);
        }
        if (!this.dropParallelModelFetchCheckBox) {
            this.addParallelModelFetchCheckBox(canvas, indentLevel);
        }
        if (!this.dropDefaultProjectSettings) {
            this.myDefaultProjectSettingsControl.fillUi(canvas, indentLevel);
        }
    }

    @Override
    public void showUi(boolean show) {
        ExternalSystemUiUtil.showUi((Object)this, (boolean)show);
        this.myDefaultProjectSettingsControl.showUi(show);
    }

    @Override
    public void reset() {
        if (this.myServiceDirectoryPathField != null) {
            BuildLayoutParameters buildLayoutParameters = GradleInstallationManager.defaultBuildLayoutParameters(this.myInitialSettings.getProject());
            Path gradleUserHomeDir2 = GradleTargetUtil.maybeGetTargetValue(buildLayoutParameters.getGradleUserHomePath());
            if (gradleUserHomeDir2 != null) {
                ((JBTextField)this.myServiceDirectoryPathField.getTextField()).getEmptyText().setText(gradleUserHomeDir2.toString());
            }
            this.myServiceDirectoryPathField.setLocalPath(this.myInitialSettings.getServiceDirectoryPath());
        }
        if (this.myGradleVmOptionsField != null) {
            String vmOptions = IdeaGradleSystemSettingsControlBuilder.trimIfPossible(this.myInitialSettings.getGradleVmOptions());
            this.myGradleVmOptionsField.setText(vmOptions);
            this.myGradleVmOptionsComponents.forEach(it -> {
                boolean showSetting = vmOptions != null || Registry.is((String)"gradle.settings.showDeprecatedSettings", (boolean)false);
                it.setVisible(showSetting);
            });
        }
        if (this.myGenerateImlFilesCheckBox != null) {
            this.myGenerateImlFilesCheckBox.setSelected(!this.myInitialSettings.getStoreProjectFilesExternally());
        }
        if (this.myParallelModelFetchCheckBox != null) {
            this.myParallelModelFetchCheckBox.setSelected(this.myInitialSettings.isParallelModelFetch());
        }
        this.myDefaultProjectSettingsControl.reset();
    }

    @Override
    public boolean isModified() {
        if (this.myServiceDirectoryPathField != null && !Objects.equals(ExternalSystemApiUtil.normalizePath((String)this.myServiceDirectoryPathField.getLocalPath()), ExternalSystemApiUtil.normalizePath((String)this.myInitialSettings.getServiceDirectoryPath()))) {
            return true;
        }
        if (this.myGradleVmOptionsField != null && !Objects.equals(IdeaGradleSystemSettingsControlBuilder.trimIfPossible(this.myGradleVmOptionsField.getText()), IdeaGradleSystemSettingsControlBuilder.trimIfPossible(this.myInitialSettings.getGradleVmOptions()))) {
            return true;
        }
        if (this.myGenerateImlFilesCheckBox != null && this.myGenerateImlFilesCheckBox.isSelected() == this.myInitialSettings.getStoreProjectFilesExternally()) {
            return true;
        }
        if (this.myParallelModelFetchCheckBox != null && this.myParallelModelFetchCheckBox.isSelected() != this.myInitialSettings.isParallelModelFetch()) {
            return true;
        }
        return this.myDefaultProjectSettingsControl.isModified();
    }

    @Override
    public void apply(@NotNull GradleSettings settings) {
        if (settings == null) {
            IdeaGradleSystemSettingsControlBuilder.$$$reportNull$$$0(2);
        }
        if (this.myServiceDirectoryPathField != null) {
            String serviceDirectoryPath = IdeaGradleSystemSettingsControlBuilder.trimIfPossible(this.myServiceDirectoryPathField.getLocalPath());
            settings.setServiceDirectoryPath(ExternalSystemApiUtil.normalizePath((String)serviceDirectoryPath));
        }
        if (this.myGradleVmOptionsField != null) {
            settings.setGradleVmOptions(IdeaGradleSystemSettingsControlBuilder.trimIfPossible(this.myGradleVmOptionsField.getText()));
        }
        if (this.myGenerateImlFilesCheckBox != null) {
            settings.setStoreProjectFilesExternally(!this.myGenerateImlFilesCheckBox.isSelected());
        }
        if (this.myParallelModelFetchCheckBox != null) {
            if (settings.isParallelModelFetch() != this.myParallelModelFetchCheckBox.isSelected()) {
                GradleActionsUsagesCollector.TOGGLE_PARALLEL_FETCH.log(settings.getProject(), (Object)this.myParallelModelFetchCheckBox.isSelected());
            }
            settings.setParallelModelFetch(this.myParallelModelFetchCheckBox.isSelected());
        }
        this.myDefaultProjectSettingsControl.apply();
    }

    @Override
    public boolean validate(@NotNull GradleSettings settings) {
        if (settings == null) {
            IdeaGradleSystemSettingsControlBuilder.$$$reportNull$$$0(3);
        }
        return this.myDefaultProjectSettingsControl.validate();
    }

    @Override
    public void disposeUIResources() {
        ExternalSystemUiUtil.disposeUi((Object)this);
        this.myDefaultProjectSettingsControl.disposeUiResources();
    }

    @Override
    @NotNull
    public GradleSettings getInitialSettings() {
        GradleSettings gradleSettings = this.myInitialSettings;
        if (gradleSettings == null) {
            IdeaGradleSystemSettingsControlBuilder.$$$reportNull$$$0(4);
        }
        return gradleSettings;
    }

    private void addServiceDirectoryControl(PaintAwarePanel canvas, int indentLevel) {
        this.myServiceDirectoryLabel = new JBLabel(GradleBundle.message("gradle.settings.text.user.home", new Object[0]));
        this.myServiceDirectoryPathField = GradleRuntimeTargetUI.targetPathFieldWithBrowseButton(this.myInitialSettings.getProject(), GradleBundle.message("gradle.settings.text.user.home.dialog.title", new Object[0]));
        this.myServiceDirectoryLabel.setLabelFor((Component)((Object)this.myServiceDirectoryPathField));
        canvas.add((Component)this.myServiceDirectoryLabel, (Object)ExternalSystemUiUtil.getLabelConstraints((int)indentLevel));
        canvas.add((Component)((Object)this.myServiceDirectoryPathField), (Object)ExternalSystemUiUtil.getFillLineConstraints((int)indentLevel));
        this.myServiceDirectoryHint = IdeaGradleSystemSettingsControlBuilder.addComment(canvas, XmlStringUtil.wrapInHtml((CharSequence)GradleBundle.message("gradle.settings.text.user.home.hint", new Object[0])), ExternalSystemUiUtil.getCommentConstraints((int)indentLevel));
    }

    private void addVMOptionsControl(@NotNull PaintAwarePanel canvas, int indentLevel) {
        if (canvas == null) {
            IdeaGradleSystemSettingsControlBuilder.$$$reportNull$$$0(5);
        }
        JBLabel label = new JBLabel(GradleBundle.message("gradle.settings.text.vm.options", new Object[0]));
        canvas.add((Component)label, (Object)ExternalSystemUiUtil.getLabelConstraints((int)indentLevel));
        this.myGradleVmOptionsComponents.add((Component)label);
        this.myGradleVmOptionsField = new JBTextField();
        canvas.add((Component)this.myGradleVmOptionsField, (Object)ExternalSystemUiUtil.getFillLineConstraints((int)indentLevel));
        this.myGradleVmOptionsComponents.add((Component)this.myGradleVmOptionsField);
        label.setLabelFor((Component)this.myGradleVmOptionsField);
        Component glue = Box.createGlue();
        canvas.add(glue, (Object)ExternalSystemUiUtil.getLabelConstraints((int)indentLevel));
        this.myGradleVmOptionsComponents.add(glue);
        final HyperlinkLabel fixLabel = new HyperlinkLabel();
        fixLabel.setFontSize(UIUtil.FontSize.SMALL);
        fixLabel.setForeground(UIUtil.getLabelFontColor((UIUtil.FontColor)UIUtil.FontColor.BRIGHTER));
        fixLabel.setIcon(AllIcons.General.BalloonWarning12);
        label.setVerticalTextPosition(1);
        GridBag constraints = ExternalSystemUiUtil.getFillLineConstraints((int)indentLevel);
        constraints.insets.top = 0;
        canvas.add((Component)fixLabel, (Object)constraints);
        this.myGradleVmOptionsComponents.add((Component)fixLabel);
        this.myGradleVmOptionsField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(this){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                boolean showMigration = e.getDocument().getLength() > 0;
                fixLabel.setHyperlinkText(GradleBundle.message("gradle.settings.text.vm.options.link.tooltip", new Object[0]) + " ", showMigration ? GradleBundle.message("gradle.settings.text.vm.options.link.text", new Object[0]) : "  ", "");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/gradle/service/settings/IdeaGradleSystemSettingsControlBuilder$1", "textChanged"));
            }
        });
        this.myGradleVmOptionsField.setText(" ");
        fixLabel.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                String jvmArgs;
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((jvmArgs = IdeaGradleSystemSettingsControlBuilder.this.myGradleVmOptionsField.getText().trim()).isEmpty()) {
                    return;
                }
                if (IdeaGradleSystemSettingsControlBuilder.this.moveVMOptionsToGradleProperties(jvmArgs, IdeaGradleSystemSettingsControlBuilder.this.myInitialSettings)) {
                    IdeaGradleSystemSettingsControlBuilder.this.myGradleVmOptionsField.setText(null);
                    IdeaGradleSystemSettingsControlBuilder.this.myGradleVmOptionsField.getEmptyText().setText(GradleBundle.message("gradle.settings.text.vm.options.empty.text", new Object[0]));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/gradle/service/settings/IdeaGradleSystemSettingsControlBuilder$2", "hyperlinkActivated"));
            }
        });
    }

    private void addStoreExternallyCheckBox(@NotNull PaintAwarePanel canvas, int indentLevel) {
        if (canvas == null) {
            IdeaGradleSystemSettingsControlBuilder.$$$reportNull$$$0(6);
        }
        this.myGenerateImlFilesCheckBox = new JBCheckBox(GradleBundle.message("gradle.settings.text.generate.iml.files", new Object[0]));
        canvas.add((Component)this.myGenerateImlFilesCheckBox, (Object)ExternalSystemUiUtil.getFillLineConstraints((int)indentLevel));
        this.myGenerateImlFilesHint = IdeaGradleSystemSettingsControlBuilder.addComment(canvas, XmlStringUtil.wrapInHtml((CharSequence)GradleBundle.message("gradle.settings.text.generate.iml.files.hint", IdeaGradleProjectSettingsControlBuilder.getIDEName())), ExternalSystemUiUtil.getCheckBoxCommentConstraints((int)indentLevel, (JCheckBox)this.myGenerateImlFilesCheckBox));
    }

    private void addParallelModelFetchCheckBox(@NotNull PaintAwarePanel canvas, int indentLevel) {
        if (canvas == null) {
            IdeaGradleSystemSettingsControlBuilder.$$$reportNull$$$0(7);
        }
        this.myParallelModelFetchCheckBox = new JBCheckBox(GradleBundle.message("gradle.settings.text.parallelModelFetch", new Object[0]));
        this.myParallelModelFetchWarning = new JBLabel(AllIcons.General.Warning);
        this.myParallelModelFetchWarning.setToolTipText(GradleBundle.message("gradle.settings.text.parallelModelFetch.warning", new Object[0]));
        this.myParallelModelFetchPanel = new JPanel((LayoutManager)ListLayout.horizontal((int)5, (ListLayout.Alignment)ListLayout.Alignment.CENTER, (ListLayout.GrowPolicy)ListLayout.GrowPolicy.NO_GROW));
        this.myParallelModelFetchPanel.add((Component)this.myParallelModelFetchCheckBox);
        this.myParallelModelFetchPanel.add((Component)this.myParallelModelFetchWarning);
        canvas.add((Component)this.myParallelModelFetchPanel, (Object)ExternalSystemUiUtil.getFillLineConstraints((int)indentLevel));
        this.myParallelModelFetchHint = IdeaGradleSystemSettingsControlBuilder.addComment(canvas, GradleBundle.message("gradle.settings.text.parallelModelFetch.hint", new Object[0]), ExternalSystemUiUtil.getCheckBoxCommentConstraints((int)indentLevel, (JCheckBox)this.myParallelModelFetchCheckBox));
    }

    @NotNull
    private static JBLabel addComment(@NotNull PaintAwarePanel canvas, @NlsContexts.Label @NotNull String text, @NotNull GridBag constraints) {
        if (canvas == null) {
            IdeaGradleSystemSettingsControlBuilder.$$$reportNull$$$0(8);
        }
        if (text == null) {
            IdeaGradleSystemSettingsControlBuilder.$$$reportNull$$$0(9);
        }
        if (constraints == null) {
            IdeaGradleSystemSettingsControlBuilder.$$$reportNull$$$0(10);
        }
        JBLabel label = new JBLabel(text);
        label.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        label.setForeground(UIUtil.getLabelFontColor((UIUtil.FontColor)UIUtil.FontColor.BRIGHTER));
        canvas.add((Component)label, (Object)constraints);
        JBLabel jBLabel = label;
        if (jBLabel == null) {
            IdeaGradleSystemSettingsControlBuilder.$$$reportNull$$$0(11);
        }
        return jBLabel;
    }

    @Nullable
    private static String trimIfPossible(@Nullable String s) {
        return StringUtil.nullize((String)StringUtil.trim((String)s));
    }

    private boolean moveVMOptionsToGradleProperties(@NotNull String vmOptions, @NotNull GradleSettings settings) {
        int result;
        String fieldText;
        if (vmOptions == null) {
            IdeaGradleSystemSettingsControlBuilder.$$$reportNull$$$0(12);
        }
        if (settings == null) {
            IdeaGradleSystemSettingsControlBuilder.$$$reportNull$$$0(13);
        }
        File gradleUserHomeDir2 = null;
        if (this.myServiceDirectoryPathField != null && (fieldText = IdeaGradleSystemSettingsControlBuilder.trimIfPossible(this.myServiceDirectoryPathField.getText())) != null) {
            gradleUserHomeDir2 = new File(fieldText);
        }
        if (gradleUserHomeDir2 == null) {
            BuildLayoutParameters buildLayoutParameters = GradleInstallationManager.defaultBuildLayoutParameters(settings.getProject());
            Path gradleUserHome = GradleTargetUtil.maybeGetLocalValue(buildLayoutParameters.getGradleUserHomePath());
            if (gradleUserHome == null) {
                Messages.showErrorDialog((Project)settings.getProject(), (String)GradleBundle.message("gradle.settings.text.vm.options.migration.error.text", GradleBundle.message("gradle.settings.text.user.home.not.found.error.text", new Object[0])), (String)GradleBundle.message("gradle.settings.text.vm.options.migration.error.title", new Object[0]));
                return false;
            }
            gradleUserHomeDir2 = gradleUserHome.toFile();
        }
        if ((result = Messages.showYesNoDialog((Project)settings.getProject(), (String)GradleBundle.message("gradle.settings.text.vm.options.confirm.text", new File(gradleUserHomeDir2, "gradle.properties")), (String)GradleBundle.message("gradle.title.gradle.settings", new Object[0]), (Icon)Messages.getQuestionIcon())) != 0) {
            return false;
        }
        try {
            String updated;
            if (!gradleUserHomeDir2.exists() && !FileUtil.createDirectory((File)gradleUserHomeDir2)) {
                throw new IOException("Cannot create " + String.valueOf(gradleUserHomeDir2));
            }
            File props = new File(gradleUserHomeDir2, "gradle.properties");
            if (props.isDirectory()) {
                throw new IOException(props.getPath() + " is a directory");
            }
            String original = props.exists() ? FileUtil.loadFile((File)props) : "";
            if (!original.equals(updated = IdeaGradleSystemSettingsControlBuilder.updateVMOptions(original, vmOptions))) {
                FileUtil.writeToFile((File)props, (String)updated);
            }
        }
        catch (IOException e) {
            Messages.showErrorDialog((Project)settings.getProject(), (String)GradleBundle.message("gradle.settings.text.vm.options.migration.error.text", e.getMessage()), (String)GradleBundle.message("gradle.settings.text.vm.options.migration.error.title", new Object[0]));
            return false;
        }
        return true;
    }

    @NotNull
    public static String updateVMOptions(@NotNull String originalText, @NotNull String vmOptions) {
        if (originalText == null) {
            IdeaGradleSystemSettingsControlBuilder.$$$reportNull$$$0(14);
        }
        if (vmOptions == null) {
            IdeaGradleSystemSettingsControlBuilder.$$$reportNull$$$0(15);
        }
        Matcher matcher = VM_OPTIONS_REGEX.matcher(originalText);
        StringBuilder result = new StringBuilder(originalText.length() + vmOptions.length());
        String escapedValue = StringUtil.escapeProperty((String)vmOptions, (boolean)false);
        if (matcher.find()) {
            matcher.appendReplacement(result, "$1" + Matcher.quoteReplacement(escapedValue) + "$2");
            matcher.appendTail(result);
        } else {
            result.append(originalText);
            if (!originalText.isEmpty() && !originalText.endsWith("\n")) {
                result.append("\n");
            }
            result.append("org.gradle.jvmargs=").append(escapedValue).append("\n");
        }
        String string = result.toString();
        if (string == null) {
            IdeaGradleSystemSettingsControlBuilder.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 11, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialSettings";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canvas";
                break;
            }
            case 2: 
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/settings/IdeaGradleSystemSettingsControlBuilder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraints";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmOptions";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/settings/IdeaGradleSystemSettingsControlBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialSettings";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "addComment";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "updateVMOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "fillUi";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 4: 
            case 11: 
            case 16: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addVMOptionsControl";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addStoreExternallyCheckBox";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addParallelModelFetchCheckBox";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addComment";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "moveVMOptionsToGradleProperties";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateVMOptions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 11, 16 -> new IllegalStateException(string);
        };
    }
}

