/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.DynamicBundle;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Pair;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtilRt;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomBundle;

public class EditMavenPropertyDialog
extends DialogWrapper {
    private JPanel contentPane;
    private JComboBox myNameBox;
    private JTextField myValueField;
    private final Map<String, String> myAvailableProperties;

    public EditMavenPropertyDialog(@Nullable Pair<String, String> value, Map<String, String> availableProperties) {
        super(false);
        this.$$$setupUI$$$();
        this.setTitle(MavenDomBundle.message(value == null ? "property.title.add" : "property.title.edit", new Object[0]));
        this.myAvailableProperties = availableProperties;
        this.installFocusListeners();
        this.fillAvailableProperties();
        if (value != null) {
            this.myNameBox.getEditor().setItem(value.getFirst());
            this.myValueField.setText((String)value.getSecond());
        }
        this.installPropertySelectionListener();
        this.init();
    }

    private void installFocusListeners() {
        this.myNameBox.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                EditMavenPropertyDialog.this.myNameBox.getEditor().selectAll();
            }
        });
        this.myValueField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                EditMavenPropertyDialog.this.myValueField.selectAll();
            }
        });
    }

    private void installPropertySelectionListener() {
        this.myNameBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                String key = (String)e.getItem();
                String value = EditMavenPropertyDialog.this.myAvailableProperties.get(key);
                if (value != null) {
                    EditMavenPropertyDialog.this.myValueField.setText(value);
                }
            }
        });
    }

    private void fillAvailableProperties() {
        Object[] keys = ArrayUtilRt.toStringArray(this.myAvailableProperties.keySet());
        Arrays.sort(keys);
        this.myNameBox.setModel(new DefaultComboBoxModel<Object>(keys));
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.contentPane;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameBox;
    }

    public Pair<String, String> getValue() {
        return Pair.create((Object)((String)this.myNameBox.getEditor().getItem()), (Object)this.myValueField.getText());
    }

    protected String getDimensionServiceKey() {
        return "#org.jetbrains.idea.maven.execution.EditMavenPropertyDialog";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JComboBox jComboBox;
        JPanel jPanel;
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myNameBox = jComboBox = new JComboBox();
        jComboBox.setEditable(true);
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myValueField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/MavenDomBundle", EditMavenPropertyDialog.class).getString("property.introduce.name"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/MavenDomBundle", EditMavenPropertyDialog.class).getString("property.introduce.value"));
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

