/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.BasicStepMethodFilter;
import com.intellij.debugger.engine.BreakpointStepMethodFilter;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.LightOrRealThreadInfo;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.NamedMethodFilter;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.StepIntoMethodBreakpoint;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DexDebugFacility;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.StepIntoBreakpoint;
import com.intellij.debugger.ui.breakpoints.SteppingBreakpoint;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.util.Range;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.LocatableEvent;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.core.stepping.KotlinSteppingCommandProviderKt;
import org.jetbrains.kotlin.idea.debugger.core.stepping.filter.KotlinStepOverParamDefaultImplsMethodFilterKt;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinLambdaAsyncMethodFilter;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinLambdaInfo;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinLambdaMethodFilter;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinMethodFilter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 82\u00020\u0001:\u0003678B1\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001d\u0010\u0010\u001a\u0017\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J$\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u000e\u0010\u001d\u001a\u0004\u0018\u00010\u001e*\u00020\u001fH\u0002J\u001a\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u0016J\u001c\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u0002J\u000e\u0010)\u001a\u0004\u0018\u00010**\u00020\u001aH\u0002J\u0010\u0010+\u001a\u00020\u00142\u0006\u0010,\u001a\u00020-H\u0002J\u001c\u0010.\u001a\u00020\u0014*\u00020*2\u0006\u0010#\u001a\u00020/2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001c\u00100\u001a\u00020\u0014*\u00020*2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u0006H\u0002J\u001c\u00104\u001a\u00020\u0014*\u00020*2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u0006H\u0002J\u001c\u00105\u001a\u00020\u0014*\u00020*2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u0006H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010 \u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001cR\u0014\u0010!\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001c\u00a8\u00069"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinLambdaAsyncMethodFilter;", "Lcom/intellij/debugger/engine/MethodFilter;", "element", "Lcom/intellij/psi/PsiElement;", "callingExpressionLines", "Lcom/intellij/util/Range;", "", "lambdaInfo", "Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinLambdaInfo;", "lambdaFilter", "Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinLambdaMethodFilter;", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/util/Range;Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinLambdaInfo;Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinLambdaMethodFilter;)V", "visitedLocations", "methodFilter", "Lcom/intellij/debugger/engine/NamedMethodFilter;", "getCallingExpressionLines", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/Nullable;", "locationMatches", "", "process", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "location", "Lcom/sun/jdi/Location;", "frameProxy", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "isCallerMethodSuspend", "()Z", "getLambdaMethod", "Lcom/sun/jdi/Method;", "Lcom/sun/jdi/ReferenceType;", "isAsyncSuspendLambda", "isSameCoroutineSuspendLambda", "onReached", "context", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "hint", "Lcom/intellij/debugger/engine/RequestHint;", "createBreakpoint", "Lcom/intellij/debugger/ui/breakpoints/SteppingBreakpoint;", "getLambdaReference", "Lcom/sun/jdi/ObjectReference;", "isTargetLambdaName", "name", "", "checkLambdaBreakpoint", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "isTargetLambda", "thread", "Lcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;", "frameIndex", "checkLambdaId", "checkLambdaType", "AsyncSuspendLambdaBreakpoint", "KotlinLambdaInstanceBreakpoint", "Companion", "intellij.kotlin.jvm.debugger.core"})
@SourceDebugExtension(value={"SMAP\nKotlinLambdaAsyncMethodFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinLambdaAsyncMethodFilter.kt\norg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinLambdaAsyncMethodFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,284:1\n295#2,2:285\n626#2,12:287\n*S KotlinDebug\n*F\n+ 1 KotlinLambdaAsyncMethodFilter.kt\norg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinLambdaAsyncMethodFilter\n*L\n75#1:285,2\n123#1:287,12\n*E\n"})
public final class KotlinLambdaAsyncMethodFilter
implements MethodFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KotlinLambdaInfo lambdaInfo;
    @NotNull
    private final KotlinLambdaMethodFilter lambdaFilter;
    private int visitedLocations;
    @NotNull
    private final NamedMethodFilter methodFilter;
    @NotNull
    private static final String CREATE = "create";
    @NotNull
    private static final String INVOKE_SUSPEND = "invokeSuspend";

    public KotlinLambdaAsyncMethodFilter(@Nullable PsiElement element, @Nullable Range<Integer> callingExpressionLines, @NotNull KotlinLambdaInfo lambdaInfo, @NotNull KotlinLambdaMethodFilter lambdaFilter) {
        Intrinsics.checkNotNullParameter((Object)lambdaInfo, (String)"lambdaInfo");
        Intrinsics.checkNotNullParameter((Object)lambdaFilter, (String)"lambdaFilter");
        this.lambdaInfo = lambdaInfo;
        this.lambdaFilter = lambdaFilter;
        this.methodFilter = element instanceof PsiMethod ? (NamedMethodFilter)new BasicStepMethodFilter((PsiMethod)element, this.lambdaInfo.getCallerMethodInfo().getOrdinal(), callingExpressionLines) : (NamedMethodFilter)new KotlinMethodFilter(element, callingExpressionLines, this.lambdaInfo.getCallerMethodInfo());
    }

    @Nullable
    public Range<Integer> getCallingExpressionLines() {
        return this.methodFilter.getCallingExpressionLines();
    }

    public boolean locationMatches(@NotNull DebugProcessImpl process2, @NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return this.locationMatches(process2, location, null);
    }

    public boolean locationMatches(@NotNull DebugProcessImpl process2, @Nullable Location location, @Nullable StackFrameProxyImpl frameProxy) {
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        if (frameProxy == null || !this.methodFilter.locationMatches(process2, location, frameProxy)) {
            return false;
        }
        int n = this.visitedLocations;
        this.visitedLocations = n + 1;
        ObjectReference objectReference = this.getLambdaReference(frameProxy);
        if (objectReference == null) {
            return false;
        }
        ObjectReference lambdaReference = objectReference;
        ReferenceType referenceType = lambdaReference.referenceType();
        Intrinsics.checkNotNullExpressionValue((Object)referenceType, (String)"referenceType(...)");
        Method method = this.getLambdaMethod(referenceType);
        if (method == null) {
            return false;
        }
        Method lambdaMethod = method;
        Location locationInLambda = (Location)CollectionsKt.firstOrNull(SafeUtilKt.safeAllLineLocations(lambdaMethod));
        if (DebuggerUtil.isInvokeSuspendMethod(lambdaMethod) || locationInLambda == null) {
            return this.visitedLocations == 1 + this.lambdaInfo.getCallerMethodInfo().getOrdinal();
        }
        return this.lambdaFilter.locationMatches(process2, locationInLambda);
    }

    private final boolean isCallerMethodSuspend() {
        return this.lambdaInfo.getCallerMethodInfo().isSuspend();
    }

    private final Method getLambdaMethod(ReferenceType $this$getLambdaMethod) {
        Object v1;
        block1: {
            List<Method> list2 = $this$getLambdaMethod.methods();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"methods(...)");
            Iterable $this$firstOrNull$iv = list2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Method it = (Method)element$iv;
                boolean bl = false;
                if (!(it.isPublic() && !it.isBridge())) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    private final boolean isAsyncSuspendLambda() {
        return this.lambdaInfo.isSuspend() && !this.isCallerMethodSuspend();
    }

    private final boolean isSameCoroutineSuspendLambda() {
        return this.lambdaInfo.isSuspend() && this.isCallerMethodSuspend();
    }

    public int onReached(@NotNull SuspendContextImpl context2, @Nullable RequestHint hint2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        try {
            SteppingBreakpoint breakpoint2 = this.createBreakpoint(context2, hint2);
            if (breakpoint2 != null) {
                LightOrRealThreadInfo filterThread;
                if (this.isSameCoroutineSuspendLambda() && (filterThread = context2.getDebugProcess().getRequestsManager().getFilterThread()) != null) {
                    BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx((Project)context2.getDebugProcess().getProject()).getBreakpointManager();
                    Intrinsics.checkNotNullExpressionValue((Object)breakpointManager, (String)"getBreakpointManager(...)");
                    BreakpointManager breakpointManager2 = breakpointManager;
                    breakpointManager2.applyThreadFilter(context2.getDebugProcess(), filterThread);
                }
                DebugProcessImpl.prepareAndSetSteppingBreakpoint((SuspendContextImpl)context2, (SteppingBreakpoint)breakpoint2, (RequestHint)hint2, (!this.isCallerMethodSuspend() ? 1 : 0) != 0);
                return -100;
            }
        }
        catch (EvaluateException evaluateException) {
            // empty catch block
        }
        return 0;
    }

    private final SteppingBreakpoint createBreakpoint(SuspendContextImpl context2, RequestHint hint2) {
        Object object = context2.getFrameProxy();
        if (object == null || (object = this.getLambdaReference((StackFrameProxyImpl)object)) == null) {
            return null;
        }
        Object lambdaReference = object;
        if (this.isAsyncSuspendLambda()) {
            List<Method> list2 = lambdaReference.referenceType().methods();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"methods(...)");
            Iterable $this$single$iv = list2;
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                Method it = (Method)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.name(), (Object)CREATE)) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            Method lambdaMethod = single$iv;
            Intrinsics.checkNotNull((Object)lambdaMethod);
            return (SteppingBreakpoint)new AsyncSuspendLambdaBreakpoint(context2, hint2, (ObjectReference)lambdaReference, lambdaMethod);
        }
        SourcePosition sourcePosition = this.lambdaFilter.getBreakpointPosition();
        if (sourcePosition == null) {
            return null;
        }
        SourcePosition position = sourcePosition;
        return (SteppingBreakpoint)new KotlinLambdaInstanceBreakpoint(context2, position, (ObjectReference)lambdaReference);
    }

    private final ObjectReference getLambdaReference(StackFrameProxyImpl $this$getLambdaReference) {
        int index2 = this.lambdaInfo.getParameterIndex();
        Location location = $this$getLambdaReference.location();
        Intrinsics.checkNotNull((Object)location);
        Method method = SafeUtilKt.safeMethod(location);
        boolean bl = method != null ? KotlinSteppingCommandProviderKt.isSyntheticMethodForDefaultParameters(method) : false;
        if (bl && KotlinStepOverParamDefaultImplsMethodFilterKt.isSyntheticDefaultMethodPossiblyConvertedToStatic(location)) {
            ++index2;
        }
        VirtualMachine virtualMachine = $this$getLambdaReference.getVirtualMachine().getVirtualMachine();
        Intrinsics.checkNotNullExpressionValue((Object)virtualMachine, (String)"getVirtualMachine(...)");
        if (DexDebugFacility.INSTANCE.isDex(virtualMachine)) {
            List list2 = $this$getLambdaReference.visibleVariables();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"visibleVariables(...)");
            LocalVariableProxyImpl localVariableProxyImpl = (LocalVariableProxyImpl)CollectionsKt.getOrNull((List)list2, (int)index2);
            if (localVariableProxyImpl == null) {
                return null;
            }
            LocalVariableProxyImpl lambdaArgumentVariable = localVariableProxyImpl;
            Value value = $this$getLambdaReference.getValue(lambdaArgumentVariable);
            return value instanceof ObjectReference ? (ObjectReference)value : null;
        }
        List list3 = $this$getLambdaReference.getArgumentValues();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getArgumentValues(...)");
        Object object = CollectionsKt.getOrNull((List)list3, (int)index2);
        return object instanceof ObjectReference ? (ObjectReference)object : null;
    }

    private final boolean isTargetLambdaName(String name2) {
        if (this.isAsyncSuspendLambda()) {
            return Intrinsics.areEqual((Object)name2, (Object)CREATE) || Intrinsics.areEqual((Object)name2, (Object)INVOKE_SUSPEND);
        }
        return this.lambdaFilter.isTargetLambdaName(name2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkLambdaBreakpoint(ObjectReference $this$checkLambdaBreakpoint, EvaluationContextImpl context2, Location location) {
        ThreadReferenceProxyImpl threadReferenceProxyImpl = context2.getSuspendContext().getThread();
        if (threadReferenceProxyImpl == null) {
            return false;
        }
        ThreadReferenceProxyImpl thread = threadReferenceProxyImpl;
        Method method = SafeUtilKt.safeMethod(location);
        Object object = method;
        if (method == null) return false;
        if ((object = object.name()) == null) {
            return false;
        }
        Object methodName = object;
        if (!this.isTargetLambdaName((String)methodName)) {
            return false;
        }
        int frameIndex = DebuggerUtils.INSTANCE.isGeneratedIrBackendLambdaMethodName((String)methodName) ? 1 : 0;
        if (this.isTargetLambda($this$checkLambdaBreakpoint, thread, frameIndex)) return true;
        VirtualMachine virtualMachine = location.virtualMachine();
        Intrinsics.checkNotNullExpressionValue((Object)virtualMachine, (String)"virtualMachine(...)");
        if (DexDebugFacility.INSTANCE.isDex(virtualMachine)) {
            if (this.isTargetLambda($this$checkLambdaBreakpoint, thread, 2)) return true;
        }
        if (!this.isTargetLambda($this$checkLambdaBreakpoint, thread, 3)) return false;
        return true;
    }

    private final boolean isTargetLambda(ObjectReference $this$isTargetLambda, ThreadReferenceProxyImpl thread, int frameIndex) {
        if (thread.frameCount() <= frameIndex) {
            return false;
        }
        if (this.isSameCoroutineSuspendLambda()) {
            return this.checkLambdaType($this$isTargetLambda, thread, frameIndex);
        }
        return this.checkLambdaId($this$isTargetLambda, thread, frameIndex) || this.checkLambdaId($this$isTargetLambda, thread, 3);
    }

    private final boolean checkLambdaId(ObjectReference $this$checkLambdaId, ThreadReferenceProxyImpl thread, int frameIndex) {
        StackFrameProxyImpl stackFrameProxyImpl = thread.frame(frameIndex);
        Intrinsics.checkNotNullExpressionValue((Object)stackFrameProxyImpl, (String)"frame(...)");
        ObjectReference lambdaReference = SafeUtilKt.safeThisObject(stackFrameProxyImpl);
        return lambdaReference != null && lambdaReference.uniqueID() == $this$checkLambdaId.uniqueID();
    }

    private final boolean checkLambdaType(ObjectReference $this$checkLambdaType, ThreadReferenceProxyImpl thread, int frameIndex) {
        StackFrameProxyImpl stackFrameProxyImpl = thread.frame(frameIndex);
        Intrinsics.checkNotNullExpressionValue((Object)stackFrameProxyImpl, (String)"frame(...)");
        ObjectReference lambdaReference = SafeUtilKt.safeThisObject(stackFrameProxyImpl);
        return lambdaReference != null && Intrinsics.areEqual((Object)lambdaReference.referenceType(), (Object)$this$checkLambdaType.referenceType());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0014\u0010\u0014\u001a\u00060\u0015R\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinLambdaAsyncMethodFilter$AsyncSuspendLambdaBreakpoint;", "Lcom/intellij/debugger/engine/StepIntoMethodBreakpoint;", "context", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "hint", "Lcom/intellij/debugger/engine/RequestHint;", "lambdaReference", "Lcom/sun/jdi/ObjectReference;", "lambdaMethod", "Lcom/sun/jdi/Method;", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinLambdaAsyncMethodFilter;Lcom/intellij/debugger/engine/SuspendContextImpl;Lcom/intellij/debugger/engine/RequestHint;Lcom/sun/jdi/ObjectReference;Lcom/sun/jdi/Method;)V", "processLocatableEvent", "", "action", "Lcom/intellij/debugger/engine/events/SuspendContextCommandImpl;", "event", "Lcom/sun/jdi/event/LocatableEvent;", "evaluateCondition", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "scheduleStepsToInvokeSuspend", "Lcom/intellij/debugger/engine/DebugProcessImpl$StepOverCommand;", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "it", "intellij.kotlin.jvm.debugger.core"})
    @SourceDebugExtension(value={"SMAP\nKotlinLambdaAsyncMethodFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinLambdaAsyncMethodFilter.kt\norg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinLambdaAsyncMethodFilter$AsyncSuspendLambdaBreakpoint\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,284:1\n23#2:285\n60#2,5:286\n*S KotlinDebug\n*F\n+ 1 KotlinLambdaAsyncMethodFilter.kt\norg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinLambdaAsyncMethodFilter$AsyncSuspendLambdaBreakpoint\n*L\n170#1:285\n170#1:286,5\n*E\n"})
    private final class AsyncSuspendLambdaBreakpoint
    extends StepIntoMethodBreakpoint {
        @NotNull
        private final SuspendContextImpl context;
        @Nullable
        private final RequestHint hint;
        @NotNull
        private final ObjectReference lambdaReference;

        public AsyncSuspendLambdaBreakpoint(@Nullable SuspendContextImpl context2, @NotNull RequestHint hint2, @NotNull ObjectReference lambdaReference, Method lambdaMethod) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)lambdaReference, (String)"lambdaReference");
            Intrinsics.checkNotNullParameter((Object)lambdaMethod, (String)"lambdaMethod");
            super(lambdaMethod.declaringType().name(), lambdaMethod.name(), lambdaMethod.signature(), context2.getDebugProcess().getProject());
            this.context = context2;
            this.hint = hint2;
            this.lambdaReference = lambdaReference;
        }

        /*
         * WARNING - void declaration
         */
        public boolean processLocatableEvent(@NotNull SuspendContextCommandImpl action2, @Nullable LocatableEvent event) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
            boolean stopped = bl = super.processLocatableEvent(action2, event);
            boolean bl2 = false;
            if (!stopped) {
                return false;
            }
            this.context.getDebugProcess().getRequestsManager().deleteRequest((Requestor)this);
            SuspendContextImpl suspendContextImpl = action2.getSuspendContext();
            if (suspendContextImpl == null) {
                return false;
            }
            SuspendContextImpl suspendContext = suspendContextImpl;
            Location location = suspendContext.getLocation();
            if (location == null) {
                return false;
            }
            Location location2 = location;
            Method method = location2.method();
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method(...)");
            if (DebuggerUtil.isInvokeSuspendMethod(method)) {
                void $this$debug_u24default$iv;
                AsyncSuspendLambdaBreakpoint $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(AsyncSuspendLambdaBreakpoint.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                $this$thisLogger$iv = logger;
                Throwable e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    void var9_12 = $this$debug_u24default$iv;
                    boolean bl3 = false;
                    Location location3 = this.context.getLocation();
                    var9_12.debug("Hit AsyncSuspendLambdaBreakpoint and STOPPED at " + (location3 != null ? location3.method() : null), e$iv);
                }
                return true;
            }
            this.scheduleStepsToInvokeSuspend(suspendContext).prepareSteppingRequestsAndHints(suspendContext);
            return false;
        }

        public boolean evaluateCondition(@NotNull EvaluationContextImpl context2, @NotNull LocatableEvent event) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!super.evaluateCondition(context2, event)) {
                return false;
            }
            Location location = event.location();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"location(...)");
            return KotlinLambdaAsyncMethodFilter.this.checkLambdaBreakpoint(this.lambdaReference, context2, location);
        }

        private final DebugProcessImpl.StepOverCommand scheduleStepsToInvokeSuspend(SuspendContextImpl it) {
            DebugProcessImpl debugProcessImpl = it.getDebugProcess();
            KotlinLambdaAsyncMethodFilter kotlinLambdaAsyncMethodFilter = KotlinLambdaAsyncMethodFilter.this;
            DebugProcessImpl $this$scheduleStepsToInvokeSuspend_u24lambda_u240 = debugProcessImpl;
            boolean bl = false;
            return new DebugProcessImpl.StepOverCommand($this$scheduleStepsToInvokeSuspend_u24lambda_u240, it, this, kotlinLambdaAsyncMethodFilter){
                final /* synthetic */ AsyncSuspendLambdaBreakpoint this$0;
                final /* synthetic */ KotlinLambdaAsyncMethodFilter this$1;
                {
                    this.this$0 = $receiver2;
                    this.this$1 = $receiver3;
                    super($receiver, $it, false, null, -1);
                }

                public RequestHint getHint(SuspendContextImpl suspendContext, ThreadReferenceProxyImpl stepThread, RequestHint parentHint) {
                    Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
                    Intrinsics.checkNotNullParameter((Object)stepThread, (String)"stepThread");
                    MethodFilter methodFilter = this.myMethodFilter;
                    RequestHint hint2 = new RequestHint(stepThread, suspendContext, parentHint, this.this$0, this.this$1, methodFilter){
                        final /* synthetic */ AsyncSuspendLambdaBreakpoint this$0;
                        final /* synthetic */ KotlinLambdaAsyncMethodFilter this$1;
                        {
                            this.this$0 = $receiver;
                            this.this$1 = $receiver2;
                            super($stepThread, $suspendContext, -1, 2, $super_call_param$1, $parentHint);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public int getNextStepDepth(SuspendContextImpl context2) {
                            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                            Location location = context2.getLocation();
                            if (location != null && Intrinsics.areEqual((Object)location.method().name(), (Object)"<init>") && Intrinsics.areEqual((Object)location.method().declaringType(), (Object)AsyncSuspendLambdaBreakpoint.access$getLambdaReference$p(this.this$0).referenceType())) {
                                ObjectReference lambdaReferenceCopy;
                                ThreadReferenceProxyImpl threadReferenceProxyImpl = context2.getThread();
                                ObjectReference objectReference = threadReferenceProxyImpl != null && (threadReferenceProxyImpl = threadReferenceProxyImpl.frame(0)) != null ? SafeUtilKt.safeThisObject((StackFrameProxyImpl)threadReferenceProxyImpl) : (lambdaReferenceCopy = null);
                                if (lambdaReferenceCopy == null) {
                                    void $this$debug_u24default$iv;
                                    scheduleStepsToInvokeSuspend.1.getHint.hint.1 $this$thisLogger$iv = this;
                                    boolean $i$f$thisLogger = false;
                                    Logger logger = Logger.getInstance(scheduleStepsToInvokeSuspend.1.getHint.hint.1.class);
                                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                                    $this$thisLogger$iv = logger;
                                    Throwable e$iv = null;
                                    boolean $i$f$debug = false;
                                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                                        void var13_11 = $this$debug_u24default$iv;
                                        boolean bl = false;
                                        var13_11.debug("Could not extract the copied instance of a lambda from the stack frame of <init> invocation, location = " + location.method() + ".", e$iv);
                                    }
                                    return -100;
                                }
                                List<Method> list2 = lambdaReferenceCopy.referenceType().methods();
                                Intrinsics.checkNotNullExpressionValue(list2, (String)"methods(...)");
                                Iterable $this$single$iv = list2;
                                boolean $i$f$single = false;
                                Object single$iv = null;
                                boolean found$iv = false;
                                for (T element$iv : $this$single$iv) {
                                    Method it = (Method)element$iv;
                                    boolean bl = false;
                                    if (!Intrinsics.areEqual((Object)it.name(), (Object)"invokeSuspend")) continue;
                                    if (found$iv) {
                                        throw new IllegalArgumentException("Collection contains more than one matching element.");
                                    }
                                    single$iv = element$iv;
                                    found$iv = true;
                                }
                                if (!found$iv) {
                                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                                }
                                Method invokeSuspendMethod = single$iv;
                                RequestHint requestHint = AsyncSuspendLambdaBreakpoint.access$getHint$p(this.this$0);
                                Intrinsics.checkNotNull((Object)invokeSuspendMethod);
                                AsyncSuspendLambdaBreakpoint breakpoint2 = this.this$1.new AsyncSuspendLambdaBreakpoint(context2, requestHint, lambdaReferenceCopy, invokeSuspendMethod);
                                DebugProcessImpl.prepareAndSetSteppingBreakpoint((SuspendContextImpl)context2, (SteppingBreakpoint)((SteppingBreakpoint)breakpoint2), (RequestHint)AsyncSuspendLambdaBreakpoint.access$getHint$p(this.this$0), (boolean)true);
                                return -100;
                            }
                            return 1;
                        }
                    };
                    hint2.setIgnoreFilters(suspendContext.getDebugProcess().getSession().shouldIgnoreSteppingFilters());
                    return hint2;
                }
            };
        }

        public static final /* synthetic */ ObjectReference access$getLambdaReference$p(AsyncSuspendLambdaBreakpoint $this) {
            return $this.lambdaReference;
        }

        public static final /* synthetic */ RequestHint access$getHint$p(AsyncSuspendLambdaBreakpoint $this) {
            return $this.hint;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinLambdaAsyncMethodFilter$Companion;", "", "<init>", "()V", "CREATE", "", "INVOKE_SUSPEND", "intellij.kotlin.jvm.debugger.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinLambdaAsyncMethodFilter$KotlinLambdaInstanceBreakpoint;", "Lcom/intellij/debugger/ui/breakpoints/StepIntoBreakpoint;", "context", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "pos", "Lcom/intellij/debugger/SourcePosition;", "lambdaReference", "Lcom/sun/jdi/ObjectReference;", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinLambdaAsyncMethodFilter;Lcom/intellij/debugger/engine/SuspendContextImpl;Lcom/intellij/debugger/SourcePosition;Lcom/sun/jdi/ObjectReference;)V", "processLocatableEvent", "", "action", "Lcom/intellij/debugger/engine/events/SuspendContextCommandImpl;", "event", "Lcom/sun/jdi/event/LocatableEvent;", "evaluateCondition", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "intellij.kotlin.jvm.debugger.core"})
    @SourceDebugExtension(value={"SMAP\nKotlinLambdaAsyncMethodFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinLambdaAsyncMethodFilter.kt\norg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinLambdaAsyncMethodFilter$KotlinLambdaInstanceBreakpoint\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,284:1\n23#2:285\n60#2,5:286\n*S KotlinDebug\n*F\n+ 1 KotlinLambdaAsyncMethodFilter.kt\norg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinLambdaAsyncMethodFilter$KotlinLambdaInstanceBreakpoint\n*L\n226#1:285\n226#1:286,5\n*E\n"})
    private final class KotlinLambdaInstanceBreakpoint
    extends StepIntoBreakpoint {
        @NotNull
        private final SuspendContextImpl context;
        @NotNull
        private final ObjectReference lambdaReference;

        public KotlinLambdaInstanceBreakpoint(@NotNull SuspendContextImpl context2, @NotNull SourcePosition pos, ObjectReference lambdaReference) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)lambdaReference, (String)"lambdaReference");
            super(context2.getDebugProcess().getProject(), pos, (BreakpointStepMethodFilter)KotlinLambdaAsyncMethodFilter.this.lambdaFilter);
            this.context = context2;
            this.lambdaReference = lambdaReference;
        }

        public boolean processLocatableEvent(@NotNull SuspendContextCommandImpl action2, @Nullable LocatableEvent event) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
            KotlinLambdaInstanceBreakpoint $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(KotlinLambdaInstanceBreakpoint.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            Logger $this$debug_u24default$iv = logger;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger2 = $this$debug_u24default$iv;
                boolean bl2 = false;
                logger2.debug("Hit the KotlinLambdaInstanceBreakpoint at " + this.context.getLocation(), e$iv);
            }
            boolean stopped = bl = super.processLocatableEvent(action2, event);
            boolean bl3 = false;
            if (stopped) {
                this.context.getDebugProcess().getRequestsManager().deleteRequest((Requestor)this);
            }
            return bl;
        }

        public boolean evaluateCondition(@NotNull EvaluationContextImpl context2, @NotNull LocatableEvent event) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!super.evaluateCondition(context2, event)) {
                return false;
            }
            Location location = event.location();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"location(...)");
            return KotlinLambdaAsyncMethodFilter.this.checkLambdaBreakpoint(this.lambdaReference, context2, location);
        }
    }
}

