/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.BreakpointStepMethodFilter;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.Range;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinLineBreakpointTypeKt;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.core.stepping.StopOnReachedMethodFilter;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinLambdaInfo;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinLambdaMethodFilterKt;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinMethodSmartStepTargetKt;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtFunction;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\n\u0010\u0011\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u0007H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001c\u0010\u0019\u001a\u00020\u0014*\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0010\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006H\u0016J\u000e\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dR\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinLambdaMethodFilter;", "Lcom/intellij/debugger/engine/BreakpointStepMethodFilter;", "Lorg/jetbrains/kotlin/idea/debugger/core/stepping/StopOnReachedMethodFilter;", "lambda", "Lorg/jetbrains/kotlin/psi/KtFunction;", "callingExpressionLines", "Lcom/intellij/util/Range;", "", "lambdaInfo", "Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinLambdaInfo;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtFunction;Lcom/intellij/util/Range;Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinLambdaInfo;)V", "lambdaPtr", "Lcom/intellij/psi/SmartPsiElementPointer;", "firstStatementPosition", "Lcom/intellij/debugger/SourcePosition;", "lastStatementLine", "getBreakpointPosition", "getLastStatementLine", "locationMatches", "", "process", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "location", "Lcom/sun/jdi/Location;", "matchesLambda", "getCallingExpressionLines", "isTargetLambdaName", "name", "", "intellij.kotlin.jvm.debugger.core"})
public final class KotlinLambdaMethodFilter
implements BreakpointStepMethodFilter,
StopOnReachedMethodFilter {
    @Nullable
    private final Range<Integer> callingExpressionLines;
    @NotNull
    private final KotlinLambdaInfo lambdaInfo;
    @NotNull
    private final SmartPsiElementPointer<KtFunction> lambdaPtr;
    @Nullable
    private final SourcePosition firstStatementPosition;
    private final int lastStatementLine;

    public KotlinLambdaMethodFilter(@NotNull KtFunction lambda2, @Nullable Range<Integer> callingExpressionLines, @NotNull KotlinLambdaInfo lambdaInfo) {
        Intrinsics.checkNotNullParameter((Object)lambda2, (String)"lambda");
        Intrinsics.checkNotNullParameter((Object)lambdaInfo, (String)"lambdaInfo");
        this.callingExpressionLines = callingExpressionLines;
        this.lambdaInfo = lambdaInfo;
        this.lambdaPtr = SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)lambda2));
        Pair<SourcePosition, SourcePosition> pair = KotlinLambdaMethodFilterKt.findFirstAndLastStatementPositions((KtDeclarationWithBody)lambda2);
        SourcePosition firstPosition = (SourcePosition)pair.component1();
        SourcePosition lastPosition = (SourcePosition)pair.component2();
        this.firstStatementPosition = firstPosition;
        SourcePosition sourcePosition = lastPosition;
        this.lastStatementLine = sourcePosition != null ? sourcePosition.getLine() : -1;
    }

    @Nullable
    public SourcePosition getBreakpointPosition() {
        return this.firstStatementPosition;
    }

    public int getLastStatementLine() {
        return this.lastStatementLine;
    }

    public boolean locationMatches(@NotNull DebugProcessImpl process2, @NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        KtFunction ktFunction = KotlinMethodSmartStepTargetKt.getElementInReadAction(this.lambdaPtr);
        if (ktFunction == null) {
            return true;
        }
        KtFunction lambda2 = ktFunction;
        if (this.lambdaInfo.isInline()) {
            return this.matchesLambda(location, process2, lambda2);
        }
        Method method = SafeUtilKt.safeMethod(location);
        if (method == null) {
            return true;
        }
        Method method2 = method;
        if (method2.isBridge()) {
            return false;
        }
        String string = method2.name();
        if (string == null) {
            return false;
        }
        String methodName = string;
        return this.isTargetLambdaName(methodName) && this.matchesLambda(location, process2, lambda2);
    }

    private final boolean matchesLambda(Location $this$matchesLambda, DebugProcessImpl process2, KtFunction lambda2) {
        SourcePosition sourcePosition = process2.getPositionManager().getSourcePosition($this$matchesLambda);
        if (sourcePosition == null) {
            return true;
        }
        SourcePosition sourcePosition2 = sourcePosition;
        return (Boolean)ActionsKt.runReadAction(() -> KotlinLambdaMethodFilter.matchesLambda$lambda$0(sourcePosition2, lambda2));
    }

    @Nullable
    public Range<Integer> getCallingExpressionLines() {
        return this.callingExpressionLines;
    }

    public final boolean isTargetLambdaName(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        String actualName = DebuggerUtils.INSTANCE.trimIfMangledInBytecode(name2, this.lambdaInfo.isNameMangledInBytecode());
        if (this.lambdaInfo.isSuspend()) {
            return Intrinsics.areEqual((Object)actualName, (Object)"invokeSuspend");
        }
        return Intrinsics.areEqual((Object)actualName, (Object)this.lambdaInfo.getMethodName()) || DebuggerUtils.INSTANCE.isGeneratedIrBackendLambdaMethodName(actualName);
    }

    private static final boolean matchesLambda$lambda$0(SourcePosition $sourcePosition, KtFunction $lambda) {
        return KotlinLineBreakpointTypeKt.inTheMethod($sourcePosition, (PsiElement)$lambda);
    }
}

