/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search.ideaExtensions;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.DefinitionsScopedSearch;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.idea.search.declarationsSearch.OverridersSearchKt;
import org.jetbrains.kotlin.idea.search.declarationsSearch.OverridersSearchUtilsKt;
import org.jetbrains.kotlin.idea.util.ExpectActualUtilKt;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u000e\u0010\t\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinDefinitionsSearcher;", "Lcom/intellij/util/QueryExecutor;", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/psi/search/searches/DefinitionsScopedSearch$SearchParameters;", "<init>", "()V", "execute", "", "queryParameters", "consumer", "Lcom/intellij/util/Processor;", "Companion", "kotlin.idea"})
public final class KotlinDefinitionsSearcher
implements QueryExecutor<PsiElement, DefinitionsScopedSearch.SearchParameters> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public boolean execute(@NotNull DefinitionsScopedSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiElement> consumer) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)queryParameters, (String)"queryParameters");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Processor processor2 = KotlinDefinitionsSearcher.Companion.skipDelegatedMethodsConsumer((Processor<? super PsiElement>)consumer);
        PsiElement psiElement = queryParameters.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
        PsiElement element = psiElement;
        SearchScope searchScope = queryParameters.getScope();
        Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"getScope(...)");
        SearchScope scope = searchScope;
        PsiElement psiElement2 = element;
        if (psiElement2 instanceof KtClass) {
            boolean isExpectEnum = (Boolean)ActionsKt.runReadAction(() -> KotlinDefinitionsSearcher.execute$lambda$0(element));
            bl = isExpectEnum ? KotlinDefinitionsSearcher.Companion.processActualDeclarations((KtDeclaration)element, (Processor<PsiElement>)processor2) : KotlinDefinitionsSearcher.Companion.processClassImplementations((KtClass)element, (Processor<PsiElement>)processor2) && KotlinDefinitionsSearcher.Companion.processActualDeclarations((KtDeclaration)element, (Processor<PsiElement>)processor2);
        } else if (psiElement2 instanceof KtObjectDeclaration) {
            bl = KotlinDefinitionsSearcher.Companion.processActualDeclarations((KtDeclaration)element, (Processor<PsiElement>)processor2);
        } else if (psiElement2 instanceof KtLightClass) {
            Object object = ActionsKt.runReadAction(() -> KotlinDefinitionsSearcher.execute$lambda$1(element));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction(...)");
            SearchScope useScope = (SearchScope)object;
            bl = useScope instanceof LocalSearchScope ? KotlinDefinitionsSearcher.Companion.processLightClassLocalImplementations((KtLightClass)element, (LocalSearchScope)useScope, (Processor<PsiElement>)processor2) : true;
        } else {
            bl = psiElement2 instanceof KtNamedFunction || psiElement2 instanceof KtSecondaryConstructor ? KotlinDefinitionsSearcher.Companion.processFunctionImplementations((KtFunction)element, scope, (Processor<PsiElement>)processor2) && KotlinDefinitionsSearcher.Companion.processActualDeclarations((KtDeclaration)element, (Processor<PsiElement>)processor2) : (psiElement2 instanceof KtProperty ? KotlinDefinitionsSearcher.Companion.processPropertyImplementations((KtNamedDeclaration)element, scope, (Processor<PsiElement>)processor2) && KotlinDefinitionsSearcher.Companion.processActualDeclarations((KtDeclaration)element, (Processor<PsiElement>)processor2) : (psiElement2 instanceof KtParameter ? (KotlinDefinitionsSearcher.Companion.isFieldParameter((KtParameter)element) ? KotlinDefinitionsSearcher.Companion.processPropertyImplementations((KtNamedDeclaration)element, scope, (Processor<PsiElement>)processor2) && KotlinDefinitionsSearcher.Companion.processActualDeclarations((KtDeclaration)element, (Processor<PsiElement>)processor2) : true) : true));
        }
        return bl;
    }

    private static final boolean execute$lambda$0(PsiElement $element) {
        return ((KtClass)$element).isEnum() && KtPsiUtilKt.isExpectDeclaration((KtDeclaration)((KtDeclaration)$element));
    }

    private static final SearchScope execute$lambda$1(PsiElement $element) {
        return ((KtLightClass)$element).getUseScope();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00060\u0005H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001e\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J&\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J&\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J&\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u001e\u0010\u001f\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020 2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J*\u0010!\u001a\u00020\t2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinDefinitionsSearcher$Companion;", "", "<init>", "()V", "skipDelegatedMethodsConsumer", "Lcom/intellij/util/Processor;", "Lcom/intellij/psi/PsiElement;", "baseConsumer", "isDelegated", "", "element", "isFieldParameter", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "processClassImplementations", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "consumer", "processLightClassLocalImplementations", "psiClass", "Lorg/jetbrains/kotlin/asJava/classes/KtLightClass;", "searchScope", "Lcom/intellij/psi/search/LocalSearchScope;", "processFunctionImplementations", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "scope", "Lcom/intellij/psi/search/SearchScope;", "processPropertyImplementations", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "processActualDeclarations", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "processPropertyImplementationsMethods", "accessors", "", "Lcom/intellij/psi/PsiMethod;", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nKotlinDefinitionsSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinDefinitionsSearcher.kt\norg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinDefinitionsSearcher$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,170:1\n1740#2,3:171\n1740#2,3:177\n11896#3,3:174\n*S KotlinDebug\n*F\n+ 1 KotlinDefinitionsSearcher.kt\norg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinDefinitionsSearcher$Companion\n*L\n153#1:171,3\n146#1:177,3\n113#1:174,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Processor<PsiElement> skipDelegatedMethodsConsumer(Processor<? super PsiElement> baseConsumer) {
            return arg_0 -> Companion.skipDelegatedMethodsConsumer$lambda$0(baseConsumer, arg_0);
        }

        private final boolean isDelegated(PsiElement element) {
            return element instanceof KtLightMethod && ((KtLightMethod)element).isDelegated();
        }

        private final boolean isFieldParameter(KtParameter parameter) {
            return (Boolean)ActionsKt.runReadAction(() -> Companion.isFieldParameter$lambda$0(parameter));
        }

        private final boolean processClassImplementations(KtClass klass, Processor<PsiElement> consumer) {
            KtLightClass psiClass = (KtLightClass)ActionsKt.runReadAction(() -> Companion.processClassImplementations$lambda$0(klass));
            Object object = ActionsKt.runReadAction(() -> Companion.processClassImplementations$lambda$1(psiClass));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction(...)");
            SearchScope searchScope = (SearchScope)object;
            if (searchScope instanceof LocalSearchScope) {
                return this.processLightClassLocalImplementations(psiClass, (LocalSearchScope)searchScope, consumer);
            }
            return (Boolean)ActionsKt.runReadAction(() -> Companion.processClassImplementations$lambda$2(psiClass, consumer));
        }

        private final boolean processLightClassLocalImplementations(KtLightClass psiClass, LocalSearchScope searchScope, Processor<PsiElement> consumer) {
            Object object = ActionsKt.runReadAction(() -> Companion.processLightClassLocalImplementations$lambda$0(searchScope, psiClass));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction(...)");
            GlobalSearchScope globalScope = (GlobalSearchScope)object;
            return ContainerUtil.process((Iterable)ClassInheritorsSearch.search((PsiClass)((PsiClass)psiClass), (SearchScope)((SearchScope)globalScope), (boolean)true).asIterable(), arg_0 -> Companion.processLightClassLocalImplementations$lambda$2(arg_0 -> Companion.processLightClassLocalImplementations$lambda$1(consumer, searchScope, arg_0), arg_0));
        }

        private final boolean processFunctionImplementations(KtFunction function, SearchScope scope, Processor<PsiElement> consumer) {
            Object object = ReadAction.nonBlocking(() -> Companion.processFunctionImplementations$lambda$0(function, scope, consumer)).executeSynchronously();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"executeSynchronously(...)");
            return (Boolean)object;
        }

        private final boolean processPropertyImplementations(KtNamedDeclaration declaration, SearchScope scope, Processor<PsiElement> consumer) {
            return (Boolean)ActionsKt.runReadAction(() -> Companion.processPropertyImplementations$lambda$0(declaration, scope, consumer));
        }

        private final boolean processActualDeclarations(KtDeclaration declaration, Processor<PsiElement> consumer) {
            return (Boolean)ActionsKt.runReadAction(() -> Companion.processActualDeclarations$lambda$0(declaration, consumer));
        }

        public final boolean processPropertyImplementationsMethods(@NotNull Iterable<? extends PsiMethod> accessors, @NotNull SearchScope scope, @NotNull Processor<PsiElement> consumer) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter(accessors, (String)"accessors");
                Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
                Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
                Iterable<? extends PsiMethod> $this$all$iv = accessors;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    Iterator<? extends PsiMethod> iterator2 = $this$all$iv.iterator();
                    while (iterator2.hasNext()) {
                        PsiMethod element$iv;
                        PsiMethod method = element$iv = iterator2.next();
                        boolean bl2 = false;
                        if (OverridersSearchUtilsKt.forEachOverridingMethod(method, scope, (Function1<? super PsiMethod, Boolean>)((Function1)arg_0 -> Companion.processPropertyImplementationsMethods$lambda$0$0(consumer, arg_0)))) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        private static final boolean skipDelegatedMethodsConsumer$lambda$0(Processor $baseConsumer, PsiElement element) {
            Intrinsics.checkNotNull((Object)element);
            if (Companion.isDelegated(element)) {
                return true;
            }
            return $baseConsumer.process((Object)element);
        }

        private static final boolean isFieldParameter$lambda$0(KtParameter $parameter) {
            return KtPsiUtil.getClassIfParameterIsProperty((KtParameter)$parameter) != null;
        }

        private static final KtLightClass processClassImplementations$lambda$0(KtClass $klass) {
            KtLightClass ktLightClass = LightClassUtilsKt.toLightClass((KtClassOrObject)((KtClassOrObject)$klass));
            if (ktLightClass == null) {
                ktLightClass = (KtLightClass)LightClassUtilsKt.toFakeLightClass((KtClassOrObject)((KtClassOrObject)$klass));
            }
            return ktLightClass;
        }

        private static final SearchScope processClassImplementations$lambda$1(KtLightClass $psiClass) {
            return $psiClass.getUseScope();
        }

        private static final boolean processClassImplementations$lambda$2(KtLightClass $psiClass, Processor $consumer) {
            return ContainerUtil.process((Iterable)ClassInheritorsSearch.search((PsiClass)((PsiClass)$psiClass), (boolean)true).asIterable(), (Processor)$consumer);
        }

        /*
         * WARNING - void declaration
         */
        private static final GlobalSearchScope processLightClassLocalImplementations$lambda$0(LocalSearchScope $searchScope, KtLightClass $psiClass) {
            void $this$mapTo$iv;
            PsiElement[] psiElementArray = $searchScope.getScope();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getScope(...)");
            Object[] objectArray = psiElementArray;
            Collection destination$iv = new HashSet();
            boolean $i$f$mapTo = false;
            for (void item$iv : $this$mapTo$iv) {
                void it;
                PsiElement psiElement = (PsiElement)item$iv;
                Collection collection = destination$iv;
                boolean bl = false;
                collection.add(it.getContainingFile().getVirtualFile());
            }
            HashSet virtualFiles = (HashSet)destination$iv;
            return GlobalSearchScope.filesScope((Project)$psiClass.getProject(), (Collection)virtualFiles);
        }

        private static final boolean processLightClassLocalImplementations$lambda$1(Processor $consumer, LocalSearchScope $searchScope, PsiClass candidate) {
            PsiElement candidateOrigin;
            boolean inScope;
            Intrinsics.checkNotNull((Object)candidate);
            PsiElement psiElement = LightClassUtilsKt.getUnwrapped((PsiElement)((PsiElement)candidate));
            if (psiElement == null) {
                psiElement = (PsiElement)candidate;
            }
            return (inScope = ((Boolean)ActionsKt.runReadAction(() -> Companion.processLightClassLocalImplementations$lambda$1$0($searchScope, candidateOrigin = psiElement))).booleanValue()) ? $consumer.process((Object)candidate) : true;
        }

        private static final boolean processLightClassLocalImplementations$lambda$1$0(LocalSearchScope $searchScope, PsiElement $candidateOrigin) {
            SearchScope searchScope = (SearchScope)$searchScope;
            Intrinsics.checkNotNull((Object)$candidateOrigin);
            return PsiUtilsKt.contains((SearchScope)searchScope, (PsiElement)$candidateOrigin);
        }

        private static final boolean processLightClassLocalImplementations$lambda$2(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final Boolean processFunctionImplementations$lambda$0(KtFunction $function, SearchScope $scope, Processor $consumer) {
            PsiMethod psiMethod = (PsiMethod)CollectionsKt.firstOrNull(OverridersSearchKt.toPossiblyFakeLightMethods((PsiElement)$function));
            return psiMethod != null ? OverridersSearchUtilsKt.forEachImplementation(psiMethod, $scope, (Function1<? super PsiElement, Boolean>)((Function1)new Function1<PsiElement, Boolean>((Object)$consumer){

                public final Boolean invoke(PsiElement p0) {
                    return ((Processor)this.receiver).process((Object)p0);
                }
            })) : true;
        }

        private static final boolean processPropertyImplementations$lambda$0(KtNamedDeclaration $declaration, SearchScope $scope, Processor $consumer) {
            return Companion.processPropertyImplementationsMethods((Iterable<? extends PsiMethod>)OverridersSearchKt.toPossiblyFakeLightMethods((PsiElement)$declaration), $scope, (Processor<PsiElement>)$consumer);
        }

        private static final boolean processActualDeclarations$lambda$0(KtDeclaration $declaration, Processor $consumer) {
            boolean bl;
            block5: {
                if (!KtPsiUtilKt.isExpectDeclaration((KtDeclaration)$declaration)) {
                    bl = true;
                } else {
                    Iterable $this$all$iv = ExpectActualUtilKt.actualsForExpected$default($declaration, null, 1, null);
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            PsiElement p0 = (PsiElement)element$iv;
                            boolean bl2 = false;
                            if ($consumer.process((Object)p0)) continue;
                            bl = false;
                            break block5;
                        }
                        bl = true;
                    }
                }
            }
            return bl;
        }

        private static final boolean processPropertyImplementationsMethods$lambda$0$0(Processor $consumer, PsiMethod implementation) {
            Intrinsics.checkNotNullParameter((Object)implementation, (String)"implementation");
            if (Companion.isDelegated((PsiElement)implementation)) {
                return true;
            }
            PsiElement elementToProcess = (PsiElement)ActionsKt.runReadAction(() -> Companion.processPropertyImplementationsMethods$lambda$0$0$0(implementation));
            return $consumer.process((Object)elementToProcess);
        }

        private static final PsiElement processPropertyImplementationsMethods$lambda$0$0$0(PsiMethod $implementation) {
            KtDeclaration mirrorElement;
            KtLightMethod ktLightMethod = $implementation instanceof KtLightMethod ? (KtLightMethod)$implementation : null;
            Object object = mirrorElement = ktLightMethod != null ? (KtDeclaration)ktLightMethod.getKotlinOrigin() : null;
            return mirrorElement instanceof KtProperty || mirrorElement instanceof KtParameter ? (PsiElement)mirrorElement : (mirrorElement instanceof KtPropertyAccessor ? (((KtPropertyAccessor)mirrorElement).getParent() instanceof KtProperty ? ((KtPropertyAccessor)mirrorElement).getParent() : (PsiElement)$implementation) : (PsiElement)$implementation);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

