/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.signatures;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClosureParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrImmediateClosureParameterImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class GrImmediateClosureSignatureImpl
implements GrSignature {
    private static final Logger LOG = Logger.getInstance(GrImmediateClosureSignatureImpl.class);
    private final boolean myIsVarargs;
    private final boolean myCurried;
    @Nullable
    private final PsiType myReturnType;
    private final GrClosureParameter @NotNull [] myParameters;
    @NotNull
    private final PsiSubstitutor mySubstitutor;

    public GrImmediateClosureSignatureImpl(PsiParameter @NotNull [] parameters, @Nullable PsiType returnType, @NotNull PsiSubstitutor substitutor) {
        if (substitutor == null) {
            GrImmediateClosureSignatureImpl.$$$reportNull$$$0(0);
        }
        if (parameters == null) {
            GrImmediateClosureSignatureImpl.$$$reportNull$$$0(1);
        }
        LOG.assertTrue(returnType == null || returnType.isValid());
        LOG.assertTrue(substitutor.isValid());
        this.myReturnType = substitutor.substitute(returnType);
        int length = parameters.length;
        this.myParameters = new GrClosureParameter[length];
        for (int i2 = 0; i2 < length; ++i2) {
            this.myParameters[i2] = new GrImmediateClosureParameterImpl(parameters[i2], substitutor);
        }
        this.myIsVarargs = GrClosureSignatureUtil.isVarArgsImpl(this.myParameters);
        this.mySubstitutor = substitutor;
        this.myCurried = false;
    }

    public GrImmediateClosureSignatureImpl(PsiParameter[] parameters, @Nullable PsiType returnType) {
        this(parameters, returnType, PsiSubstitutor.EMPTY);
    }

    public GrImmediateClosureSignatureImpl(GrClosureParameter @NotNull [] params, @Nullable PsiType returnType, boolean isVarArgs, boolean isCurried) {
        if (params == null) {
            GrImmediateClosureSignatureImpl.$$$reportNull$$$0(2);
        }
        this.myParameters = params;
        this.myReturnType = returnType;
        this.myIsVarargs = isVarArgs;
        this.myCurried = isCurried;
        this.mySubstitutor = PsiSubstitutor.EMPTY;
    }

    @Override
    public boolean isVarargs() {
        return this.myIsVarargs;
    }

    @Override
    @Nullable
    public PsiType getReturnType() {
        return this.myReturnType;
    }

    @Override
    @NotNull
    public PsiSubstitutor getSubstitutor() {
        PsiSubstitutor psiSubstitutor = this.mySubstitutor;
        if (psiSubstitutor == null) {
            GrImmediateClosureSignatureImpl.$$$reportNull$$$0(3);
        }
        return psiSubstitutor;
    }

    @Override
    public GrClosureParameter @NotNull [] getParameters() {
        GrClosureParameter[] grClosureParameterArray = (GrClosureParameter[])this.myParameters.clone();
        if (grClosureParameterArray == null) {
            GrImmediateClosureSignatureImpl.$$$reportNull$$$0(4);
        }
        return grClosureParameterArray;
    }

    @Override
    public int getParameterCount() {
        return this.myParameters.length;
    }

    @Override
    public boolean isValid() {
        for (GrClosureParameter parameter : this.myParameters) {
            if (parameter.isValid()) continue;
            return false;
        }
        PsiType returnType = this.getReturnType();
        return returnType == null || returnType.isValid();
    }

    public boolean equals(Object obj) {
        if (obj instanceof GrSignature) {
            return Arrays.equals(this.myParameters, ((GrSignature)obj).getParameters()) && this.myIsVarargs == ((GrSignature)obj).isVarargs();
        }
        return super.equals(obj);
    }

    @Override
    public boolean isCurried() {
        return this.myCurried;
    }

    @Nullable
    public static GrSignature getLeastUpperBound(@NotNull GrSignature signature1, @NotNull GrSignature signature2, @NotNull PsiManager manager) {
        GrClosureParameter[] parameters2;
        GrClosureParameter[] parameters1;
        if (signature1 == null) {
            GrImmediateClosureSignatureImpl.$$$reportNull$$$0(5);
        }
        if (signature2 == null) {
            GrImmediateClosureSignatureImpl.$$$reportNull$$$0(6);
        }
        if (manager == null) {
            GrImmediateClosureSignatureImpl.$$$reportNull$$$0(7);
        }
        if ((parameters1 = signature1.getParameters()).length == (parameters2 = signature2.getParameters()).length) {
            GrClosureParameter[] params = new GrClosureParameter[parameters1.length];
            for (int i2 = 0; i2 < params.length; ++i2) {
                PsiType type = GenericsUtil.getGreatestLowerBound((PsiType)parameters1[i2].getType(), (PsiType)parameters2[i2].getType());
                boolean opt = parameters1[i2].isOptional() && parameters2[i2].isOptional();
                String name = StringUtil.equals((CharSequence)parameters1[i2].getName(), (CharSequence)parameters2[i2].getName()) ? parameters1[i2].getName() : null;
                params[i2] = new GrImmediateClosureParameterImpl(type, name, opt, null);
            }
            PsiType s1type = signature1.getReturnType();
            PsiType s2type = signature2.getReturnType();
            PsiType returnType = null;
            if (s1type != null && s2type != null) {
                returnType = TypesUtil.getLeastUpperBound(s1type, s2type, manager);
            }
            boolean isVarArgs = signature1.isVarargs() && signature2.isVarargs();
            return new GrImmediateClosureSignatureImpl(params, returnType, isVarArgs, false);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/signatures/GrImmediateClosureSignatureImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature1";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature2";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/signatures/GrImmediateClosureSignatureImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLeastUpperBound";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

