// Copyright 2000-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package maven.dsl.groovy

class distributionManagement {
  /**
   * Information needed to deploy the artifacts generated by the
   * project to a
   *             remote repository.
   */
  def repository

  /**
   *
   *
   *             Where to deploy snapshots of artifacts to. If
   * not given, it defaults to the
   *             <code>repository</code> element.
   *
   *
   */
  def snapshotRepository

  /**
   * Information needed for deploying the web site of the project.
   */
  def site

  /**
   *
   *
   *             The URL of the project's download page. If not
   * given users will be
   *             referred to the homepage given by
   * <code>url</code>.
   *             This is given to assist in locating artifacts
   * that are not in the repository due to
   *             licensing restrictions.
   *
   *
   */
  String downloadUrl

  /**
   * Relocation information of the artifact if it has been moved
   * to a new group ID
   *             and/or artifact ID.
   */
  def relocation

  /**
   *
   *
   *             Gives the status of this artifact in the remote
   * repository.
   *             This must not be set in your local project, as
   * it is updated by
   *             tools placing it in the reposiory. Valid values
   * are: <code>none</code> (default),
   *             <code>converted</code> (repository manager
   * converted this from an Maven 1 POM),
   *             <code>partner</code>
   *             (directly synced from a partner Maven 2
   * repository), <code>deployed</code> (was deployed from a
   * Maven 2
   *             instance), <code>verified</code> (has been hand
   * verified as correct and final).
   *
   *
   */
  String status

  /**
   * Set the URL of the project's download page. If not given
   * users will be
   *             referred to the homepage given by
   * <code>url</code>.
   *             This is given to assist in locating artifacts
   * that are not in the repository due to
   *             licensing restrictions.
   */
  void downloadUrl(String downloadUrl) {}

  /**
   * Set relocation information of the artifact if it has been
   * moved to a new group ID
   *             and/or artifact ID.
   */
  void relocation(Closure closure){}

  /**
   * Set information needed to deploy the artifacts generated by
   * the project to a remote repository.
   */
  void repository(Closure closure){}

  /**
   * Set information needed for deploying the web site of the
   * project.
   */
  void site(Closure closure){}

  /**
   * Set where to deploy snapshots of artifacts to. If not given,
   * it defaults to the
   *             <code>repository</code> element.
   */
  void snapshotRepository(Closure closure){}

  /**
   * Set gives the status of this artifact in the remote
   * repository.
   *             This must not be set in your local project, as
   * it is updated by
   *             tools placing it in the reposiory. Valid values
   * are: <code>none</code> (default),
   *             <code>converted</code> (repository manager
   * converted this from an Maven 1 POM),
   *             <code>partner</code>
   *             (directly synced from a partner Maven 2
   * repository), <code>deployed</code> (was deployed from a
   * Maven 2
   *             instance), <code>verified</code> (has been hand
   * verified as correct and final).
   */
  void status(String status) {}
}
