/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.quickfix.ChangeCallableReturnTypeFix;
import org.jetbrains.kotlin.idea.quickfix.ChangeParameterTypeFix;
import org.jetbrains.kotlin.idea.quickfix.ChangeVariableTypeFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.quickfix.QuickFixBranchUtil;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 !2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001!B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0012\u0010\u0012\u001a\f0\t\u00a2\u0006\u0002\b\u0013\u00a2\u0006\u0002\b\u0014H\u0016J\b\u0010\u0015\u001a\u00020\tH\u0016J\"\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J#\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0094\u0002J\b\u0010 \u001a\u00020\u0017H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeFunctionLiteralReturnTypeFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "functionLiteralExpression", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtLambdaExpression;Lorg/jetbrains/kotlin/types/KotlinType;)V", "typePresentation", "", "typeSourceCode", "functionLiteralReturnTypeRef", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "getFunctionLiteralReturnTypeRef", "()Lorg/jetbrains/kotlin/psi/KtTypeReference;", "appropriateQuickFix", "Lcom/intellij/codeInsight/intention/IntentionAction;", "createAppropriateQuickFix", "getText", "Lcom/intellij/codeInspection/util/IntentionName;", "Lorg/jetbrains/annotations/NotNull;", "getFamilyName", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "invoke", "", "startInWriteAction", "Companion", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nChangeFunctionLiteralReturnTypeFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangeFunctionLiteralReturnTypeFix.kt\norg/jetbrains/kotlin/idea/quickfix/ChangeFunctionLiteralReturnTypeFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,135:1\n1#2:136\n*E\n"})
public final class ChangeFunctionLiteralReturnTypeFix
extends KotlinQuickFixAction<KtLambdaExpression> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String typePresentation;
    @NotNull
    private final String typeSourceCode;
    @Nullable
    private final IntentionAction appropriateQuickFix;

    public ChangeFunctionLiteralReturnTypeFix(@NotNull KtLambdaExpression functionLiteralExpression, @NotNull KotlinType type2) {
        Intrinsics.checkNotNullParameter((Object)functionLiteralExpression, (String)"functionLiteralExpression");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        super((PsiElement)functionLiteralExpression);
        this.typePresentation = IdeDescriptorRenderers.SOURCE_CODE_TYPES_WITH_SHORT_NAMES.renderType(type2);
        this.typeSourceCode = IdeDescriptorRenderers.SOURCE_CODE_TYPES.renderType(type2);
        this.appropriateQuickFix = this.createAppropriateQuickFix(functionLiteralExpression, type2);
    }

    private final KtTypeReference getFunctionLiteralReturnTypeRef() {
        KtLambdaExpression ktLambdaExpression = (KtLambdaExpression)this.getElement();
        return ktLambdaExpression != null && (ktLambdaExpression = ktLambdaExpression.getFunctionLiteral()) != null ? ktLambdaExpression.getTypeReference() : null;
    }

    private final IntentionAction createAppropriateQuickFix(KtLambdaExpression functionLiteralExpression, KotlinType type2) {
        KtTypeReference parentFunctionReturnTypeRef;
        KotlinType parentFunctionReturnType;
        KtFunction parentFunction;
        ResolvedCall resolvedCall;
        BindingContext context2 = ResolutionUtils.analyze$default((KtElement)functionLiteralExpression, null, 1, null);
        KotlinType kotlinType = context2.getType((KtExpression)functionLiteralExpression);
        if (kotlinType == null) {
            return null;
        }
        KotlinType functionLiteralType = kotlinType;
        KotlinBuiltIns kotlinBuiltIns = functionLiteralType.getConstructor().getBuiltIns();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinBuiltIns, (String)"getBuiltIns(...)");
        KotlinBuiltIns builtIns = kotlinBuiltIns;
        ClassDescriptor classDescriptor = builtIns.getFunction(functionLiteralType.getArguments().size() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"getFunction(...)");
        ClassDescriptor functionClass = classDescriptor;
        LinkedList<KotlinType> functionClassTypeParameters = new LinkedList<KotlinType>();
        for (TypeProjection typeProjection : functionLiteralType.getArguments()) {
            functionClassTypeParameters.add(typeProjection.getType());
        }
        functionClassTypeParameters.remove(functionClassTypeParameters.size() - 1);
        functionClassTypeParameters.add(type2);
        KotlinType kotlinType2 = TypeUtils.substituteParameters((ClassDescriptor)functionClass, (List)functionClassTypeParameters);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"substituteParameters(...)");
        KotlinType eventualFunctionLiteralType = kotlinType2;
        KtProperty correspondingProperty = (KtProperty)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)functionLiteralExpression), KtProperty.class);
        if (correspondingProperty != null && correspondingProperty.getDelegate() == null) {
            boolean bl;
            KtExpression ktExpression = correspondingProperty.getInitializer();
            if (ktExpression != null) {
                KtExpression it = ktExpression;
                boolean bl2 = false;
                bl = !QuickFixBranchUtil.canEvaluateTo(it, (KtExpression)functionLiteralExpression);
            } else {
                bl = false;
            }
            if (!bl) {
                KtTypeReference correspondingPropertyTypeRef = correspondingProperty.getTypeReference();
                KotlinType propertyType = (KotlinType)context2.get((ReadOnlySlice)BindingContext.TYPE, (Object)correspondingPropertyTypeRef);
                return propertyType != null && !KotlinTypeChecker.DEFAULT.isSubtypeOf(eventualFunctionLiteralType, propertyType) ? (IntentionAction)new ChangeVariableTypeFix((KtCallableDeclaration)correspondingProperty, eventualFunctionLiteralType) : null;
            }
        }
        if ((resolvedCall = CallUtilKt.getParentResolvedCall((KtElement)((KtElement)functionLiteralExpression), (BindingContext)context2, (boolean)true)) != null) {
            Call call2 = resolvedCall.getCall();
            Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"getCall(...)");
            ValueArgument valueArgument = CallUtilKt.getValueArgumentForExpression((Call)call2, (KtExpression)((KtExpression)functionLiteralExpression));
            ValueParameterDescriptor correspondingParameter = CallUtilKt.getParameterForArgument((ResolvedCall)resolvedCall, (ValueArgument)valueArgument);
            if (correspondingParameter != null && correspondingParameter.getOverriddenDescriptors().size() <= 1) {
                Project project = functionLiteralExpression.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                Project project2 = project;
                PsiElement correspondingParameterDeclaration = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(project2, (DeclarationDescriptor)correspondingParameter);
                if (correspondingParameterDeclaration instanceof KtParameter) {
                    KtTypeReference correspondingParameterTypeRef = ((KtParameter)correspondingParameterDeclaration).getTypeReference();
                    KotlinType parameterType = (KotlinType)context2.get((ReadOnlySlice)BindingContext.TYPE, (Object)correspondingParameterTypeRef);
                    return parameterType != null && !KotlinTypeChecker.DEFAULT.isSubtypeOf(eventualFunctionLiteralType, parameterType) ? (IntentionAction)new ChangeParameterTypeFix((KtParameter)correspondingParameterDeclaration, eventualFunctionLiteralType) : null;
                }
            }
        }
        return (parentFunction = (KtFunction)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)functionLiteralExpression), KtFunction.class, (boolean)true)) != null && QuickFixBranchUtil.canFunctionOrGetterReturnExpression((KtDeclaration)parentFunction, (KtExpression)functionLiteralExpression) ? (IntentionAction)((parentFunctionReturnType = (KotlinType)context2.get((ReadOnlySlice)BindingContext.TYPE, (Object)(parentFunctionReturnTypeRef = parentFunction.getTypeReference()))) != null && !KotlinTypeChecker.DEFAULT.isSubtypeOf(eventualFunctionLiteralType, parentFunctionReturnType) ? new ChangeCallableReturnTypeFix.ForEnclosing(parentFunction, eventualFunctionLiteralType) : null) : null;
    }

    @NotNull
    public String getText() {
        Object object = this.appropriateQuickFix;
        if (object == null || (object = object.getText()) == null) {
            Object[] objectArray = new Object[]{this.typePresentation};
            object = KotlinBundle.message((String)"fix.change.return.type.lambda", (Object[])objectArray);
        }
        return object;
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"fix.change.return.type.family", (Object[])new Object[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (this.getFunctionLiteralReturnTypeRef() != null) return true;
        if (this.appropriateQuickFix == null) return false;
        Editor editor2 = editor;
        Intrinsics.checkNotNull((Object)editor2);
        if (!this.appropriateQuickFix.isAvailable(project, editor2, (PsiFile)file)) return false;
        return true;
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ApplicationManager.getApplication().runWriteAction(() -> ChangeFunctionLiteralReturnTypeFix.invoke$lambda$0(this, project));
        if (this.appropriateQuickFix != null) {
            Editor editor2 = editor;
            Intrinsics.checkNotNull((Object)editor2);
            if (this.appropriateQuickFix.isAvailable(project, editor2, (PsiFile)file)) {
                this.appropriateQuickFix.invoke(project, editor, (PsiFile)file);
            }
        }
    }

    @Override
    public boolean startInWriteAction() {
        return this.appropriateQuickFix == null || this.appropriateQuickFix.startInWriteAction();
    }

    private static final void invoke$lambda$0(ChangeFunctionLiteralReturnTypeFix this$0, Project $project) {
        block0: {
            KtTypeReference ktTypeReference = this$0.getFunctionLiteralReturnTypeRef();
            if (ktTypeReference == null) break block0;
            KtTypeReference it = ktTypeReference;
            boolean bl = false;
            PsiElement psiElement = it.replace((PsiElement)new KtPsiFactory($project, false, 2, null).createType(this$0.typeSourceCode));
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtTypeReference");
            KtTypeReference newTypeRef = (KtTypeReference)psiElement;
            ShortenReferences.process$default(ShortenReferences.DEFAULT, (KtElement)newTypeRef, null, 2, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeFunctionLiteralReturnTypeFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "<init>", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nChangeFunctionLiteralReturnTypeFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangeFunctionLiteralReturnTypeFix.kt\norg/jetbrains/kotlin/idea/quickfix/ChangeFunctionLiteralReturnTypeFix$Companion\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,135:1\n59#2:136\n28#2,12:137\n*S KotlinDebug\n*F\n+ 1 ChangeFunctionLiteralReturnTypeFix.kt\norg/jetbrains/kotlin/idea/quickfix/ChangeFunctionLiteralReturnTypeFix$Companion\n*L\n130#1:136\n130#1:137,12\n*E\n"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Object v1;
            Object v0;
            block4: {
                void $this$findParentOfType$iv;
                Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
                PsiElement psiElement = diagnostic.getPsiElement();
                boolean strict$iv = false;
                boolean $i$f$findParentOfType = false;
                void var6_5 = $this$findParentOfType$iv;
                boolean withSelf$iv$iv = true;
                boolean $i$f$findParentInFile = false;
                for (PsiElement current$iv$iv = $this$findParentInFile$iv$iv; current$iv$iv != null; current$iv$iv = current$iv$iv.getParent()) {
                    void it$iv = current$iv$iv;
                    boolean bl = false;
                    if (it$iv instanceof KtLambdaExpression) {
                        v0 = current$iv$iv;
                        break block4;
                    }
                    if (current$iv$iv instanceof PsiFile) break;
                }
                v0 = v1 = null;
            }
            if (!(v0 instanceof KtLambdaExpression)) {
                v1 = null;
            }
            KtLambdaExpression ktLambdaExpression = (KtLambdaExpression)((PsiElement)((KtLambdaExpression)v1));
            if (ktLambdaExpression == null) {
                return null;
            }
            KtLambdaExpression functionLiteralExpression = ktLambdaExpression;
            SimpleType simpleType = PlatformKt.getBuiltIns((KtElement)functionLiteralExpression).getUnitType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getUnitType(...)");
            return new ChangeFunctionLiteralReturnTypeFix(functionLiteralExpression, (KotlinType)simpleType);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

