/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize;

import javajs.util.BS;
import javajs.util.Lst;
import org.jmol.minimize.MinBond;
import org.jmol.minimize.forcefield.AtomType;
import org.jmol.modelset.Atom;

public class MinAtom {
    public Atom atom;
    int index;
    public String sType;
    public double[] coord = new double[3];
    public double[] force = new double[3];
    private Lst<MinBond> bonds = new Lst();
    public int nBonds;
    int[] bondedAtoms;
    public BS bsVdw = new BS();
    private int hCount = -1;
    public double partialCharge;
    public AtomType ffAtomType;
    public int ffType;
    public Integer vdwKey;
    public BS bs14 = new BS();

    public String toString() {
        return "#" + this.index + "@" + this.atom.i + " " + this.sType + " " + this.coord[0] + "," + this.coord[1] + "," + this.coord[2];
    }

    MinAtom(int index, Atom atom, double[] coord, int ac) {
        this.index = index;
        this.atom = atom;
        this.coord = coord;
        this.bsVdw.setBits(index + 1, ac);
        this.bsVdw.clear(index);
    }

    void set() {
        this.coord[0] = this.atom.x;
        this.coord[1] = this.atom.y;
        this.coord[2] = this.atom.z;
    }

    public MinBond getBondTo(int iAtom) {
        this.getBondedAtomIndexes();
        for (int i = 0; i < this.nBonds; ++i) {
            if (this.bondedAtoms[i] != iAtom) continue;
            return (MinBond)this.bonds.get(i);
        }
        return null;
    }

    public int[] getBondedAtomIndexes() {
        if (this.bondedAtoms == null) {
            this.bondedAtoms = new int[this.nBonds];
            int i = this.nBonds;
            while (--i >= 0) {
                this.bondedAtoms[i] = ((MinBond)this.bonds.get(i)).getOtherAtom(this.index);
            }
        }
        return this.bondedAtoms;
    }

    public String getIdentity() {
        return this.atom.getInfo();
    }

    public void addBond(MinBond bond, int i) {
        this.bonds.addLast(bond);
        ++this.nBonds;
        this.bsVdw.clear(i);
    }

    public int getBondIndex(int j) {
        return ((MinBond)this.bonds.get((int)j)).index;
    }

    public int getHCount() {
        if (this.hCount < 0) {
            this.hCount = this.atom.getCovalentHydrogenCount();
        }
        return this.hCount;
    }
}

