/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

public class LoopedStreams {
    PipedOutputStream pipedOS = new PipedOutputStream();
    boolean keepRunning = true;
    ByteArrayOutputStream byteArrayOS = new ByteArrayOutputStream(){

        @Override
        public void close() {
            LoopedStreams.this.keepRunning = false;
            try {
                super.close();
                LoopedStreams.this.pipedOS.close();
            }
            catch (IOException e) {
                System.exit(1);
            }
        }
    };
    private PipedInputStream pipedIS = new PipedInputStream(){

        @Override
        public void close() {
            LoopedStreams.this.keepRunning = false;
            try {
                super.close();
            }
            catch (IOException e) {
                System.exit(1);
            }
        }
    };

    public LoopedStreams() throws IOException {
        this.pipedOS.connect(this.pipedIS);
        this.startByteArrayReaderThread();
    }

    public InputStream getInputStream() {
        return this.pipedIS;
    }

    public OutputStream getOutputStream() {
        return this.byteArrayOS;
    }

    private void startByteArrayReaderThread() {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (LoopedStreams.this.keepRunning) {
                    if (LoopedStreams.this.byteArrayOS.size() > 0) {
                        byte[] buffer = null;
                        ByteArrayOutputStream byteArrayOutputStream = LoopedStreams.this.byteArrayOS;
                        synchronized (byteArrayOutputStream) {
                            buffer = LoopedStreams.this.byteArrayOS.toByteArray();
                            LoopedStreams.this.byteArrayOS.reset();
                        }
                        try {
                            LoopedStreams.this.pipedOS.write(buffer, 0, buffer.length);
                        }
                        catch (IOException e) {
                            System.exit(1);
                        }
                        continue;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }).start();
    }
}

