/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javajs.util.AU;
import javajs.util.BS;
import org.jmol.api.JmolSelectionListener;
import org.jmol.i18n.GT;
import org.jmol.modelset.ModelSet;
import org.jmol.util.BSUtil;
import org.jmol.viewer.Viewer;

public class SelectionManager {
    private Viewer vwr;
    private JmolSelectionListener[] listeners = new JmolSelectionListener[0];
    final BS bsHidden = new BS();
    private final BS bsSelection = new BS();
    final BS bsFixed = new BS();
    public BS bsSubset;
    public BS bsDeleted;
    public Boolean noneSelected;
    private static final int TRUE = 1;
    private static final int FALSE = 0;
    private static final int UNKNOWN = -1;
    private int empty = 1;
    boolean hideNotSelected;
    private final BS bsTemp = new BS();

    SelectionManager(Viewer vwr) {
        this.vwr = vwr;
    }

    void processDeletedModelAtoms(BS bsAtoms) {
        BSUtil.deleteBits(this.bsDeleted, bsAtoms);
        BSUtil.deleteBits(this.bsSubset, bsAtoms);
        BSUtil.deleteBits(this.bsFixed, bsAtoms);
        BSUtil.deleteBits(this.bsHidden, bsAtoms);
        BS bs = BSUtil.copy(this.bsSelection);
        BSUtil.deleteBits(bs, bsAtoms);
        this.setSelectionSet(bs, 0);
        this.selectionChanged(false);
    }

    void clear() {
        this.clearSelection(true);
        this.setSelectionSubset(null);
        this.hide(null, null, 0, true);
        this.bsDeleted = null;
        this.setMotionFixedAtoms(null);
    }

    void display(ModelSet modelSet, BS bs, int addRemove, boolean isQuiet) {
        switch (addRemove) {
            default: {
                BS bsNotSubset = this.bsSubset == null ? null : BSUtil.andNot(BSUtil.copy(this.bsHidden), this.bsSubset);
                BS bsAll = modelSet.getModelAtomBitSetIncludingDeleted(-1, false);
                this.bsHidden.or(bsAll);
                if (bsNotSubset != null) {
                    this.bsHidden.and(this.bsSubset);
                    this.bsHidden.or(bsNotSubset);
                }
            }
            case 1275069441: {
                if (bs == null) break;
                this.bsHidden.andNot(bs);
                break;
            }
            case 1073742119: {
                if (bs == null) break;
                this.bsHidden.or(bs);
            }
        }
        BSUtil.andNot(this.bsHidden, this.bsDeleted);
        modelSet.setBsHidden(this.bsHidden);
        if (!isQuiet) {
            this.vwr.reportSelection(GT.i(GT.$("{0} atoms hidden"), this.bsHidden.cardinality()));
        }
    }

    void hide(ModelSet modelSet, BS bs, int addRemove, boolean isQuiet) {
        BS bsNotSubset = addRemove == 0 || this.bsSubset == null ? null : BSUtil.andNot(BSUtil.copy(this.bsHidden), this.bsSubset);
        SelectionManager.setBitSet(this.bsHidden, bs, addRemove);
        if (bsNotSubset != null) {
            this.bsHidden.or(bsNotSubset);
        }
        if (modelSet != null) {
            modelSet.setBsHidden(this.bsHidden);
        }
        if (!isQuiet) {
            this.vwr.reportSelection(GT.i(GT.$("{0} atoms hidden"), this.bsHidden.cardinality()));
        }
    }

    void setSelectionSet(BS set, int addRemove) {
        SelectionManager.setBitSet(this.bsSelection, set, addRemove);
        this.empty = -1;
    }

    private static void setBitSet(BS bsWhat, BS bs, int addRemove) {
        switch (addRemove) {
            default: {
                bsWhat.clearAll();
            }
            case 1275069441: {
                if (bs == null) break;
                bsWhat.or(bs);
                break;
            }
            case 1073742119: {
                if (bs == null) break;
                bsWhat.andNot(bs);
            }
        }
    }

    public BS getHiddenSet() {
        return this.bsHidden;
    }

    boolean getHideNotSelected() {
        return this.hideNotSelected;
    }

    void setHideNotSelected(boolean TF) {
        this.hideNotSelected = TF;
        if (TF) {
            this.selectionChanged(false);
        }
    }

    public boolean isSelected(int atomIndex) {
        return atomIndex >= 0 && this.bsSelection.get(atomIndex);
    }

    void select(BS bs, int addRemove, boolean isQuiet) {
        if (bs == null) {
            this.selectAll(true);
            if (!this.vwr.getBoolean(1612709900)) {
                this.excludeSelectionSet(this.vwr.ms.getAtoms(1612709900, null));
            }
            if (!this.vwr.getBoolean(0x60200006)) {
                this.excludeSelectionSet(this.vwr.ms.getAtoms(0x60200006, null));
            }
        } else {
            this.setSelectionSet(bs, addRemove);
            if (!this.vwr.getBoolean(1612709900)) {
                this.excludeSelectionSet(this.vwr.ms.getAtoms(1612709900, null));
            }
            if (!this.vwr.getBoolean(0x60200006)) {
                this.excludeSelectionSet(this.vwr.ms.getAtoms(0x60200006, null));
            }
        }
        this.selectionChanged(false);
        boolean reportChime = this.vwr.getBoolean(603979879);
        if (!reportChime && isQuiet) {
            return;
        }
        int n = this.getSelectionCount();
        if (reportChime) {
            this.vwr.getChimeMessenger().reportSelection(n);
        } else if (!isQuiet) {
            this.vwr.reportSelection(GT.i(GT.$("{0} atoms selected"), n));
        }
    }

    void selectAll(boolean isQuiet) {
        int count = this.vwr.ms.ac;
        this.empty = count == 0 ? 1 : 0;
        int i = count;
        while (--i >= 0) {
            this.bsSelection.set(i);
        }
        BSUtil.andNot(this.bsSelection, this.bsDeleted);
        this.selectionChanged(isQuiet);
    }

    void clearSelection(boolean isQuiet) {
        this.setHideNotSelected(false);
        this.bsSelection.clearAll();
        this.empty = 1;
        this.selectionChanged(isQuiet);
    }

    public boolean isAtomSelected(int atomIndex) {
        return ((this.bsSubset == null || this.bsSubset.get(atomIndex)) && this.bsDeleted == null || !this.bsDeleted.get(atomIndex)) && this.bsSelection.get(atomIndex);
    }

    public void setSelectedAtom(int atomIndex, boolean TF) {
        if (atomIndex < 0) {
            this.selectionChanged(true);
            return;
        }
        if (this.bsSubset != null && !this.bsSubset.get(atomIndex) || this.bsDeleted != null && this.bsDeleted.get(atomIndex)) {
            return;
        }
        this.bsSelection.setBitTo(atomIndex, TF);
        this.empty = TF ? 0 : -1;
    }

    public void setSelectionSubset(BS bs) {
        this.bsSubset = bs;
    }

    boolean isInSelectionSubset(int atomIndex) {
        return atomIndex < 0 || this.vwr.am.splitFrame && !this.vwr.am.isSplitFrameSelectable(atomIndex) || this.bsSubset == null || this.bsSubset.get(atomIndex);
    }

    void invertSelection() {
        BSUtil.invertInPlace(this.bsSelection, this.vwr.ms.ac);
        this.empty = this.bsSelection.length() > 0 ? 0 : 1;
        this.selectionChanged(false);
    }

    private void excludeSelectionSet(BS setExclude) {
        if (setExclude == null || this.empty == 1) {
            return;
        }
        this.bsSelection.andNot(setExclude);
        this.empty = -1;
    }

    public int getSelectionCount() {
        BS bs;
        if (this.empty == 1) {
            return 0;
        }
        this.empty = 1;
        if (this.bsSubset == null) {
            bs = this.bsSelection;
        } else {
            this.bsTemp.clearAll();
            this.bsTemp.or(this.bsSubset);
            this.bsTemp.and(this.bsSelection);
            bs = this.bsTemp;
        }
        int count = bs.cardinality();
        if (count > 0) {
            this.empty = 0;
        }
        return count;
    }

    void addListener(JmolSelectionListener listener) {
        int len;
        int i = this.listeners.length;
        while (--i >= 0) {
            if (this.listeners[i] != listener) continue;
            this.listeners[i] = null;
            break;
        }
        int i2 = len = this.listeners.length;
        while (--i2 >= 0) {
            if (this.listeners[i2] != null) continue;
            this.listeners[i2] = listener;
            return;
        }
        this.listeners = this.listeners.length == 0 ? new JmolSelectionListener[1] : (JmolSelectionListener[])AU.doubleLength(this.listeners);
        this.listeners[len] = listener;
    }

    private void selectionChanged(boolean isQuiet) {
        if (this.hideNotSelected) {
            this.hide(this.vwr.ms, BSUtil.copyInvert(this.bsSelection, this.vwr.ms.ac), 0, isQuiet);
        }
        if (isQuiet || this.listeners.length == 0) {
            return;
        }
        int i = this.listeners.length;
        while (--i >= 0) {
            if (this.listeners[i] == null) continue;
            this.listeners[i].selectionChanged(this.bsSelection);
        }
    }

    int deleteAtoms(BS bs) {
        BS bsNew = BSUtil.copy(bs);
        if (this.bsDeleted == null) {
            this.bsDeleted = bsNew;
        } else {
            bsNew.andNot(this.bsDeleted);
            this.bsDeleted.or(bs);
        }
        this.bsHidden.andNot(this.bsDeleted);
        this.bsSelection.andNot(this.bsDeleted);
        return bsNew.cardinality();
    }

    BS getSelectedAtoms() {
        if (this.bsSubset == null) {
            return this.bsSelection;
        }
        BS bs = BSUtil.copy(this.bsSelection);
        bs.and(this.bsSubset);
        return bs;
    }

    BS getSelectedAtomsNoSubset() {
        return BSUtil.copy(this.bsSelection);
    }

    public BS excludeAtoms(BS bs, boolean ignoreSubset) {
        if (this.bsDeleted != null) {
            bs.andNot(this.bsDeleted);
        }
        if (!ignoreSubset && this.bsSubset != null) {
            bs = BSUtil.copy(bs);
            bs.and(this.bsSubset);
        }
        return bs;
    }

    void setMotionFixedAtoms(BS bs) {
        this.bsFixed.clearAll();
        if (bs != null) {
            this.bsFixed.or(bs);
        }
    }

    public BS getMotionFixedAtoms() {
        return this.bsFixed;
    }
}

