/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.resource;

import io.smallrye.common.constraint.Assert;
import io.smallrye.common.resource.PathResource;
import io.smallrye.common.resource.Resource;
import io.smallrye.common.resource.ResourceLoader;
import io.smallrye.common.resource.ResourceUtils;
import java.io.Closeable;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public final class PathResourceLoader
implements ResourceLoader {
    private final Path base;
    private Closeable c;

    public PathResourceLoader(Path base) {
        this.c = null;
        this.base = (Path)Assert.checkNotNullParam((String)"base", (Object)base);
    }

    public PathResourceLoader(FileSystem fs) {
        this.c = (Closeable)Assert.checkNotNullParam((String)"fs", (Object)fs);
        this.base = fs.getPath("/", new String[0]);
    }

    @Override
    public Resource findResource(String path) {
        String canon = ResourceUtils.canonicalizeRelativePath(path);
        Path filePath = this.base.resolve(canon);
        if (!Files.exists(filePath, new LinkOption[0])) {
            return null;
        }
        return new PathResource(canon, filePath);
    }

    @Override
    public URL baseUrl() {
        try {
            return this.base.toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new UnsupportedOperationException("Base URL is not supported for this loader because the path does not have a valid URL", e);
        }
    }

    @Override
    public void close() {
        Closeable c = this.c;
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.c = null;
        }
    }
}

