/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime;

import java.util.HashMap;
import java.util.Map;
import org.keycloak.common.profile.SingleProfileConfigResolver;
import org.keycloak.config.FeatureOptions;
import org.keycloak.config.Option;
import org.keycloak.config.WildcardOptionsUtil;
import org.keycloak.quarkus.runtime.cli.PropertyException;
import org.keycloak.quarkus.runtime.configuration.Configuration;

public class QuarkusSingleProfileConfigResolver
extends SingleProfileConfigResolver {
    public QuarkusSingleProfileConfigResolver() {
        super(QuarkusSingleProfileConfigResolver.getQuarkusFeatureState());
    }

    protected static Map<String, Boolean> getQuarkusFeatureState() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        String featureEnabledOptionPrefix = "kc." + WildcardOptionsUtil.getWildcardPrefix((String)FeatureOptions.FEATURE.getKey());
        Configuration.getPropertyNames().forEach(property -> {
            if (property.startsWith("kc.") && property.startsWith(featureEnabledOptionPrefix)) {
                String feature = WildcardOptionsUtil.getWildcardValue((Option)FeatureOptions.FEATURE, (String)property);
                String value = Configuration.getOptionalValue(property).orElseThrow(() -> new PropertyException("Missing value for feature '%s'".formatted(feature)));
                if (value.startsWith("v")) {
                    map.put(feature + ":" + value, true);
                } else {
                    map.put(feature, switch (value) {
                        case "enabled" -> Boolean.TRUE;
                        case "disabled" -> Boolean.FALSE;
                        default -> null;
                    });
                }
            }
        });
        return map;
    }
}

