/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile.impl;

import io.github.dmlloyd.classfile.Attribute;
import io.github.dmlloyd.classfile.AttributedElement;
import io.github.dmlloyd.classfile.ClassFileElement;
import io.github.dmlloyd.classfile.CompoundElement;
import io.github.dmlloyd.classfile.impl.AbstractElement;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class AbstractUnboundModel<E extends ClassFileElement>
extends AbstractElement
implements CompoundElement<E>,
AttributedElement {
    final List<E> elements;
    private List<Attribute<?>> attributes;

    public AbstractUnboundModel(List<E> elements) {
        this.elements = Collections.unmodifiableList(elements);
    }

    @Override
    public void forEach(Consumer<? super E> consumer) {
        this.elements.forEach(consumer);
    }

    @Override
    public Stream<E> elementStream() {
        return this.elements.stream();
    }

    @Override
    public List<E> elementList() {
        return this.elements;
    }

    @Override
    public List<Attribute<?>> attributes() {
        if (this.attributes == null) {
            this.attributes = this.elements.stream().mapMulti((e, sink) -> {
                if (e instanceof Attribute) {
                    Attribute attr = (Attribute)e;
                    sink.accept(attr);
                }
            }).toList();
        }
        return this.attributes;
    }
}

