/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.datasource.deployment.spi;

import io.quarkus.builder.item.SimpleBuildItem;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public final class DevServicesDatasourceResultBuildItem
extends SimpleBuildItem {
    final Map<String, DbResult> dataSources;

    public DevServicesDatasourceResultBuildItem(Map<String, DbResult> dataSources) {
        this.dataSources = Collections.unmodifiableMap(dataSources);
    }

    public DbResult getDefaultDatasource() {
        return this.dataSources.get("<default>");
    }

    public Map<String, DbResult> getNamedDatasources() {
        return this.dataSources.entrySet().stream().filter(e -> !DataSourceUtil.isDefault((String)((String)e.getKey()))).collect(Collectors.toUnmodifiableMap(e -> (String)e.getKey(), e -> (DbResult)e.getValue()));
    }

    public Map<String, DbResult> getDatasources() {
        return this.dataSources;
    }

    public static DbResult resolve(Optional<DevServicesDatasourceResultBuildItem> devDbResultBuildItem, String dataSourceName) {
        if (devDbResultBuildItem.isPresent()) {
            return devDbResultBuildItem.get().dataSources.get(dataSourceName);
        }
        return null;
    }

    public static class DbResult {
        final String dbType;
        final Map<String, String> configProperties;

        public DbResult(String dbType, Map<String, String> configProperties) {
            this.dbType = dbType;
            this.configProperties = Collections.unmodifiableMap(configProperties);
        }

        public String getDbType() {
            return this.dbType;
        }

        public Map<String, String> getConfigProperties() {
            return this.configProperties;
        }
    }
}

