/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.cluster.infinispan;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.context.Flag;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.Merged;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.MergeEvent;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.cluster.ClusterProviderFactory;
import org.keycloak.cluster.infinispan.InfinispanClusterProvider;
import org.keycloak.cluster.infinispan.LockEntryPredicate;
import org.keycloak.common.Profile;
import org.keycloak.common.util.Time;
import org.keycloak.connections.infinispan.DefaultInfinispanConnectionProviderFactory;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.infinispan.util.InfinispanUtils;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.EnvironmentDependentProviderFactory;

public class InfinispanClusterProviderFactory
implements ClusterProviderFactory,
EnvironmentDependentProviderFactory {
    protected static final Logger logger = Logger.getLogger(InfinispanClusterProviderFactory.class);
    private volatile Cache<String, Object> workCache;
    private volatile ClusterProvider clusterProvider;
    private final ExecutorService localExecutor = Executors.newCachedThreadPool(r -> {
        Thread thread = Executors.defaultThreadFactory().newThread(r);
        thread.setName(this.getClass().getName() + "-" + thread.getName());
        return thread;
    });
    private ViewChangeListener workCacheListener;

    public ClusterProvider create(KeycloakSession session) {
        return this.lazyInit(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClusterProvider lazyInit(KeycloakSession session) {
        if (this.clusterProvider != null) {
            return this.clusterProvider;
        }
        InfinispanClusterProviderFactory infinispanClusterProviderFactory = this;
        synchronized (infinispanClusterProviderFactory) {
            if (this.clusterProvider != null) {
                return this.clusterProvider;
            }
            InfinispanConnectionProvider ispnConnections = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
            this.workCache = ispnConnections.getCache("work");
            this.workCacheListener = new ViewChangeListener();
            this.workCache.getCacheManager().addListener((Object)this.workCacheListener);
            int clusterStartupTime = this.initClusterStartupTime(session);
            InfinispanClusterProvider cp = new InfinispanClusterProvider(clusterStartupTime, ispnConnections.getNodeInfo(), this.workCache, this.localExecutor);
            this.workCache.addListener((Object)cp.new InfinispanClusterProvider.CacheEntryListener());
            logger.debugf("Added listener for infinispan cache: %s", (Object)this.workCache.getName());
            this.clusterProvider = cp;
            return this.clusterProvider;
        }
    }

    protected int initClusterStartupTime(KeycloakSession session) {
        Integer existingClusterStartTime = (Integer)this.workCache.get((Object)"cluster-start-time");
        if (existingClusterStartTime != null) {
            if (logger.isDebugEnabled()) {
                logger.debugf("Loaded cluster startup time: %s", (Object)Time.toDate((int)existingClusterStartTime).toString());
            }
            return existingClusterStartTime;
        }
        int serverStartTime = (int)(session.getKeycloakSessionFactory().getServerStartupTimestamp() / 1000L);
        existingClusterStartTime = (Integer)this.workCache.putIfAbsent((Object)"cluster-start-time", (Object)serverStartTime);
        if (existingClusterStartTime == null) {
            if (logger.isDebugEnabled()) {
                logger.debugf("Initialized cluster startup time to %s", (Object)Time.toDate((int)serverStartTime).toString());
            }
            return serverStartTime;
        }
        if (logger.isDebugEnabled()) {
            logger.debugf("Loaded cluster startup time: %s", (Object)Time.toDate((int)existingClusterStartTime).toString());
        }
        return existingClusterStartTime;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        InfinispanClusterProviderFactory infinispanClusterProviderFactory = this;
        synchronized (infinispanClusterProviderFactory) {
            if (this.workCache != null && this.workCacheListener != null) {
                this.workCache.removeListener((Object)this.workCacheListener);
                this.workCacheListener = null;
                this.localExecutor.shutdown();
            }
        }
    }

    public String getId() {
        return "infinispan";
    }

    public boolean isSupported(Config.Scope config) {
        return InfinispanUtils.isEmbeddedInfinispan();
    }

    @Listener
    public class ViewChangeListener {
        @Merged
        public void mergeEvent(MergeEvent event) {
            InfinispanClusterProviderFactory.this.localExecutor.execute(() -> Arrays.stream(InfinispanConnectionProvider.LOCAL_CACHE_NAMES).map(name -> InfinispanClusterProviderFactory.this.workCache.getCacheManager().getCache(name)).filter(cache -> cache.getCacheConfiguration().clustering().cacheMode() == CacheMode.LOCAL).forEach(Cache::clear));
            if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.PERSISTENT_USER_SESSIONS)) {
                InfinispanClusterProviderFactory.this.localExecutor.execute(() -> Arrays.stream(InfinispanConnectionProvider.USER_AND_CLIENT_SESSION_CACHES).map(name -> InfinispanClusterProviderFactory.this.workCache.getCacheManager().getCache(name).getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL)).forEach(Cache::clear));
            }
        }

        @ViewChanged
        public void viewChanged(ViewChangedEvent event) {
            Set<String> removedNodesAddresses = this.convertAddresses(event.getOldMembers());
            Set<String> newAddresses = this.convertAddresses(event.getNewMembers());
            InfinispanClusterProviderFactory.this.localExecutor.execute(() -> {
                try {
                    if (InfinispanClusterProviderFactory.this.workCache.getCacheManager().isCoordinator()) {
                        removedNodesAddresses.removeAll(newAddresses);
                        if (removedNodesAddresses.isEmpty()) {
                            return;
                        }
                        logger.debugf("Nodes %s removed from cluster. Removing tasks locked by this nodes", (Object)removedNodesAddresses.toString());
                        DefaultInfinispanConnectionProviderFactory.runWithReadLockOnCacheManager(() -> {
                            if (InfinispanClusterProviderFactory.this.workCache.getStatus() == ComponentStatus.RUNNING) {
                                InfinispanClusterProviderFactory.this.workCache.entrySet().removeIf((Predicate)new LockEntryPredicate(removedNodesAddresses));
                            } else {
                                logger.warn((Object)"work cache is not running, ignoring event");
                            }
                        });
                    }
                }
                catch (Throwable t) {
                    logger.error((Object)"caught exception in ViewChangeListener", t);
                }
            });
        }

        private Set<String> convertAddresses(Collection<Address> addresses) {
            return addresses.stream().map(Object::toString).collect(Collectors.toSet());
        }
    }
}

