/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.process;

import com.github.kokorin.jaffree.log.LogMessage;
import com.github.kokorin.jaffree.log.LogMessageIterator;
import com.github.kokorin.jaffree.process.StdReader;
import com.github.kokorin.jaffree.util.LineIterator;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseStdReader<T>
implements StdReader<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseStdReader.class);
    private final List<LogMessage> errorLogMessages = new ArrayList<LogMessage>();

    @Override
    public T read(InputStream stdOut) {
        LogMessageIterator logMessageIterator = new LogMessageIterator(new LineIterator(new BufferedReader(new InputStreamReader(stdOut))));
        T result = this.defaultResult();
        while (logMessageIterator.hasNext()) {
            T possibleResult;
            LogMessage logMessage = logMessageIterator.next();
            if (logMessage.logLevel != null) {
                switch (logMessage.logLevel) {
                    case TRACE: {
                        LOGGER.trace(logMessage.message);
                        break;
                    }
                    case VERBOSE: 
                    case DEBUG: {
                        LOGGER.debug(logMessage.message);
                        break;
                    }
                    case INFO: {
                        LOGGER.info(logMessage.message);
                        break;
                    }
                    case WARNING: {
                        LOGGER.warn(logMessage.message);
                        break;
                    }
                    case ERROR: 
                    case FATAL: 
                    case PANIC: 
                    case QUIET: {
                        this.errorLogMessages.add(logMessage);
                        LOGGER.error(logMessage.message);
                    }
                }
            } else {
                LOGGER.info(logMessage.message);
            }
            if ((possibleResult = this.handleLogMessage(logMessage)) == null) continue;
            result = possibleResult;
        }
        return result;
    }

    @Override
    public List<LogMessage> getErrorLogMessages() {
        return this.errorLogMessages;
    }

    protected T defaultResult() {
        return null;
    }

    protected abstract T handleLogMessage(LogMessage var1);
}

