# -*- coding:binary -*-
require 'spec_helper'

RSpec.describe Rex::Proto::Kerberos::Crypto::Rc4Hmac do
  subject(:encryptor) do
    described_class.new
  end

  it 'GSS decrypts' do
    # Test case based off impacket
    key = ['6caf04855ca612accd54957b1249ba91'].pack('H*')
    enc_key = Rex::Proto::Kerberos::Model::EncryptionKey.new
    enc_key.type = Rex::Proto::Kerberos::Crypto::Encryption::RC4_HMAC
    enc_key.value = key
    ciphertext = ['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'].pack('H*')
    sequence_number = 45680363
    decrypted = encryptor.gss_unwrap(ciphertext, enc_key, sequence_number, true)
  end

  it 'GSS Crypto matches expected values' do
    # Test case based off impacket
    key = ['b538555db2c7d50e04030b33179a0a4b'].pack('H*')
    enc_key = Rex::Proto::Kerberos::Model::EncryptionKey.new
    enc_key.type = Rex::Proto::Kerberos::Crypto::Encryption::RC4_HMAC
    enc_key.value = key
    plaintext = ['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'].pack('H*')
    sequence_number = 0x367407d6
    encrypted = encryptor.gss_wrap(plaintext, enc_key, sequence_number, true)
    decrypted = encryptor.gss_unwrap(encrypted[0], enc_key, sequence_number, true)
    expect(decrypted).to eq(plaintext)
  end

  it 'Crypto matches expected values' do
    # Test case based off impacket
    key = ['68F263DB3FCE15D031C9EAB02D67107A'].pack('H*')
    confounder = ['37245E73A45FBF72'].pack('H*')
    keyusage = 4
    plaintext = '30 bytes bytes bytes bytes byt'
    ciphertext = ['95F9047C3AD75891C2E9B04B16566DC8B6EB9CE4231AFB2542EF87A7B5A0F260A99F0460508DE0CECC632D07C354124E46C5D2234EB8'].pack('H*')
    encrypted = encryptor.encrypt(plaintext, key, keyusage, confounder: confounder)
    decrypted = encryptor.decrypt(ciphertext, key, keyusage)

    expect(encrypted).to eq(ciphertext)
    expect(decrypted).to eq(plaintext)
  end

  it 'Key usage mapping occurs' do
    # Ensure keyusage of 3 is mapped to 8
    key = ['68F263DB3FCE15D031C9EAB02D67107A'].pack('H*')
    confounder = ['37245E73A45FBF72'].pack('H*')
    keyusage = 3 # Should be mapped to 8, and thus give different result than otherwise
    plaintext = '30 bytes bytes bytes bytes byt'
    ciphertext = ['5CD209AE59045F4370E23C5BCF4249ADD7C38FD17BDE44E3A55CE53ABDEECEE60A1A8A720F355FF62B16385D344E0F374463758B0448'].pack('H*')
    encrypted = encryptor.encrypt(plaintext, key, keyusage, confounder: confounder)
    decrypted = encryptor.decrypt(ciphertext, key, keyusage)

    expect(encrypted).to eq(ciphertext)
    expect(decrypted).to eq(plaintext)
  end

  it 'String to key generation is as expected' do
    # Per RFC4757
    string = 'foo'
    key = ['AC8E657F83DF82BEEA5D43BDAF7800CC'].pack('H*')
    k = encryptor.string_to_key(string, nil)
    expect(k).to eq(key)
  end

  it 'Checksum is as expected' do
    # Test case based off impacket
    key = ['F7D3A155AF5E238A0B7A871A96BA2AB2'].pack('H*')
    keyusage = 6
    plaintext = 'seventeen eighteen nineteen twenty'
    expected_checksum = ['EB38CC97E2230F59DA4117DC5859D7EC'].pack('H*')
    checksum = encryptor.checksum(key, keyusage, plaintext)
    expect(checksum).to eq(expected_checksum)
  end
end
