/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.util.Objects;
import org.apache.lucene.search.Query;

public record BooleanClause(Query query, Occur occur) {
    public BooleanClause {
        Objects.requireNonNull(query, "Query must not be null");
        Objects.requireNonNull(occur, "Occur must not be null");
    }

    public boolean isProhibited() {
        return Occur.MUST_NOT == this.occur;
    }

    public boolean isRequired() {
        return this.occur == Occur.MUST || this.occur == Occur.FILTER;
    }

    public boolean isScoring() {
        return this.occur == Occur.MUST || this.occur == Occur.SHOULD;
    }

    public static enum Occur {
        MUST{

            public String toString() {
                return "+";
            }
        }
        ,
        FILTER{

            public String toString() {
                return "#";
            }
        }
        ,
        SHOULD{

            public String toString() {
                return "";
            }
        }
        ,
        MUST_NOT{

            public String toString() {
                return "-";
            }
        };

    }
}

