/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.script.filter.lucene;

import org.apache.lucene.search.join.ScoreMode;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.FunctionExpression;
import org.opensearch.sql.expression.LiteralExpression;
import org.opensearch.sql.expression.ReferenceExpression;
import org.opensearch.sql.opensearch.storage.script.filter.lucene.LuceneQuery;

public class NestedQuery
extends LuceneQuery {
    public QueryBuilder buildNested(FunctionExpression func, LuceneQuery innerQuery) {
        FunctionExpression nestedFunc = (FunctionExpression)func.getArguments().get(0);
        this.validateArgs(nestedFunc, func.getArguments().get(1));
        ExprValue literalValue = func.getArguments().get(1).valueOf();
        ReferenceExpression ref = (ReferenceExpression)nestedFunc.getArguments().get(0);
        QueryBuilder innerQueryResult = innerQuery.doBuild(ref.getAttr(), nestedFunc.type(), literalValue);
        boolean hasPathParam = nestedFunc.getArguments().size() == 2;
        String pathStr = hasPathParam ? nestedFunc.getArguments().get(1).toString() : this.getNestedPathString((ReferenceExpression)nestedFunc.getArguments().get(0));
        return QueryBuilders.nestedQuery((String)pathStr, (QueryBuilder)innerQueryResult, (ScoreMode)ScoreMode.None);
    }

    private String getNestedPathString(ReferenceExpression field) {
        Object ret = "";
        for (int i = 0; i < field.getPaths().size() - 1; ++i) {
            ret = (String)ret + (String)(i == 0 ? field.getPaths().get(i) : "." + field.getPaths().get(i));
        }
        return ret;
    }

    private void validateArgs(FunctionExpression nestedFunc, Expression rightExpression) {
        if (nestedFunc.getArguments().size() > 2) {
            throw new IllegalArgumentException("nested function supports 2 parameters (field, path) or 1 parameter (field)");
        }
        for (Expression arg : nestedFunc.getArguments()) {
            if (arg instanceof ReferenceExpression) continue;
            throw new IllegalArgumentException(String.format("Illegal nested field name: %s", arg.toString()));
        }
        if (!(rightExpression instanceof LiteralExpression)) {
            throw new IllegalArgumentException(String.format("Illegal argument on right side of predicate expression: %s", rightExpression.toString()));
        }
    }
}

