/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor.collapse;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.Sort;
import org.opensearch.neuralsearch.processor.CompoundTopDocs;
import org.opensearch.neuralsearch.processor.combination.CombineScoresDto;
import org.opensearch.search.query.QuerySearchResult;

public class CollapseDTO {
    private final List<CompoundTopDocs> collapseQueryTopDocs;
    private final List<QuerySearchResult> collapseQuerySearchResults;
    private final Sort collapseSort;
    private final int indexOfFirstNonEmpty;
    private final boolean isFetchPhaseExecuted;
    private final CombineScoresDto collapseCombineScoresDTO;
    private List<? extends Map.Entry<?, FieldDoc>> relevantCollapseEntries;
    private String collapseField;
    private CompoundTopDocs updatedCollapseTopDocs;
    private int collapseShardIndex;

    public CollapseDTO(List<CompoundTopDocs> collapseQueryTopDocs, List<QuerySearchResult> collapseQuerySearchResults, Sort collapseSort, int indexOfFirstNonEmpty, boolean isFetchPhaseExecuted, CombineScoresDto collapseCombineScoresDTO) {
        this.collapseQueryTopDocs = Collections.unmodifiableList(collapseQueryTopDocs);
        this.collapseQuerySearchResults = collapseQuerySearchResults;
        this.collapseSort = collapseSort;
        this.indexOfFirstNonEmpty = indexOfFirstNonEmpty;
        this.isFetchPhaseExecuted = isFetchPhaseExecuted;
        this.collapseCombineScoresDTO = collapseCombineScoresDTO;
    }

    public <T> void updateForShard(List<Map.Entry<T, FieldDoc>> relevantCollapseEntries, String collapseField, CompoundTopDocs updatedCollapseTopDocs, int collapseShardIndex) {
        this.relevantCollapseEntries = relevantCollapseEntries;
        this.collapseField = collapseField;
        this.updatedCollapseTopDocs = updatedCollapseTopDocs;
        this.collapseShardIndex = collapseShardIndex;
    }

    @Generated
    public List<CompoundTopDocs> getCollapseQueryTopDocs() {
        return this.collapseQueryTopDocs;
    }

    @Generated
    public List<QuerySearchResult> getCollapseQuerySearchResults() {
        return this.collapseQuerySearchResults;
    }

    @Generated
    public Sort getCollapseSort() {
        return this.collapseSort;
    }

    @Generated
    public int getIndexOfFirstNonEmpty() {
        return this.indexOfFirstNonEmpty;
    }

    @Generated
    public boolean isFetchPhaseExecuted() {
        return this.isFetchPhaseExecuted;
    }

    @Generated
    public CombineScoresDto getCollapseCombineScoresDTO() {
        return this.collapseCombineScoresDTO;
    }

    @Generated
    public List<? extends Map.Entry<?, FieldDoc>> getRelevantCollapseEntries() {
        return this.relevantCollapseEntries;
    }

    @Generated
    public String getCollapseField() {
        return this.collapseField;
    }

    @Generated
    public CompoundTopDocs getUpdatedCollapseTopDocs() {
        return this.updatedCollapseTopDocs;
    }

    @Generated
    public int getCollapseShardIndex() {
        return this.collapseShardIndex;
    }
}

