/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.resources;

import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.IoEventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.unix.DomainSocketChannel;
import io.netty.channel.unix.ServerDomainSocketChannel;
import io.netty.channel.uring.IoUring;
import io.netty.channel.uring.IoUringDatagramChannel;
import io.netty.channel.uring.IoUringDomainSocketChannel;
import io.netty.channel.uring.IoUringIoHandle;
import io.netty.channel.uring.IoUringIoHandler;
import io.netty.channel.uring.IoUringServerDomainSocketChannel;
import io.netty.channel.uring.IoUringServerSocketChannel;
import io.netty.channel.uring.IoUringSocketChannel;
import java.util.concurrent.ThreadFactory;
import reactor.netty.resources.ColocatedEventLoopGroup;
import reactor.netty.resources.DefaultLoop;
import reactor.util.Logger;
import reactor.util.Loggers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class DefaultLoopIOUring
implements DefaultLoop {
    static final Logger log = Loggers.getLogger(DefaultLoopIOUring.class);
    static final boolean isIoUringAvailable;

    DefaultLoopIOUring() {
    }

    @Override
    public <CHANNEL extends Channel> CHANNEL getChannel(Class<CHANNEL> channelClass) {
        if (channelClass.equals(SocketChannel.class)) {
            return (CHANNEL)new IoUringSocketChannel();
        }
        if (channelClass.equals(ServerSocketChannel.class)) {
            return (CHANNEL)new IoUringServerSocketChannel();
        }
        if (channelClass.equals(DatagramChannel.class)) {
            return (CHANNEL)new IoUringDatagramChannel();
        }
        if (channelClass.equals(DomainSocketChannel.class)) {
            return (CHANNEL)new IoUringDomainSocketChannel();
        }
        if (channelClass.equals(ServerDomainSocketChannel.class)) {
            return (CHANNEL)new IoUringServerDomainSocketChannel();
        }
        throw new IllegalArgumentException("Unsupported channel type: " + channelClass.getSimpleName());
    }

    @Override
    public <CHANNEL extends Channel> Class<? extends CHANNEL> getChannelClass(Class<CHANNEL> channelClass) {
        if (channelClass.equals(SocketChannel.class)) {
            return IoUringSocketChannel.class;
        }
        if (channelClass.equals(ServerSocketChannel.class)) {
            return IoUringServerSocketChannel.class;
        }
        if (channelClass.equals(DatagramChannel.class)) {
            return IoUringDatagramChannel.class;
        }
        throw new IllegalArgumentException("Unsupported channel type: " + channelClass.getSimpleName());
    }

    @Override
    public String getName() {
        return "io_uring";
    }

    @Override
    public EventLoopGroup newEventLoopGroup(int threads, ThreadFactory factory) {
        return new MultiThreadIoEventLoopGroup(threads, factory, IoUringIoHandler.newFactory());
    }

    @Override
    public boolean supportGroup(EventLoopGroup group) {
        if (group instanceof ColocatedEventLoopGroup) {
            group = ((ColocatedEventLoopGroup)group).get();
        }
        return group instanceof IoEventLoopGroup && ((IoEventLoopGroup)group).isCompatible(IoUringIoHandle.class);
    }

    static {
        boolean ioUringCheck = false;
        try {
            Class.forName("io.netty.channel.uring.IoUring");
            ioUringCheck = IoUring.isAvailable();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        isIoUringAvailable = ioUringCheck;
        if (log.isDebugEnabled()) {
            log.debug("Default io_uring support : " + isIoUringAvailable);
        }
    }
}

