/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.auth.ldap.backend;

import com.google.common.collect.HashMultimap;
import io.netty.util.internal.PlatformDependent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.net.ssl.TrustManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ldaptive.BindConnectionInitializer;
import org.ldaptive.BindRequest;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.ConnectionInitializer;
import org.ldaptive.Credential;
import org.ldaptive.DefaultConnectionFactory;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.Response;
import org.ldaptive.ReturnAttributes;
import org.ldaptive.SearchFilter;
import org.ldaptive.SearchScope;
import org.ldaptive.control.RequestControl;
import org.ldaptive.provider.ProviderConnection;
import org.ldaptive.sasl.Mechanism;
import org.ldaptive.sasl.SaslConfig;
import org.ldaptive.ssl.AllowAnyHostnameVerifier;
import org.ldaptive.ssl.AllowAnyTrustManager;
import org.ldaptive.ssl.CertificateHostnameVerifier;
import org.ldaptive.ssl.CredentialConfig;
import org.ldaptive.ssl.CredentialConfigFactory;
import org.ldaptive.ssl.SslConfig;
import org.ldaptive.ssl.ThreadLocalTLSSocketFactory;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.Strings;
import org.opensearch.secure_sm.AccessController;
import org.opensearch.security.auth.AuthenticationContext;
import org.opensearch.security.auth.AuthorizationBackend;
import org.opensearch.security.auth.ldap.backend.LDAPAuthenticationBackend;
import org.opensearch.security.auth.ldap.util.LdapHelper;
import org.opensearch.security.auth.ldap.util.Utils;
import org.opensearch.security.ssl.SecureSSLSettings;
import org.opensearch.security.support.PemKeyReader;
import org.opensearch.security.support.WildcardMatcher;
import org.opensearch.security.user.User;

public class LDAPAuthorizationBackend
implements AuthorizationBackend {
    private static final AtomicInteger CONNECTION_COUNTER = new AtomicInteger();
    private static final String COM_SUN_JNDI_LDAP_OBJECT_DISABLE_ENDPOINT_IDENTIFICATION = "com.sun.jndi.ldap.object.disableEndpointIdentification";
    private static final List<String> DEFAULT_TLS_PROTOCOLS = Arrays.asList("TLSv1.2", "TLSv1.1");
    static final int ONE_PLACEHOLDER = 1;
    static final int TWO_PLACEHOLDER = 2;
    static final String DEFAULT_ROLEBASE = "";
    static final String DEFAULT_ROLESEARCH = "(member={0})";
    static final String DEFAULT_ROLENAME = "name";
    static final String DEFAULT_USERROLENAME = "memberOf";
    protected static final Logger log = LogManager.getLogger(LDAPAuthorizationBackend.class);
    private final Settings settings;
    private final WildcardMatcher skipUsersMatcher;
    private final WildcardMatcher excludeRolesMatcher;
    private final WildcardMatcher nestedRoleMatcher;
    private final Path configPath;
    private final List<Map.Entry<String, Settings>> roleBaseSettings;
    private final List<Map.Entry<String, Settings>> userBaseSettings;
    private final String[] returnAttributes;
    private final boolean shouldFollowReferrals;
    private static final Class clazz = ThreadLocalTLSSocketFactory.class;

    public LDAPAuthorizationBackend(Settings settings, Path configPath) {
        this.settings = settings;
        this.skipUsersMatcher = WildcardMatcher.from(settings.getAsList("skip_users"));
        this.excludeRolesMatcher = WildcardMatcher.from(settings.getAsList("exclude_roles"));
        this.nestedRoleMatcher = settings.getAsBoolean("resolve_nested_roles", Boolean.valueOf(false)) != false ? WildcardMatcher.from(settings.getAsList("nested_role_filter")) : null;
        this.configPath = configPath;
        this.roleBaseSettings = LDAPAuthorizationBackend.getRoleSearchSettings(settings);
        this.userBaseSettings = LDAPAuthenticationBackend.getUserBaseSettings(settings);
        this.returnAttributes = settings.getAsList("custom_return_attributes", Arrays.asList(ReturnAttributes.ALL.value())).toArray(new String[0]);
        this.shouldFollowReferrals = settings.getAsBoolean("follow_referrals", Boolean.valueOf(true));
    }

    public static void checkConnection(ConnectionConfig connectionConfig, String bindDn, byte[] password) throws Exception {
        AccessController.doPrivilegedChecked(() -> {
            boolean isJava9OrHigher = PlatformDependent.javaVersion() >= 9;
            ClassLoader originalClassloader = null;
            if (isJava9OrHigher) {
                originalClassloader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(new Java9CL());
            }
            LDAPAuthorizationBackend.checkConnection0(connectionConfig, bindDn, password, originalClassloader, isJava9OrHigher);
        });
    }

    public static Connection getConnection(Settings settings, Path configPath) throws Exception {
        return (Connection)AccessController.doPrivilegedChecked(() -> {
            boolean isJava9OrHigher = PlatformDependent.javaVersion() >= 9;
            ClassLoader originalClassloader = null;
            if (isJava9OrHigher) {
                originalClassloader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(new Java9CL());
            }
            return LDAPAuthorizationBackend.getConnection0(settings, configPath, originalClassloader, isJava9OrHigher);
        });
    }

    private static List<Map.Entry<String, Settings>> getRoleSearchSettings(Settings settings) {
        Map groupedSettings = settings.getGroups("roles", true);
        if (!groupedSettings.isEmpty()) {
            return Utils.getOrderedBaseSettings(groupedSettings);
        }
        return LDAPAuthorizationBackend.convertOldStyleSettingsToNewStyle(settings);
    }

    private static List<Map.Entry<String, Settings>> convertOldStyleSettingsToNewStyle(Settings settings) {
        HashMap<String, Settings> result = new HashMap<String, Settings>(1);
        Settings.Builder settingsBuilder = Settings.builder();
        settingsBuilder.put("base", settings.get("rolebase", DEFAULT_ROLEBASE));
        settingsBuilder.put("search", settings.get("rolesearch", DEFAULT_ROLESEARCH));
        result.put("convertedOldStyleSettings", settingsBuilder.build());
        return Collections.singletonList(result.entrySet().iterator().next());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkConnection0(ConnectionConfig connectionConfig, String bindDn, byte[] password, ClassLoader cl, boolean needRestore) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException, LdapException {
        Connection connection = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug("bindDn {}, password {}", (Object)bindDn, (Object)(password != null && password.length > 0 ? "****" : "<not set>"));
            }
            if (bindDn != null && (password == null || password.length == 0)) {
                throw new LdapException("no bindDn or no Password");
            }
            ConnectionConfig config = ConnectionConfig.newConnectionConfig((ConnectionConfig)connectionConfig);
            config.setConnectionInitializer((ConnectionInitializer)new BindConnectionInitializer(bindDn, new Credential(password)));
            DefaultConnectionFactory connFactory = new DefaultConnectionFactory(config);
            connection = connFactory.getConnection();
            connection.open();
        }
        catch (Throwable throwable) {
            Utils.unbindAndCloseSilently(connection);
            connection = null;
            if (needRestore) {
                try {
                    AccessController.doPrivilegedChecked(() -> Thread.currentThread().setContextClassLoader(cl));
                }
                catch (Exception e) {
                    log.warn("Unable to restore classloader because of ", (Throwable)e);
                }
            }
            throw throwable;
        }
        Utils.unbindAndCloseSilently(connection);
        connection = null;
        if (needRestore) {
            try {
                AccessController.doPrivilegedChecked(() -> Thread.currentThread().setContextClassLoader(cl));
            }
            catch (Exception e) {
                log.warn("Unable to restore classloader because of ", (Throwable)e);
            }
        }
    }

    private static Connection getConnection0(Settings settings, Path configPath, final ClassLoader cl, final boolean needRestore) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException, LdapException {
        boolean enableSSL = settings.getAsBoolean("enable_ssl", Boolean.valueOf(false));
        List ldapHosts = settings.getAsList("hosts", Collections.singletonList("localhost"));
        Connection connection = null;
        Exception lastException = null;
        final boolean isDebugEnabled = log.isDebugEnabled();
        boolean isTraceEnabled = log.isTraceEnabled();
        for (String ldapHost : ldapHosts) {
            if (isTraceEnabled) {
                log.trace("Connect to {}", (Object)ldapHost);
            }
            try {
                String[] split = ldapHost.split(":");
                int port = split.length > 1 ? Integer.parseInt(split[1]) : (enableSSL ? 636 : 389);
                ConnectionConfig config = new ConnectionConfig();
                config.setLdapUrl("ldap" + (enableSSL ? "s" : DEFAULT_ROLEBASE) + "://" + split[0] + ":" + port);
                if (isTraceEnabled) {
                    log.trace("Connect to {}", (Object)config.getLdapUrl());
                }
                LDAPAuthorizationBackend.configureSSL(config, settings, configPath);
                String bindDn = settings.get("bind_dn", null);
                String password = settings.get("password", null);
                if (isDebugEnabled) {
                    log.debug("bindDn {}, password {}", (Object)bindDn, (Object)(password != null && password.length() > 0 ? "****" : "<not set>"));
                }
                if (bindDn != null && (password == null || password.length() == 0)) {
                    log.error("No password given for bind_dn {}. Will try to authenticate anonymously to ldap", (Object)bindDn);
                }
                boolean enableClientAuth = settings.getAsBoolean("enable_ssl_client_auth", Boolean.valueOf(false));
                if (isDebugEnabled) {
                    if (enableClientAuth && bindDn == null) {
                        log.debug("Will perform External SASL bind because client cert authentication is enabled");
                    } else if (bindDn == null) {
                        log.debug("Will perform anonymous bind because no bind dn is given");
                    } else if (enableClientAuth && bindDn != null) {
                        log.debug("Will perform simple bind with bind dn because to bind dn is given and overrides client cert authentication");
                    } else if (!enableClientAuth && bindDn != null) {
                        log.debug("Will perform simple bind with bind dn");
                    }
                }
                if (bindDn != null && password != null && password.length() > 0) {
                    config.setConnectionInitializer((ConnectionInitializer)new BindConnectionInitializer(bindDn, new Credential(password)));
                } else if (enableClientAuth) {
                    SaslConfig saslConfig = new SaslConfig();
                    saslConfig.setMechanism(Mechanism.EXTERNAL);
                    BindConnectionInitializer bindConnectionInitializer = new BindConnectionInitializer();
                    bindConnectionInitializer.setBindSaslConfig(saslConfig);
                    config.setConnectionInitializer((ConnectionInitializer)bindConnectionInitializer);
                }
                DefaultConnectionFactory connFactory = new DefaultConnectionFactory(config);
                connection = connFactory.getConnection();
                connection.open();
                if (connection != null && connection.isOpen()) break;
                Utils.unbindAndCloseSilently(connection);
                if (needRestore) {
                    LDAPAuthorizationBackend.restoreClassLoader0(cl);
                }
                connection = null;
            }
            catch (Exception e) {
                lastException = e;
                log.warn("Unable to connect to ldapserver {} due to {}. Try next.", (Object)ldapHost, (Object)e.toString());
                Utils.unbindAndCloseSilently(connection);
                if (needRestore) {
                    LDAPAuthorizationBackend.restoreClassLoader0(cl);
                }
                connection = null;
            }
        }
        if (connection == null || !connection.isOpen()) {
            Utils.unbindAndCloseSilently(connection);
            if (needRestore) {
                LDAPAuthorizationBackend.restoreClassLoader0(cl);
            }
            connection = null;
            if (lastException == null) {
                throw new LdapException("Unable to connect to any of those ldap servers " + String.valueOf(ldapHosts));
            }
            throw new LdapException("Unable to connect to any of those ldap servers " + String.valueOf(ldapHosts) + " due to " + String.valueOf(lastException), lastException);
        }
        final Connection delegate = connection;
        if (isDebugEnabled) {
            log.debug("Opened a connection, total count is now {}", (Object)CONNECTION_COUNTER.incrementAndGet());
        }
        return new Connection(){

            public Response<Void> reopen(BindRequest request) throws LdapException {
                if (isDebugEnabled) {
                    log.debug("Reopened a connection");
                }
                return delegate.reopen(request);
            }

            public Response<Void> reopen() throws LdapException {
                if (isDebugEnabled) {
                    log.debug("Reopened a connection");
                }
                return delegate.reopen();
            }

            public Response<Void> open(BindRequest request) throws LdapException {
                try {
                    if (isDebugEnabled && delegate != null && delegate.isOpen()) {
                        log.debug("Opened a connection, total count is now {}", (Object)CONNECTION_COUNTER.incrementAndGet());
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return delegate.open(request);
            }

            public Response<Void> open() throws LdapException {
                try {
                    if (isDebugEnabled && delegate != null && delegate.isOpen()) {
                        log.debug("Opened a connection, total count is now {}", (Object)CONNECTION_COUNTER.incrementAndGet());
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return delegate.open();
            }

            public boolean isOpen() {
                return delegate.isOpen();
            }

            public ProviderConnection getProviderConnection() {
                return delegate.getProviderConnection();
            }

            public ConnectionConfig getConnectionConfig() {
                return delegate.getConnectionConfig();
            }

            public void close(RequestControl[] controls) {
                try {
                    if (isDebugEnabled && delegate != null && delegate.isOpen()) {
                        log.debug("Closed a connection, total count is now {}", (Object)CONNECTION_COUNTER.decrementAndGet());
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    delegate.close(controls);
                }
                finally {
                    this.restoreClassLoader();
                }
            }

            public void close() {
                try {
                    if (isDebugEnabled && delegate != null && delegate.isOpen()) {
                        log.debug("Closed a connection, total count is now {}", (Object)CONNECTION_COUNTER.decrementAndGet());
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    delegate.close();
                }
                finally {
                    this.restoreClassLoader();
                }
            }

            private void restoreClassLoader() {
                if (needRestore) {
                    LDAPAuthorizationBackend.restoreClassLoader0(cl);
                }
            }
        };
    }

    private static void restoreClassLoader0(ClassLoader cl) {
        try {
            AccessController.doPrivilegedChecked(() -> Thread.currentThread().setContextClassLoader(cl));
        }
        catch (Exception e) {
            log.warn("Unable to restore classloader because of", (Throwable)e);
        }
    }

    private static void configureSSL(ConnectionConfig config, Settings settings, Path configPath) throws Exception {
        boolean isDebugEnabled = log.isDebugEnabled();
        boolean enableSSL = settings.getAsBoolean("enable_ssl", Boolean.valueOf(false));
        boolean enableStartTLS = settings.getAsBoolean("enable_start_tls", Boolean.valueOf(false));
        if (enableSSL || enableStartTLS) {
            CredentialConfig cc;
            boolean verifyHostnames;
            boolean enableClientAuth = settings.getAsBoolean("enable_ssl_client_auth", Boolean.valueOf(false));
            boolean trustAll = settings.getAsBoolean("trust_all", Boolean.valueOf(false));
            boolean bl = verifyHostnames = !trustAll && settings.getAsBoolean("verify_hostnames", Boolean.valueOf(true)) != false;
            if (isDebugEnabled) {
                log.debug("verifyHostname {}:", (Object)verifyHostnames);
                log.debug("trustall {}:", (Object)trustAll);
            }
            if (enableStartTLS && !verifyHostnames) {
                System.setProperty("jndi.starttls.allowAnyHostname", "true");
            }
            boolean pem = settings.get("pemtrustedcas_filepath", null) != null || settings.get("pemtrustedcas_content", null) != null;
            SslConfig sslConfig = new SslConfig();
            if (pem) {
                PrivateKey authenticationKey;
                X509Certificate authenticationCertificate;
                X509Certificate[] trustCertificates = PemKeyReader.loadCertificatesFromStream(PemKeyReader.resolveStream("pemtrustedcas_content", settings));
                if (trustCertificates == null) {
                    trustCertificates = PemKeyReader.loadCertificatesFromFile(PemKeyReader.resolve("pemtrustedcas_filepath", settings, configPath, !trustAll));
                }
                if ((authenticationCertificate = PemKeyReader.loadCertificateFromStream(PemKeyReader.resolveStream("pemcert_content", settings))) == null) {
                    authenticationCertificate = PemKeyReader.loadCertificateFromFile(PemKeyReader.resolve("pemcert_filepath", settings, configPath, enableClientAuth));
                }
                if ((authenticationKey = PemKeyReader.loadKeyFromStream(settings.get("pemkey_password"), PemKeyReader.resolveStream("pemkey_content", settings))) == null) {
                    authenticationKey = PemKeyReader.loadKeyFromFile(settings.get("pemkey_password"), PemKeyReader.resolve("pemkey_filepath", settings, configPath, enableClientAuth));
                }
                cc = CredentialConfigFactory.createX509CredentialConfig((X509Certificate[])trustCertificates, (X509Certificate)authenticationCertificate, (PrivateKey)authenticationKey);
                if (isDebugEnabled) {
                    log.debug("Use PEM to secure communication with LDAP server (client auth is {})", (Object)(authenticationKey != null ? 1 : 0));
                }
            } else {
                String[] stringArray;
                KeyStore trustStore = PemKeyReader.loadKeyStore(PemKeyReader.resolve("plugins.security.ssl.transport.truststore_filepath", settings, configPath, !trustAll), SecureSSLSettings.SSLSetting.SECURITY_SSL_TRANSPORT_TRUSTSTORE_PASSWORD.getSetting(settings), settings.get("plugins.security.ssl.transport.truststore_type"));
                List trustStoreAliases = settings.getAsList("ca_alias", null);
                KeyStore keyStore = PemKeyReader.loadKeyStore(PemKeyReader.resolve("plugins.security.ssl.transport.keystore_filepath", settings, configPath, enableClientAuth), SecureSSLSettings.SSLSetting.SECURITY_SSL_TRANSPORT_KEYSTORE_PASSWORD.getSetting(settings, "changeit"), settings.get("plugins.security.ssl.transport.keystore_type"));
                String keyStorePassword = SecureSSLSettings.SSLSetting.SECURITY_SSL_TRANSPORT_KEYSTORE_PASSWORD.getSetting(settings, "changeit");
                String keyStoreAlias = settings.get("cert_alias", null);
                if (keyStoreAlias == null) {
                    stringArray = null;
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = keyStoreAlias;
                }
                String[] keyStoreAliases = stringArray;
                if (enableClientAuth && keyStoreAliases == null) {
                    throw new IllegalArgumentException("cert_alias not given");
                }
                if (isDebugEnabled) {
                    log.debug("Use Trust-/Keystore to secure communication with LDAP server (client auth is {})", (Object)(keyStore != null ? 1 : 0));
                    log.debug("trustStoreAliases: {}, keyStoreAlias: {}", (Object)trustStoreAliases, (Object)keyStoreAlias);
                }
                cc = CredentialConfigFactory.createKeyStoreCredentialConfig((KeyStore)trustStore, (String[])(trustStoreAliases == null ? null : trustStoreAliases.toArray(new String[0])), (KeyStore)keyStore, (String)keyStorePassword, (String[])keyStoreAliases);
            }
            sslConfig.setCredentialConfig(cc);
            if (trustAll) {
                sslConfig.setTrustManagers(new TrustManager[]{new AllowAnyTrustManager()});
            }
            if (!verifyHostnames) {
                sslConfig.setHostnameVerifier((CertificateHostnameVerifier)new AllowAnyHostnameVerifier());
                String deiProp = System.getProperty(COM_SUN_JNDI_LDAP_OBJECT_DISABLE_ENDPOINT_IDENTIFICATION);
                if (deiProp == null || !Boolean.parseBoolean(deiProp)) {
                    log.warn("In order to disable host name verification for LDAP connections (verify_hostnames: true), you also need to set set the system property com.sun.jndi.ldap.object.disableEndpointIdentification to true when starting the JVM running OpenSearch. This applies for all Java versions released since July 2018.");
                }
                System.setProperty(COM_SUN_JNDI_LDAP_OBJECT_DISABLE_ENDPOINT_IDENTIFICATION, "true");
            }
            List enabledCipherSuites = settings.getAsList("enabled_ssl_ciphers", Collections.emptyList());
            List enabledProtocols = settings.getAsList("enabled_ssl_protocols", DEFAULT_TLS_PROTOCOLS);
            if (!enabledCipherSuites.isEmpty()) {
                sslConfig.setEnabledCipherSuites(enabledCipherSuites.toArray(new String[0]));
                log.debug("enabled ssl cipher suites for ldaps {}", (Object)enabledCipherSuites);
            }
            log.debug("enabled ssl/tls protocols for ldaps {}", (Object)enabledProtocols);
            sslConfig.setEnabledProtocols(enabledProtocols.toArray(new String[0]));
            config.setSslConfig(sslConfig);
        }
        config.setUseSSL(enableSSL);
        config.setUseStartTLS(enableStartTLS);
        long connectTimeout = settings.getAsLong("connect_timeout", Long.valueOf(5000L));
        long responseTimeout = settings.getAsLong("response_timeout", Long.valueOf(0L));
        config.setConnectTimeout(Duration.ofMillis(connectTimeout < 0L ? 0L : connectTimeout));
        config.setResponseTimeout(Duration.ofMillis(responseTimeout < 0L ? 0L : responseTimeout));
        if (isDebugEnabled) {
            log.debug("Connect timeout: " + String.valueOf(config.getConnectTimeout()) + "/ResponseTimeout: " + String.valueOf(config.getResponseTimeout()));
        }
    }

    @Override
    public User addRoles(User user, AuthenticationContext context) throws OpenSearchSecurityException {
        User user2;
        boolean isTraceEnabled;
        String authenticatedUser;
        String dn;
        if (user == null) {
            return user;
        }
        String originalUserName = context.getCredentials().getUsername();
        LdapEntry entry = context.getContextData(LdapEntry.class).orElse(null);
        boolean isDebugEnabled = log.isDebugEnabled();
        if (isDebugEnabled) {
            log.debug("DBGTRACE (2): username: {} -> {}", (Object)user.getName(), (Object)Arrays.toString(user.getName().getBytes(StandardCharsets.UTF_8)));
        }
        if (entry != null) {
            authenticatedUser = dn = entry.getDn();
        } else {
            dn = null;
            authenticatedUser = user.getName();
        }
        if (isDebugEnabled) {
            log.debug("DBGTRACE (3): authenticatedUser: {} -> {}", (Object)authenticatedUser, (Object)Arrays.toString(authenticatedUser.getBytes(StandardCharsets.UTF_8)));
        }
        boolean rolesearchEnabled = this.settings.getAsBoolean("rolesearch_enabled", Boolean.valueOf(true));
        if (isDebugEnabled) {
            log.debug("Try to get roles for {}", (Object)authenticatedUser);
        }
        if (isTraceEnabled = log.isTraceEnabled()) {
            log.trace("user class: {}", user.getClass());
            log.trace("authenticatedUser: {}", (Object)authenticatedUser);
            log.trace("originalUserName: {}", (Object)originalUserName);
            log.trace("entry: {}", (Object)String.valueOf(entry));
            log.trace("dn: {}", (Object)dn);
        }
        if (this.skipUsersMatcher.test(originalUserName) || this.skipUsersMatcher.test(authenticatedUser)) {
            if (isDebugEnabled) {
                log.debug("Skipped search roles of user {}/{}", (Object)authenticatedUser, (Object)originalUserName);
            }
            return user;
        }
        Connection connection = null;
        try {
            HashSet<String> additionalRoles = new HashSet<String>();
            if (dn == null) {
                connection = LDAPAuthorizationBackend.getConnection(this.settings, this.configPath);
                if (this.isValidDn(authenticatedUser)) {
                    if (isTraceEnabled) {
                        log.trace("{} is a valid DN", (Object)authenticatedUser);
                    }
                    if (isDebugEnabled) {
                        log.debug("DBGTRACE (4): authenticatedUser=" + authenticatedUser + " -> " + Arrays.toString(authenticatedUser.getBytes(StandardCharsets.UTF_8)));
                    }
                    if ((entry = LdapHelper.lookup(connection, authenticatedUser, this.returnAttributes, this.shouldFollowReferrals)) == null) {
                        throw new OpenSearchSecurityException("No user '" + authenticatedUser + "' found", new Object[0]);
                    }
                } else {
                    if (isDebugEnabled) {
                        log.debug("DBGTRACE (5): authenticatedUser=" + user.getName() + " -> " + Arrays.toString(user.getName().getBytes(StandardCharsets.UTF_8)));
                    }
                    entry = LDAPAuthenticationBackend.exists(user.getName(), connection, this.settings, this.userBaseSettings, this.returnAttributes, this.shouldFollowReferrals);
                    if (isTraceEnabled) {
                        log.trace("{} is not a valid DN and was resolved to {}", (Object)authenticatedUser, (Object)entry);
                    }
                    if (entry == null || entry.getDn() == null) {
                        throw new OpenSearchSecurityException("No user " + authenticatedUser + " found", new Object[0]);
                    }
                }
                dn = entry.getDn();
                if (isTraceEnabled) {
                    log.trace("User found with DN {}", (Object)dn);
                }
                if (isDebugEnabled) {
                    log.debug("DBGTRACE (6): dn" + dn + " -> " + Arrays.toString(dn.getBytes(StandardCharsets.UTF_8)));
                }
            }
            HashSet<LdapName> ldapRoles = new HashSet<LdapName>(150);
            HashSet<String> nonLdapRoles = new HashSet<String>(150);
            HashMultimap resultRoleSearchBaseKeys = HashMultimap.create();
            String userRoleNames = this.settings.get("userrolename", DEFAULT_USERROLENAME);
            if (isTraceEnabled) {
                log.trace("raw userRoleName(s): {}", (Object)userRoleNames);
            }
            for (String userRoleName : userRoleNames.split(",")) {
                String roleName = userRoleName.trim();
                if (entry.getAttribute(roleName) == null) continue;
                Iterator userRoles = entry.getAttribute(roleName).getStringValues();
                Iterator iterator = userRoles.iterator();
                while (iterator.hasNext()) {
                    String possibleRoleDN = (String)iterator.next();
                    if (isDebugEnabled) {
                        log.debug("DBGTRACE (7): possibleRoleDN" + possibleRoleDN);
                    }
                    if (this.isValidDn(possibleRoleDN)) {
                        LdapName ldapName = new LdapName(possibleRoleDN);
                        ldapRoles.add(ldapName);
                        resultRoleSearchBaseKeys.putAll((Object)ldapName, this.roleBaseSettings);
                        continue;
                    }
                    nonLdapRoles.add(possibleRoleDN);
                }
            }
            if (isTraceEnabled) {
                log.trace("User attr. ldap roles count: {}", (Object)ldapRoles.size());
                log.trace("User attr. ldap roles {}", ldapRoles);
                log.trace("User attr. non-ldap roles count: {}", (Object)nonLdapRoles.size());
                log.trace("User attr. non-ldap roles {}", nonLdapRoles);
            }
            String roleName = this.settings.get("rolename", DEFAULT_ROLENAME);
            if (isTraceEnabled) {
                log.trace("roleName: {}", (Object)roleName);
            }
            String userRoleAttributeName = this.settings.get("userroleattribute", null);
            if (isTraceEnabled) {
                log.trace("userRoleAttribute: {}", (Object)userRoleAttributeName);
                log.trace("rolesearch: {}", (Object)this.settings.get("rolesearch", DEFAULT_ROLESEARCH));
            }
            String userRoleAttributeValue = null;
            LdapAttribute userRoleAttribute = entry.getAttribute(userRoleAttributeName);
            if (userRoleAttribute != null) {
                userRoleAttributeValue = Utils.getSingleStringValue(userRoleAttribute);
            }
            if (rolesearchEnabled) {
                String escapedDn = dn;
                if (isDebugEnabled) {
                    log.debug("DBGTRACE (8): escapedDn" + escapedDn);
                }
                if (connection == null) {
                    connection = LDAPAuthorizationBackend.getConnection(this.settings, this.configPath);
                }
                for (Map.Entry entry2 : this.roleBaseSettings) {
                    Settings roleSearchSettings = (Settings)entry2.getValue();
                    SearchFilter f = new SearchFilter();
                    f.setFilter(roleSearchSettings.get("search", DEFAULT_ROLESEARCH));
                    f.setParameter(0, (Object)escapedDn);
                    f.setParameter(1, (Object)originalUserName);
                    f.setParameter(2, userRoleAttributeValue == null ? Integer.valueOf(2) : userRoleAttributeValue);
                    List<LdapEntry> rolesResult = LdapHelper.search(connection, roleSearchSettings.get("base", DEFAULT_ROLEBASE), f, SearchScope.SUBTREE, this.returnAttributes, this.shouldFollowReferrals);
                    if (isTraceEnabled) {
                        log.trace("Results for LDAP group search for {} in base {}:\n{}", (Object)escapedDn, entry2.getKey(), rolesResult);
                    }
                    if (rolesResult == null || rolesResult.isEmpty()) continue;
                    for (LdapEntry searchResultEntry : rolesResult) {
                        LdapName ldapName = new LdapName(searchResultEntry.getDn());
                        ldapRoles.add(ldapName);
                        resultRoleSearchBaseKeys.put((Object)ldapName, (Object)entry2);
                    }
                }
            }
            if (isTraceEnabled) {
                log.trace("roles count total {}", (Object)ldapRoles.size());
            }
            if (this.nestedRoleMatcher != null) {
                if (isTraceEnabled) {
                    log.trace("Evaluate nested roles");
                }
                HashSet<LdapName> nestedReturn = new HashSet<LdapName>(ldapRoles);
                for (LdapName ldapName : ldapRoles) {
                    Set nameRoleSearchBaseKeys = resultRoleSearchBaseKeys.get((Object)ldapName);
                    if (nameRoleSearchBaseKeys == null) {
                        log.error("Could not find roleSearchBaseKeys for " + String.valueOf(ldapName) + "; existing: " + String.valueOf(resultRoleSearchBaseKeys));
                        continue;
                    }
                    Set<LdapName> nestedRoles = this.resolveNestedRoles(ldapName, connection, userRoleNames, 0, rolesearchEnabled, nameRoleSearchBaseKeys);
                    if (isTraceEnabled) {
                        log.trace("{} nested roles for {}", (Object)nestedRoles.size(), (Object)ldapName);
                    }
                    nestedReturn.addAll(nestedRoles);
                }
                for (LdapName ldapName : nestedReturn) {
                    String role = this.getRoleFromEntry(connection, ldapName, roleName);
                    if (this.excludeRolesMatcher.test(role)) {
                        if (!isDebugEnabled) continue;
                        log.debug("Role was excluded or empty, attribute: '{}' for entry: {}", (Object)roleName, (Object)ldapName);
                        continue;
                    }
                    additionalRoles.add(role);
                }
            } else {
                for (LdapName roleLdapName : ldapRoles) {
                    String string = this.getRoleFromEntry(connection, roleLdapName, roleName);
                    if (this.excludeRolesMatcher.test(string)) {
                        if (!isDebugEnabled) continue;
                        log.debug("Role was excluded or empty, attribute: '{}' for entry: {}", (Object)roleName, (Object)roleLdapName);
                        continue;
                    }
                    additionalRoles.add(string);
                }
            }
            additionalRoles.addAll(nonLdapRoles);
            if (isDebugEnabled) {
                log.debug("Roles for {} -> {}", (Object)user.getName(), user.getRoles());
            }
            if (isTraceEnabled) {
                log.trace("returned user: {}", (Object)user);
            }
            user2 = user.withRoles(additionalRoles);
        }
        catch (Exception e) {
            try {
                if (isDebugEnabled) {
                    log.debug("Unable to fill user roles due to ", (Throwable)e);
                }
                throw new OpenSearchSecurityException(e.toString(), e, new Object[0]);
            }
            catch (Throwable throwable) {
                Utils.unbindAndCloseSilently(connection);
                throw throwable;
            }
        }
        Utils.unbindAndCloseSilently(connection);
        return user2;
    }

    protected Set<LdapName> resolveNestedRoles(LdapName roleDn, Connection ldapConnection, String userRoleName, int depth, boolean rolesearchEnabled, Set<Map.Entry<String, Settings>> roleSearchBaseSettingsSet) throws OpenSearchSecurityException, LdapException {
        boolean isTraceEnabled;
        if (this.nestedRoleMatcher.test(roleDn.toString())) {
            if (log.isTraceEnabled()) {
                log.trace("Filter nested role {}", (Object)roleDn);
            }
            return Collections.emptySet();
        }
        ++depth;
        boolean isDebugEnabled = log.isDebugEnabled();
        HashSet<LdapName> result = new HashSet<LdapName>(20);
        HashMultimap resultRoleSearchBaseKeys = HashMultimap.create();
        LdapEntry e0 = LdapHelper.lookup(ldapConnection, roleDn.toString(), this.returnAttributes, this.shouldFollowReferrals);
        if (e0.getAttribute(userRoleName) != null) {
            Collection userRoles = e0.getAttribute(userRoleName).getStringValues();
            for (Object possibleRoleDN : userRoles) {
                if (isDebugEnabled) {
                    log.debug("DBGTRACE (10): possibleRoleDN" + (String)possibleRoleDN);
                }
                if (this.isValidDn((String)possibleRoleDN)) {
                    try {
                        LdapName ldapName = new LdapName((String)possibleRoleDN);
                        result.add(ldapName);
                        resultRoleSearchBaseKeys.putAll((Object)ldapName, this.roleBaseSettings);
                    }
                    catch (InvalidNameException invalidNameException) {}
                    continue;
                }
                if (!isDebugEnabled) continue;
                log.debug("Cannot add {} as a role because its not a valid dn", possibleRoleDN);
            }
        }
        if (isTraceEnabled = log.isTraceEnabled()) {
            log.trace("result nested attr count for depth {} : {}", (Object)depth, (Object)result.size());
        }
        if (rolesearchEnabled) {
            String escapedDn = roleDn.toString();
            if (isDebugEnabled) {
                log.debug("DBGTRACE (10): escapedDn {}", (Object)escapedDn);
            }
            for (Map.Entry entry : Utils.getOrderedBaseSettings(roleSearchBaseSettingsSet)) {
                Settings roleSearchSettings = (Settings)entry.getValue();
                SearchFilter f = new SearchFilter();
                f.setFilter(roleSearchSettings.get("search", DEFAULT_ROLESEARCH));
                f.setParameter(0, (Object)escapedDn);
                f.setParameter(1, (Object)escapedDn);
                List<LdapEntry> foundEntries = LdapHelper.search(ldapConnection, roleSearchSettings.get("base", DEFAULT_ROLEBASE), f, SearchScope.SUBTREE, this.returnAttributes, this.shouldFollowReferrals);
                if (isTraceEnabled) {
                    log.trace("Results for LDAP group search for {} in base {}:\n{}", (Object)escapedDn, entry.getKey(), foundEntries);
                }
                if (foundEntries == null) continue;
                for (LdapEntry entry2 : foundEntries) {
                    try {
                        LdapName dn = new LdapName(entry2.getDn());
                        result.add(dn);
                        resultRoleSearchBaseKeys.put((Object)dn, (Object)entry);
                    }
                    catch (InvalidNameException e) {
                        throw new LdapException((Exception)e);
                    }
                }
            }
        }
        int maxDepth = 30;
        try {
            maxDepth = this.settings.getAsInt("max_nested_depth", Integer.valueOf(30));
        }
        catch (Exception e) {
            log.error("max_nested_depth is not parseable: " + String.valueOf(e), (Throwable)e);
        }
        if (depth < maxDepth) {
            for (LdapName ldapName : new HashSet<LdapName>(result)) {
                Set nameRoleSearchBaseKeys = resultRoleSearchBaseKeys.get((Object)ldapName);
                if (nameRoleSearchBaseKeys == null) {
                    log.error("Could not find roleSearchBaseKeys for " + String.valueOf(ldapName) + "; existing: " + String.valueOf(resultRoleSearchBaseKeys));
                    continue;
                }
                Set<LdapName> in = this.resolveNestedRoles(ldapName, ldapConnection, userRoleName, depth, rolesearchEnabled, nameRoleSearchBaseKeys);
                result.addAll(in);
            }
        }
        return result;
    }

    @Override
    public String getType() {
        return "ldap";
    }

    private boolean isValidDn(String dn) {
        if (Strings.isNullOrEmpty((String)dn)) {
            return false;
        }
        try {
            new LdapName(dn);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private String getRoleFromEntry(Connection ldapConnection, LdapName ldapName, String role) {
        if (ldapName == null || Strings.isNullOrEmpty((String)role)) {
            return null;
        }
        if ("dn".equalsIgnoreCase(role)) {
            return ldapName.toString();
        }
        try {
            LdapAttribute roleAttribute;
            LdapEntry roleEntry = LdapHelper.lookup(ldapConnection, ldapName.toString(), this.returnAttributes, this.shouldFollowReferrals);
            if (roleEntry != null && (roleAttribute = roleEntry.getAttribute(role)) != null) {
                return Utils.getSingleStringValue(roleAttribute);
            }
        }
        catch (LdapException e) {
            log.error("Unable to handle role {} because of ", (Object)ldapName, (Object)e);
        }
        return null;
    }

    private static final class Java9CL
    extends ClassLoader {
        public Java9CL() {
        }

        public Java9CL(ClassLoader parent) {
            super(parent);
        }

        public Class loadClass(String name) throws ClassNotFoundException {
            if (!name.equalsIgnoreCase("org.ldaptive.ssl.ThreadLocalTLSSocketFactory")) {
                return super.loadClass(name);
            }
            return clazz;
        }
    }
}

