/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.pipeline;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.messaging.decoder.MessageDecoder;
import org.opensaml.messaging.encoder.MessageEncoder;
import org.opensaml.messaging.handler.MessageHandler;
import org.opensaml.messaging.pipeline.MessagePipeline;

public class BasicMessagePipeline
implements MessagePipeline {
    @Nonnull
    private MessageEncoder encoder;
    @Nonnull
    private MessageDecoder decoder;
    @Nullable
    private MessageHandler outboundPayloadHandler;
    @Nullable
    private MessageHandler outboundTransportHandler;
    @Nullable
    private MessageHandler inboundHandler;

    public BasicMessagePipeline(@Nonnull MessageEncoder newEncoder, @Nonnull MessageDecoder newDecoder) {
        this.encoder = Constraint.isNotNull(newEncoder, "MessageEncoder cannot be null");
        this.decoder = Constraint.isNotNull(newDecoder, "MessageDecoder cannot be null");
    }

    @Override
    @Nonnull
    public MessageEncoder getEncoder() {
        return this.encoder;
    }

    protected void setEncoder(@Nonnull MessageEncoder newEncoder) {
        this.encoder = Constraint.isNotNull(newEncoder, "MessageEncoder cannot be null");
    }

    @Override
    @Nonnull
    public MessageDecoder getDecoder() {
        return this.decoder;
    }

    protected void setDecoder(@Nonnull MessageDecoder newDecoder) {
        this.decoder = Constraint.isNotNull(newDecoder, "MessageDecoder cannot be null");
    }

    @Override
    @Nullable
    public MessageHandler getOutboundPayloadMessageHandler() {
        return this.outboundPayloadHandler;
    }

    public void setOutboundPayloadHandler(@Nullable MessageHandler handler) {
        this.outboundPayloadHandler = handler;
    }

    @Override
    @Nullable
    public MessageHandler getOutboundTransportMessageHandler() {
        return this.outboundTransportHandler;
    }

    public void setOutboundTransportHandler(@Nullable MessageHandler handler) {
        this.outboundTransportHandler = handler;
    }

    @Override
    @Nullable
    public MessageHandler getInboundMessageHandler() {
        return this.inboundHandler;
    }

    public void setInboundHandler(@Nullable MessageHandler handler) {
        this.inboundHandler = handler;
    }
}

