/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.serde;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.fun.SqlLibrary;
import org.apache.calcite.sql.fun.SqlLibraryOperatorTableFactory;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.util.SqlOperatorTables;
import org.apache.calcite.util.JsonBuilder;
import org.opensearch.sql.calcite.CalcitePlanContext;
import org.opensearch.sql.expression.function.PPLBuiltinOperators;
import org.opensearch.sql.opensearch.executor.OpenSearchExecutionEngine;
import org.opensearch.sql.opensearch.storage.serde.ExtendedRelJson;
import org.opensearch.sql.opensearch.storage.serde.RexStandardizer;
import org.opensearch.sql.opensearch.storage.serde.ScriptParameterHelper;

public class RelJsonSerializer {
    private final RelOptCluster cluster;
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final TypeReference<LinkedHashMap<String, Object>> TYPE_REF = new TypeReference<LinkedHashMap<String, Object>>(){};
    private static volatile SqlOperatorTable pplSqlOperatorTable;

    public RelJsonSerializer(RelOptCluster cluster) {
        this.cluster = cluster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static SqlOperatorTable getPplSqlOperatorTable() {
        if (pplSqlOperatorTable != null) return pplSqlOperatorTable;
        Class<RelJsonSerializer> clazz = RelJsonSerializer.class;
        synchronized (RelJsonSerializer.class) {
            if (pplSqlOperatorTable != null) return pplSqlOperatorTable;
            pplSqlOperatorTable = SqlOperatorTables.chain((SqlOperatorTable[])new SqlOperatorTable[]{PPLBuiltinOperators.instance(), SqlStdOperatorTable.instance(), OpenSearchExecutionEngine.OperatorTable.instance(), SqlLibraryOperatorTableFactory.INSTANCE.getOperatorTable(new SqlLibrary[]{SqlLibrary.MYSQL, SqlLibrary.BIG_QUERY, SqlLibrary.SPARK, SqlLibrary.POSTGRESQL})});
            // ** MonitorExit[var0] (shouldn't be in output)
            return pplSqlOperatorTable;
        }
    }

    public String serialize(RexNode rexNode, ScriptParameterHelper parameterHelper) {
        RexNode standardizedRexExpr = RexStandardizer.standardizeRexNodeExpression(rexNode, parameterHelper);
        try {
            JsonBuilder jsonBuilder = new JsonBuilder();
            ExtendedRelJson relJson = ExtendedRelJson.create(jsonBuilder);
            String rexNodeJson = jsonBuilder.toJsonString(relJson.toJson(standardizedRexExpr));
            if (((Boolean)CalcitePlanContext.skipEncoding.get()).booleanValue()) {
                return rexNodeJson;
            }
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            ObjectOutputStream objectOutput = new ObjectOutputStream(output);
            objectOutput.writeObject(rexNodeJson);
            objectOutput.flush();
            return Base64.getEncoder().encodeToString(output.toByteArray());
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to serialize RexNode: " + String.valueOf(standardizedRexExpr), e);
        }
    }

    public RexNode deserialize(String struct) {
        String exprStr = null;
        try {
            ByteArrayInputStream input = new ByteArrayInputStream(Base64.getDecoder().decode(struct));
            ObjectInputStream objectInput = new ObjectInputStream(input);
            exprStr = (String)objectInput.readObject();
            ExtendedRelJson relJson = ExtendedRelJson.create(null);
            relJson = relJson.withInputTranslator(ExtendedRelJson::translateInput).withOperatorTable(RelJsonSerializer.getPplSqlOperatorTable());
            Map exprMap = (Map)mapper.readValue(exprStr, TYPE_REF);
            return relJson.toRex(this.cluster, exprMap);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to deserialize RexNode " + exprStr, e);
        }
    }

    @Generated
    public RelOptCluster getCluster() {
        return this.cluster;
    }

    static {
        mapper.configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
    }
}

