/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.cli.Arity;
import net.sourceforge.plantuml.cli.CliAction;
import net.sourceforge.plantuml.cli.CliFlag;
import net.sourceforge.plantuml.cli.CliParsingException;
import net.sourceforge.plantuml.utils.Peeker;
import net.sourceforge.plantuml.utils.PeekerUtils;

public class CliParsed {
    private final Map<CliFlag, List<Object>> lists = new EnumMap<CliFlag, List<Object>>(CliFlag.class);
    private final Map<CliFlag, Map<String, String>> maps = new EnumMap<CliFlag, Map<String, String>>(CliFlag.class);
    private final List<String> args = new ArrayList<String>();

    public void putValue(CliFlag flag2, Object value) {
        List list = this.lists.computeIfAbsent(flag2, k -> new ArrayList());
        list.add(value);
    }

    private void putMapValue(CliFlag flag2, String key, String value) {
        Map map = this.maps.computeIfAbsent(flag2, k -> new LinkedHashMap());
        map.put(key, value);
    }

    public boolean isTrue(CliFlag flag2) {
        if (this.maps.containsKey((Object)flag2)) {
            return true;
        }
        List<Object> list = this.lists.get((Object)flag2);
        if (list != null && list.size() > 0 && list.get(0) instanceof Boolean) {
            return (Boolean)list.get(0);
        }
        return list != null;
    }

    public String getString(CliFlag flag2) {
        List<Object> list = this.lists.get((Object)flag2);
        if (list != null && list.size() > 0) {
            return (String)list.get(0);
        }
        return flag2.getDefaultValue();
    }

    public Object getObject(CliFlag flag2) {
        List<Object> list = this.lists.get((Object)flag2);
        if (list != null) {
            return list.get(0);
        }
        return flag2.getDefaultValue();
    }

    public Object getFromType(Class<?> clazz) {
        for (List<Object> list : this.lists.values()) {
            Object element;
            if (list.size() != 1 || (element = list.get(0)).getClass() != clazz) continue;
            return element;
        }
        return null;
    }

    public Map<String, String> getMap(CliFlag flag2) {
        Map<String, String> result = this.maps.get((Object)flag2);
        if (result == null) {
            return Collections.emptyMap();
        }
        return result;
    }

    public List<Object> getList(CliFlag flag2) {
        List<Object> result = this.lists.get((Object)flag2);
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    public Map<String, String> getMap(CliFlag mapFlag, CliFlag listFlag) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(this.getMap(mapFlag));
        for (Object s : this.getList(listFlag)) {
            String[] keyValue = s.toString().split("=");
            if (keyValue.length == 1) {
                result.put(keyValue[0], null);
                continue;
            }
            if (keyValue.length != 2) continue;
            result.put(keyValue[0], keyValue[1]);
        }
        return Collections.unmodifiableMap(result);
    }

    public String toString() {
        EnumMap<CliFlag, Object> merge = new EnumMap<CliFlag, Object>(CliFlag.class);
        merge.putAll(this.lists);
        merge.putAll(this.maps);
        return ((Object)merge).toString();
    }

    public CliAction getImmediateAction() {
        for (Map.Entry<CliFlag, List<Object>> entry : this.lists.entrySet()) {
            Object data;
            if (entry.getKey().getType() != Arity.UNARY_IMMEDIATE_ACTION || entry.getValue().size() != 1 || !((data = entry.getValue().get(0)) instanceof CliAction)) continue;
            return (CliAction)data;
        }
        return null;
    }

    public void triggerNonImmediateCliAction() {
        for (Map.Entry<CliFlag, List<Object>> entry : this.lists.entrySet()) {
            Object data;
            if (entry.getKey().getType() == Arity.UNARY_IMMEDIATE_ACTION || entry.getValue().size() != 1 || !((data = entry.getValue().get(0)) instanceof CliAction)) continue;
            ((CliAction)data).runAction();
        }
    }

    public static CliParsed parse(String ... args) throws CliParsingException {
        CliParsed result = new CliParsed();
        Peeker<String> peeker = PeekerUtils.peeker(Arrays.asList(args));
        while (peeker.peek(0) != null) {
            String peek0 = peeker.peek(0);
            boolean found = false;
            block8: for (CliFlag flag2 : CliFlag.values()) {
                if (found || !flag2.match(peek0)) continue;
                found = true;
                switch (flag2.getType()) {
                    case UNARY_BOOLEAN: {
                        Object foo = flag2.getFoo();
                        result.putValue(flag2, foo == null ? Boolean.TRUE : foo);
                        continue block8;
                    }
                    case UNARY_IMMEDIATE_ACTION: {
                        result.putValue(flag2, flag2.getFoo());
                        continue block8;
                    }
                    case BINARY_NEXT_ARGUMENT_VALUE: {
                        peeker.jump();
                        result.putValue(flag2, peeker.peek(0));
                        continue block8;
                    }
                    case UNARY_INLINE_KEY_OR_KEY_VALUE: {
                        String s = peeker.peek(0).substring(2);
                        if (s.length() == 0) {
                            peeker.jump();
                            s = peeker.peek(0);
                        }
                        if (s == null) {
                            throw new CliParsingException(flag2, "missing value");
                        }
                        int eqIndex = s.indexOf(61);
                        String k = eqIndex < 0 ? s : s.substring(0, eqIndex);
                        String v = eqIndex < 0 ? null : s.substring(eqIndex + 1);
                        result.putMapValue(flag2, k, v);
                        continue block8;
                    }
                    case UNARY_OPTIONAL_COLON: {
                        int colon = peek0.indexOf(58);
                        if (colon == -1) {
                            result.lists.computeIfAbsent(flag2, k1 -> new ArrayList());
                            continue block8;
                        }
                        for (String part : peek0.substring(colon + 1).split(":")) {
                            result.putValue(flag2, part);
                        }
                        continue block8;
                    }
                }
            }
            if (!found) {
                result.args.add(peek0);
            }
            peeker.jump();
        }
        return result;
    }

    public List<String> getRemainingArgs() {
        return Collections.unmodifiableList(this.args);
    }
}

