/*
 * Decompiled with CFR 0.152.
 */
package net.n3.nanoxml;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.Deque;
import net.n3.nanoxml.IXMLBuilder;
import net.n3.nanoxml.IXMLElement;
import net.n3.nanoxml.XMLElement;
import net.n3.nanoxml.XMLParseException;

public final class StdXMLBuilder
implements IXMLBuilder {
    private final IXMLElement prototype;
    private Deque<IXMLElement> stack;
    private IXMLElement root;

    public StdXMLBuilder() {
        this(new XMLElement());
    }

    public StdXMLBuilder(IXMLElement prototype) {
        this.prototype = prototype;
    }

    @Override
    public void startBuilding(String systemID, int lineNr) {
        this.stack = new ArrayDeque<IXMLElement>();
    }

    @Override
    public void newProcessingInstruction(String target, Reader reader) {
    }

    @Override
    public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) {
        Object fullName = name;
        if (nsPrefix != null) {
            fullName = nsPrefix + ":" + name;
        }
        IXMLElement elt = this.prototype.createElement((String)fullName, nsURI, systemID, lineNr);
        if (this.stack.isEmpty()) {
            this.root = elt;
        } else {
            IXMLElement top = this.stack.peek();
            top.addChild(elt);
        }
        this.stack.push(elt);
    }

    @Override
    public void elementAttributesProcessed(String name, String nsPrefix, String nsURI) {
    }

    @Override
    public void endElement(String name, String nsPrefix, String nsURI) {
        IXMLElement child;
        IXMLElement elt = this.stack.pop();
        if (elt.getChildrenCount() == 1 && (child = elt.getChildAtIndex(0)).getName() == null) {
            elt.setContent(child.getContent());
            elt.removeChildAtIndex(0);
        }
    }

    @Override
    public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) throws Exception {
        IXMLElement top;
        Object fullName = key;
        if (nsPrefix != null) {
            fullName = nsPrefix + ":" + key;
        }
        if ((top = this.stack.peek()).hasAttribute((String)fullName)) {
            throw new XMLParseException(top.getSystemID(), top.getLineNr(), "Duplicate attribute: " + key);
        }
        if (nsPrefix != null) {
            top.setAttribute((String)fullName, nsURI, value);
        } else {
            top.setAttribute((String)fullName, value);
        }
    }

    @Override
    public void addPCData(Reader reader, String systemID, int lineNr) {
        int bufSize = 2048;
        int sizeRead = 0;
        StringBuilder str = new StringBuilder(bufSize);
        char[] buf = new char[bufSize];
        while (true) {
            int size;
            if (sizeRead >= bufSize) {
                str.ensureCapacity(bufSize *= 2);
            }
            try {
                size = reader.read(buf);
            }
            catch (IOException e) {
                break;
            }
            if (size < 0) break;
            str.append(buf, 0, size);
            sizeRead += size;
        }
        IXMLElement elt = this.prototype.createElement(null, systemID, lineNr);
        elt.setContent(str.toString());
        if (!this.stack.isEmpty()) {
            IXMLElement top = this.stack.peek();
            top.addChild(elt);
        }
    }

    @Override
    public Object getResult() {
        return this.root;
    }
}

