/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.ide.plugins.CannotUnloadPluginException;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.impl.MessageBusImpl;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/util/messages/impl/DynamicPluginUnloaderCompatibilityLayer;", "", "<init>", "()V", "queryPluginUnloadVetoers", "", "Lorg/jetbrains/annotations/Nls;", "pluginDescriptor", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "messageBus", "Lcom/intellij/util/messages/MessageBus;", "intellij.platform.core"})
@ApiStatus.Internal
public final class DynamicPluginUnloaderCompatibilityLayer {
    @NotNull
    public static final DynamicPluginUnloaderCompatibilityLayer INSTANCE = new DynamicPluginUnloaderCompatibilityLayer();

    private DynamicPluginUnloaderCompatibilityLayer() {
    }

    @Nullable
    public final String queryPluginUnloadVetoers(@NotNull IdeaPluginDescriptor pluginDescriptor, @NotNull MessageBus messageBus) {
        Intrinsics.checkNotNullParameter(pluginDescriptor, "pluginDescriptor");
        Intrinsics.checkNotNullParameter(messageBus, "messageBus");
        try {
            if (!(messageBus instanceof MessageBusImpl)) {
                return null;
            }
            for (Object subscriber : ((MessageBusImpl)messageBus).computeSubscribers$intellij_platform_core(DynamicPluginListener.TOPIC)) {
                if (!(subscriber instanceof DynamicPluginListener)) continue;
                ((DynamicPluginListener)subscriber).checkUnloadPlugin(pluginDescriptor);
            }
            return null;
        }
        catch (CannotUnloadPluginException e) {
            Object object = e.getCause();
            if (object == null || (object = ((Throwable)object).getLocalizedMessage()) == null) {
                object = "checkUnloadPlugin listener blocked plugin unload";
            }
            return object;
        }
        catch (CancellationException cancellationException) {
            return null;
        }
        catch (Throwable e) {
            Logger.getInstance(DynamicPluginListener.class).error(e);
            return null;
        }
    }
}

