/**
 * Copyright (c) 2011-2013 by Andrew Mustun. All rights reserved.
 * 
 * This file is part of the QCAD project.
 *
 * QCAD is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * QCAD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with QCAD.
 */
// Auto generated by Testing Dashboard
// File        : scripts/Modify/Rotate2/Tests/Rotate2Test06.js
// Timestamp   : 2011-08-08 15:26:34
// Description : Rotate 2 using a text

include('scripts/Developer/TestingDashboard/TdbTest.js');

function Rotate2Test06() {
    TdbTest.call(this, 'scripts/Modify/Rotate2/Tests/Rotate2Test06.js');
}

Rotate2Test06.prototype = new TdbTest();

Rotate2Test06.prototype.test00 = function() {
    qDebug('running Rotate2Test06.test00()...');
    this.setUp();
    var w = objectFromPath('MainWindow::CadToolBar::MainToolsPanel');
    this.sendMouseEvent(w, QEvent.MouseButtonPress, new QPoint(60, 419), Qt.LeftButton, 1, 0);
    var w = objectFromPath('MainWindow::CadToolBar::MainToolsPanel');
    this.sendMouseEvent(w, QEvent.MouseButtonRelease, new QPoint(60, 419), Qt.LeftButton, 0, 0);
    this.importFile('scripts/Modify/Rotate2/Tests/data/text.dxf');
    var p = new RVector(9.56801, -0.576721);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.MidButton, 4, 0);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.MidButton, 0, 0);
    this.setZoom(11.042070266194617, new RVector(8.09172, 33.1793, 0) );
    var p = new RVector(0.511737, -1.482349);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    this.setZoom(11.042070266194617, new RVector(8.09172, 33.1793, 0) );
    var p = new RVector(0.421174, -0.84841);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    this.triggerCommand('rotate2');
    this.setToolOption('TranslateRotate/PrimaryAngle',  [ 30, 0 ] );
    this.setToolOption('TranslateRotate/SecondaryAngle',  [ -30, 0 ] );
    this.setToolOption('TranslateRotate/NumberOfCopies',  [ 11, 0 ] );
    this.updateToolOptions();
    this.setZoom(11.042070266194617, new RVector(8.09172, 33.1793, 0) );
    var p = new RVector(-0.212765, -0.033345);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    var p = new RVector(-5.918217, 2.502411);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.MidButton, 4, 0);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.MidButton, 0, 0);
    this.setZoom(11.042070266194617, new RVector(14.0689, 25.9343, 0) );
    var p = new RVector(-9.99354, 9.656867);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    this.dlgStart();
    this.dlgAppendCode('var map = new MapCompat()');
    this.dlgAppendCode("map.put('DialogOpenedByTdb/groupBox', 'MultipleCopies')");
    this.dlgAppendCode("map.put('DialogOpenedByTdb/NumberOfCopies',  [ 11, 0 ] )");
    this.dlgAppendCode("map.put('DialogOpenedByTdb/PrimaryAngle',  [ 30, 0 ] )");
    this.dlgAppendCode("map.put('DialogOpenedByTdb/SecondaryAngle',  [ -30, 0 ] )");
    this.dlgAppendCode("map.put('DialogOpenedByTdb/UseCurrentAttributes', false)");
    this.dlgAppendCode("WidgetFactory.restoreState(dialog, 'DialogOpenedByTdb', undefined, false, undefined, map)");
    this.dlgEnd();
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    this.verifyDrawing('Rotate2Test06_000.dxf');
    this.tearDown();
    qDebug('finished Rotate2Test06.test00()');
};

