/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.foreign;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.foreign.ForeignNumberBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.foreign.ForeignNumberBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.foreign.ForeignObjectBuiltins;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.object.ObjectBuiltins;
import com.oracle.graal.python.builtins.objects.object.ObjectNodes;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryOp;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotGetAttr;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotInquiry;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotRichCompare;
import com.oracle.graal.python.lib.PyNumberAbsoluteNode;
import com.oracle.graal.python.lib.PyNumberAddNode;
import com.oracle.graal.python.lib.PyNumberAndNode;
import com.oracle.graal.python.lib.PyNumberDivmodNode;
import com.oracle.graal.python.lib.PyNumberFloatNode;
import com.oracle.graal.python.lib.PyNumberFloorDivideNode;
import com.oracle.graal.python.lib.PyNumberInvertNode;
import com.oracle.graal.python.lib.PyNumberLongNode;
import com.oracle.graal.python.lib.PyNumberLshiftNode;
import com.oracle.graal.python.lib.PyNumberMultiplyNode;
import com.oracle.graal.python.lib.PyNumberNegativeNode;
import com.oracle.graal.python.lib.PyNumberOrNode;
import com.oracle.graal.python.lib.PyNumberPositiveNode;
import com.oracle.graal.python.lib.PyNumberPowerNode;
import com.oracle.graal.python.lib.PyNumberRemainderNode;
import com.oracle.graal.python.lib.PyNumberRshiftNode;
import com.oracle.graal.python.lib.PyNumberSubtractNode;
import com.oracle.graal.python.lib.PyNumberTrueDivideNode;
import com.oracle.graal.python.lib.PyNumberXorNode;
import com.oracle.graal.python.lib.PyObjectRichCompare;
import com.oracle.graal.python.lib.PyObjectStrAsTruffleStringNode;
import com.oracle.graal.python.lib.RichCmpOp;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.call.special.LookupAndCallBinaryNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallUnaryNode;
import com.oracle.graal.python.nodes.call.special.SpecialMethodNotFound;
import com.oracle.graal.python.nodes.expression.BinaryOpNode;
import com.oracle.graal.python.nodes.expression.UnaryOpNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.IsForeignObjectNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.math.BigInteger;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.ForeignNumber})
public final class ForeignNumberBuiltins
extends PythonBuiltins {
    public static TpSlots SLOTS = ForeignNumberBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ForeignNumberBuiltinsFactory.getFactories();
    }

    @Slot(value=Slot.SlotKind.tp_getattro, isComplex=true)
    @GenerateNodeFactory
    static abstract class GetAttributeNode
    extends TpSlotGetAttr.GetAttrBuiltinNode {
        GetAttributeNode() {
        }

        @Specialization
        static Object doIt(VirtualFrame frame, Object self, Object name, @Bind Node inliningTarget, @Cached UnboxNode unboxNode, @Cached ObjectBuiltins.GetAttributeNode objectGetattrNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isAttrError, @Cached ForeignObjectBuiltins.ForeignGetattrNode foreignGetattrNode) {
            Object unboxed = unboxNode.execute(inliningTarget, self);
            if (unboxed != null) {
                try {
                    return objectGetattrNode.execute(frame, unboxed, name);
                }
                catch (PException e) {
                    e.expect(inliningTarget, PythonBuiltinClassType.AttributeError, isAttrError);
                }
            }
            return foreignGetattrNode.execute(inliningTarget, self, name);
        }
    }

    @Slot(value=Slot.SlotKind.tp_repr, isComplex=true)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends StrNode {
        @Node.Child
        private ObjectNodes.DefaultObjectReprNode defaultReprNode;

        ReprNode() {
        }

        @Override
        protected TruffleString defaultConversion(VirtualFrame frame, InteropLibrary lib, Object object) {
            try {
                if (this.getContext().getEnv().isHostObject(object)) {
                    boolean isMetaObject = lib.isMetaObject(object);
                    Object metaObject = null;
                    if (isMetaObject) {
                        metaObject = object;
                    } else if (lib.hasMetaObject(object)) {
                        metaObject = lib.getMetaObject(object);
                    }
                    if (metaObject != null) {
                        TruffleString displayName = this.getSwitchEncodingNode().execute((AbstractTruffleString)lib.asTruffleString(lib.toDisplayString(metaObject)), PythonUtils.TS_ENCODING);
                        return StringUtils.simpleTruffleStringFormatUncached("<%s[%s] at 0x%s>", isMetaObject ? "JavaClass" : "JavaObject", displayName, PythonAbstractObject.systemHashCodeAsHexString(object));
                    }
                }
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            if (this.defaultReprNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.defaultReprNode = (ObjectNodes.DefaultObjectReprNode)this.insert(ObjectNodes.DefaultObjectReprNode.create());
            }
            return this.defaultReprNode.executeCached((Frame)frame, object);
        }
    }

    @Slot(value=Slot.SlotKind.tp_str, isComplex=true)
    @GenerateNodeFactory
    static abstract class StrNode
    extends PythonUnaryBuiltinNode {
        @Node.Child
        private TruffleString.SwitchEncodingNode switchEncodingNode;

        StrNode() {
        }

        @Specialization
        Object str(VirtualFrame frame, Object object, @Bind Node inliningTarget, @Cached UnboxNode unboxNode, @CachedLibrary(limit="3") InteropLibrary lib, @Cached PyObjectStrAsTruffleStringNode strNode, @Cached InlinedBranchProfile defaultCase) {
            Object value = unboxNode.execute(inliningTarget, object);
            if (value == null) {
                defaultCase.enter(inliningTarget);
                return this.defaultConversion(frame, lib, object);
            }
            return strNode.execute((Frame)frame, inliningTarget, value);
        }

        protected TruffleString.SwitchEncodingNode getSwitchEncodingNode() {
            if (this.switchEncodingNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.switchEncodingNode = (TruffleString.SwitchEncodingNode)this.insert((Node)TruffleString.SwitchEncodingNode.create());
            }
            return this.switchEncodingNode;
        }

        protected TruffleString defaultConversion(VirtualFrame frame, InteropLibrary lib, Object object) {
            try {
                return this.getSwitchEncodingNode().execute((AbstractTruffleString)lib.asTruffleString(lib.toDisplayString(object)), PythonUtils.TS_ENCODING);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((String)"toDisplayString result not convertible to String");
            }
        }
    }

    @Slot(value=Slot.SlotKind.nb_index, isComplex=true)
    @GenerateNodeFactory
    static abstract class IndexNode
    extends PythonUnaryBuiltinNode {
        IndexNode() {
        }

        @Specialization(limit="3")
        protected static Object doIt(Object object, @Bind Node inliningTarget, @Cached PRaiseNode raiseNode, @CachedLibrary(value="object") InteropLibrary lib, @Cached GilNode gil) {
            block15: {
                assert (!lib.isBoolean(object));
                gil.release(true);
                if (lib.fitsInInt(object)) {
                    try {
                        Integer n = lib.asInt(object);
                        return n;
                    }
                    catch (UnsupportedMessageException e) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        throw new IllegalStateException("foreign value claims it fits into index-sized int, but doesn't");
                    }
                }
                if (!lib.fitsInLong(object)) break block15;
                try {
                    Long e = lib.asLong(object);
                    return e;
                }
                catch (UnsupportedMessageException e) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw new IllegalStateException("foreign value claims it fits into index-sized long, but doesn't");
                }
            }
            if (lib.fitsInBigInteger(object)) {
                try {
                    BigInteger big = lib.asBigInteger(object);
                    PInt pInt = PFactory.createInt(PythonLanguage.get(inliningTarget), big);
                    return pInt;
                }
                catch (UnsupportedMessageException e) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw new IllegalStateException("foreign value claims to be a big integer but isn't");
                }
            }
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_CANNOT_BE_INTERPRETED_AS_INTEGER, object);
            finally {
                gil.acquire();
            }
        }
    }

    @Slot(value=Slot.SlotKind.tp_richcompare, isComplex=true)
    @GenerateNodeFactory
    public static abstract class ForeignBinaryComparisonNode
    extends TpSlotRichCompare.RichCmpBuiltinNode {
        @Specialization
        Object doComparison(VirtualFrame frame, Object left, Object right, RichCmpOp op, @Bind Node inliningTarget, @Cached UnboxNode unboxNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile exProfile, @Cached PyObjectRichCompare richCompareNode) {
            Object unboxed = unboxNode.execute(inliningTarget, left);
            if (unboxed != null) {
                try {
                    return richCompareNode.execute(frame, inliningTarget, unboxed, right, op);
                }
                catch (PException ex) {
                    ex.expect(inliningTarget, PythonBuiltinClassType.TypeError, exProfile);
                }
            }
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__round__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class RoundNode
    extends PythonBinaryBuiltinNode {
        RoundNode() {
        }

        @Specialization
        Object doGeneric(VirtualFrame frame, Object self, Object n, @Bind Node inliningTarget, @Cached UnboxNode unboxNode, @Cached(value="create(T___ROUND__)") LookupAndCallBinaryNode callRound) {
            Object unboxed = unboxNode.execute(inliningTarget, self);
            try {
                return callRound.executeObject(frame, unboxed, n);
            }
            catch (SpecialMethodNotFound ignore) {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }
    }

    @Slot(value=Slot.SlotKind.nb_power, isComplex=true)
    @GenerateNodeFactory
    static abstract class PowNode
    extends PythonTernaryBuiltinNode {
        PowNode() {
        }

        @Specialization
        static Object doIt(VirtualFrame frame, Object v, Object w, Object z, @Bind Node inliningTarget, @Cached UnboxNode unboxV, @Cached UnboxNode unboxW, @Cached UnboxNode unboxZ, @Cached PyNumberPowerNode power) {
            v = unboxV.execute(inliningTarget, v);
            w = unboxW.execute(inliningTarget, w);
            if (!(z instanceof PNone)) {
                z = unboxZ.execute(inliningTarget, z);
            }
            if (v == null || w == null || z == null) {
                return PNotImplemented.NOT_IMPLEMENTED;
            }
            return power.execute(frame, v, w, z);
        }
    }

    @Slot(value=Slot.SlotKind.nb_divmod, isComplex=true)
    @GenerateNodeFactory
    static abstract class DivModNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        DivModNode() {
        }

        @Specialization
        static Object doIt(VirtualFrame frame, Object left, Object right, @Bind Node inliningTarget, @Cached ForeignBinarySlotNode binarySlotNode, @Cached PyNumberDivmodNode opNode) {
            return binarySlotNode.execute(frame, inliningTarget, left, right, opNode);
        }
    }

    @Slot(value=Slot.SlotKind.nb_true_divide, isComplex=true)
    @GenerateNodeFactory
    static abstract class TrueDivNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        TrueDivNode() {
        }

        @Specialization
        static Object doIt(VirtualFrame frame, Object left, Object right, @Bind Node inliningTarget, @Cached ForeignBinarySlotNode binarySlotNode, @Cached PyNumberTrueDivideNode opNode) {
            return binarySlotNode.execute(frame, inliningTarget, left, right, opNode);
        }
    }

    @Slot(value=Slot.SlotKind.nb_floor_divide, isComplex=true)
    @GenerateNodeFactory
    static abstract class FloorDivNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        FloorDivNode() {
        }

        @Specialization
        static Object doIt(VirtualFrame frame, Object left, Object right, @Bind Node inliningTarget, @Cached ForeignBinarySlotNode binarySlotNode, @Cached PyNumberFloorDivideNode opNode) {
            return binarySlotNode.execute(frame, inliningTarget, left, right, opNode);
        }
    }

    @Slot(value=Slot.SlotKind.nb_or, isComplex=true)
    @GenerateNodeFactory
    static abstract class OrNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        OrNode() {
        }

        @Specialization
        static Object doIt(VirtualFrame frame, Object left, Object right, @Bind Node inliningTarget, @Cached ForeignBinarySlotNode binarySlotNode, @Cached PyNumberOrNode opNode) {
            return binarySlotNode.execute(frame, inliningTarget, left, right, opNode);
        }
    }

    @Slot(value=Slot.SlotKind.nb_xor, isComplex=true)
    @GenerateNodeFactory
    static abstract class XorNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        XorNode() {
        }

        @Specialization
        static Object doIt(VirtualFrame frame, Object left, Object right, @Bind Node inliningTarget, @Cached ForeignBinarySlotNode binarySlotNode, @Cached PyNumberXorNode opNode) {
            return binarySlotNode.execute(frame, inliningTarget, left, right, opNode);
        }
    }

    @Slot(value=Slot.SlotKind.nb_and, isComplex=true)
    @GenerateNodeFactory
    static abstract class AndNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        AndNode() {
        }

        @Specialization
        static Object doIt(VirtualFrame frame, Object left, Object right, @Bind Node inliningTarget, @Cached ForeignBinarySlotNode binarySlotNode, @Cached PyNumberAndNode opNode) {
            return binarySlotNode.execute(frame, inliningTarget, left, right, opNode);
        }
    }

    @Slot(value=Slot.SlotKind.nb_rshift, isComplex=true)
    @GenerateNodeFactory
    static abstract class RShiftNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        RShiftNode() {
        }

        @Specialization
        static Object doIt(VirtualFrame frame, Object left, Object right, @Bind Node inliningTarget, @Cached ForeignBinarySlotNode binarySlotNode, @Cached PyNumberRshiftNode opNode) {
            return binarySlotNode.execute(frame, inliningTarget, left, right, opNode);
        }
    }

    @Slot(value=Slot.SlotKind.nb_lshift, isComplex=true)
    @GenerateNodeFactory
    static abstract class LShiftNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        LShiftNode() {
        }

        @Specialization
        static Object doIt(VirtualFrame frame, Object left, Object right, @Bind Node inliningTarget, @Cached ForeignBinarySlotNode binarySlotNode, @Cached PyNumberLshiftNode opNode) {
            return binarySlotNode.execute(frame, inliningTarget, left, right, opNode);
        }
    }

    @Slot(value=Slot.SlotKind.nb_remainder, isComplex=true)
    @GenerateNodeFactory
    static abstract class ModNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        ModNode() {
        }

        @Specialization
        static Object doIt(VirtualFrame frame, Object left, Object right, @Bind Node inliningTarget, @Cached ForeignBinarySlotNode binarySlotNode, @Cached PyNumberRemainderNode opNode) {
            return binarySlotNode.execute(frame, inliningTarget, left, right, opNode);
        }
    }

    @Slot(value=Slot.SlotKind.nb_multiply, isComplex=true)
    @GenerateNodeFactory
    static abstract class MulNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        MulNode() {
        }

        @Specialization
        static Object doIt(VirtualFrame frame, Object left, Object right, @Bind Node inliningTarget, @Cached ForeignBinarySlotNode binarySlotNode, @Cached PyNumberMultiplyNode opNode) {
            return binarySlotNode.execute(frame, inliningTarget, left, right, opNode);
        }
    }

    @Slot(value=Slot.SlotKind.nb_subtract, isComplex=true)
    @GenerateNodeFactory
    static abstract class SubNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        SubNode() {
        }

        @Specialization
        static Object doIt(VirtualFrame frame, Object left, Object right, @Bind Node inliningTarget, @Cached ForeignBinarySlotNode binarySlotNode, @Cached PyNumberSubtractNode opNode) {
            return binarySlotNode.execute(frame, inliningTarget, left, right, opNode);
        }
    }

    @Slot(value=Slot.SlotKind.nb_add, isComplex=true)
    @GenerateNodeFactory
    static abstract class AddNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        AddNode() {
        }

        @Specialization
        static Object doIt(VirtualFrame frame, Object left, Object right, @Bind Node inliningTarget, @Cached ForeignBinarySlotNode binarySlotNode, @Cached PyNumberAddNode opNode) {
            return binarySlotNode.execute(frame, inliningTarget, left, right, opNode);
        }
    }

    @Slot(value=Slot.SlotKind.nb_float, isComplex=true)
    @GenerateNodeFactory
    static abstract class FloatNode
    extends PythonUnaryBuiltinNode {
        FloatNode() {
        }

        @Specialization
        Object doGeneric(VirtualFrame frame, Object self, @Bind Node inliningTarget, @Cached UnboxNode unboxNode, @Cached PyNumberFloatNode floatNode) {
            Object unboxed = unboxNode.execute(inliningTarget, self);
            return floatNode.execute((Frame)frame, inliningTarget, unboxed);
        }
    }

    @Slot(value=Slot.SlotKind.nb_int, isComplex=true)
    @GenerateNodeFactory
    static abstract class IntNode
    extends PythonUnaryBuiltinNode {
        IntNode() {
        }

        @Specialization
        Object doGeneric(VirtualFrame frame, Object self, @Bind Node inliningTarget, @Cached UnboxNode unboxNode, @Cached PyNumberLongNode longNode) {
            Object unboxed = unboxNode.execute(inliningTarget, self);
            return longNode.execute((Frame)frame, inliningTarget, unboxed);
        }
    }

    @Builtin(name="__trunc__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class TruncNode
    extends ForeignUnaryNode {
        TruncNode() {
            super(LookupAndCallUnaryNode.create(SpecialMethodNames.T___TRUNC__));
        }
    }

    @Builtin(name="__floor__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class FloorNode
    extends ForeignUnaryNode {
        FloorNode() {
            super(LookupAndCallUnaryNode.create(SpecialMethodNames.T___FLOOR__));
        }
    }

    @Builtin(name="__ceil__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class CeilNode
    extends ForeignUnaryNode {
        CeilNode() {
            super(LookupAndCallUnaryNode.create(SpecialMethodNames.T___CEIL__));
        }
    }

    @Slot(value=Slot.SlotKind.nb_absolute, isComplex=true)
    @GenerateNodeFactory
    static abstract class AbsNode
    extends ForeignUnaryNode {
        AbsNode() {
            super(PyNumberAbsoluteNode.create());
        }
    }

    @Slot(value=Slot.SlotKind.nb_invert, isComplex=true)
    @GenerateNodeFactory
    static abstract class InvertNode
    extends ForeignUnaryNode {
        InvertNode() {
            super(PyNumberInvertNode.create());
        }
    }

    @Slot(value=Slot.SlotKind.nb_negative, isComplex=true)
    @GenerateNodeFactory
    static abstract class NegNode
    extends ForeignUnaryNode {
        NegNode() {
            super(PyNumberNegativeNode.create());
        }
    }

    @Slot(value=Slot.SlotKind.nb_positive, isComplex=true)
    @GenerateNodeFactory
    static abstract class PosNode
    extends ForeignUnaryNode {
        PosNode() {
            super(PyNumberPositiveNode.create());
        }
    }

    @Slot(value=Slot.SlotKind.nb_bool)
    @GenerateUncached
    @GenerateNodeFactory
    static abstract class BoolNode
    extends TpSlotInquiry.NbBoolBuiltinNode {
        BoolNode() {
        }

        @Specialization(limit="getCallSiteInlineCacheMaxDepth()")
        static boolean bool(Object receiver, @CachedLibrary(value="receiver") InteropLibrary lib, @Cached GilNode gil) {
            assert (!lib.isBoolean(receiver));
            gil.release(true);
            try {
                if (lib.fitsInLong(receiver)) {
                    boolean bl = lib.asLong(receiver) != 0L;
                    return bl;
                }
                if (lib.fitsInBigInteger(receiver)) {
                    boolean bl = lib.asBigInteger(receiver).signum() != 0;
                    return bl;
                }
                if (lib.fitsInDouble(receiver)) {
                    boolean bl = lib.asDouble(receiver) != 0.0;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
            finally {
                gil.acquire();
            }
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class ForeignBinarySlotNode
    extends Node {
        ForeignBinarySlotNode() {
        }

        abstract Object execute(VirtualFrame var1, Node var2, Object var3, Object var4, BinaryOpNode var5);

        @Specialization
        static Object doIt(VirtualFrame frame, Node inliningTarget, Object left, Object right, BinaryOpNode op, @Cached IsForeignObjectNode isForeignLeft, @Cached IsForeignObjectNode isForeignRight, @Cached UnboxNode unboxLeft, @Cached UnboxNode unboxRight) {
            boolean leftIsForeign = isForeignLeft.execute(inliningTarget, left);
            boolean rightIsForeign = isForeignRight.execute(inliningTarget, right);
            if (!leftIsForeign && !rightIsForeign) {
                return PNotImplemented.NOT_IMPLEMENTED;
            }
            Object newLeft = unboxLeft.execute(inliningTarget, left);
            Object newRight = unboxRight.execute(inliningTarget, right);
            if (newLeft == null || newRight == null) {
                return PNotImplemented.NOT_IMPLEMENTED;
            }
            return op.execute(frame, newLeft, newRight);
        }
    }

    static abstract class ForeignBinaryNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        @Node.Child
        private BinaryOpNode op;
        protected final boolean reverse;

        protected ForeignBinaryNode(BinaryOpNode op, boolean reverse) {
            this.op = op;
            this.reverse = reverse;
        }

        @Specialization
        Object doGeneric(VirtualFrame frame, Object left, Object right, @Bind Node inliningTarget, @Cached UnboxNode unboxNode) {
            Object unboxed = unboxNode.execute(inliningTarget, left);
            if (unboxed != null) {
                if (!this.reverse) {
                    return this.op.execute(frame, unboxed, right);
                }
                return this.op.execute(frame, right, unboxed);
            }
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    static abstract class ForeignUnaryNode
    extends PythonUnaryBuiltinNode {
        @Node.Child
        private UnaryOpNode op;

        protected ForeignUnaryNode(UnaryOpNode op) {
            this.op = op;
        }

        @Specialization
        Object doGeneric(VirtualFrame frame, Object value, @Bind Node inliningTarget, @Cached UnboxNode unboxNode) {
            Object unboxed = unboxNode.execute(inliningTarget, value);
            assert (unboxed != null);
            return this.op.execute(frame, unboxed);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class UnboxNode
    extends Node {
        UnboxNode() {
        }

        public final Object execute(Node inliningTarget, Object value) {
            Object unboxed = this.executeInternal(inliningTarget, value);
            assert (unboxed == null || !IsForeignObjectNode.executeUncached(unboxed)) : unboxed;
            return unboxed;
        }

        protected abstract Object executeInternal(Node var1, Object var2);

        @Specialization
        static boolean unbox(boolean value) {
            return value;
        }

        @Specialization
        static int unbox(int value) {
            return value;
        }

        @Specialization
        static long unbox(long value) {
            return value;
        }

        @Specialization
        static PInt unbox(PInt value) {
            return value;
        }

        @Specialization
        static double unbox(double value) {
            return value;
        }

        @Fallback
        static Object unbox(Node inliningTarget, Object value, @Cached IsForeignObjectNode isForeignObjectNode, @Cached UnboxForeignObjectNode unboxForeignObjectNode) {
            if (isForeignObjectNode.execute(inliningTarget, value)) {
                return unboxForeignObjectNode.execute(inliningTarget, value);
            }
            return null;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class UnboxForeignObjectNode
    extends Node {
        UnboxForeignObjectNode() {
        }

        public abstract Object execute(Node var1, Object var2);

        @Specialization(guards={"lib.isBoolean(obj)"})
        boolean doBool(Object obj, @Cached.Shared @CachedLibrary(limit="3") InteropLibrary lib, @Cached.Shared @Cached(inline=false) GilNode gil) {
            gil.release(true);
            try {
                boolean bl = lib.asBoolean(obj);
                return bl;
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
            finally {
                gil.acquire();
            }
        }

        @Specialization(guards={"lib.fitsInLong(obj)"})
        long doLong(Object obj, @Cached.Shared @CachedLibrary(limit="3") InteropLibrary lib, @Cached.Shared @Cached(inline=false) GilNode gil) {
            assert (!lib.isBoolean(obj));
            gil.release(true);
            try {
                long l = lib.asLong(obj);
                return l;
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
            finally {
                gil.acquire();
            }
        }

        @Specialization(guards={"!lib.fitsInLong(obj)", "lib.fitsInBigInteger(obj)"})
        PInt doBigInt(Object obj, @Bind PythonLanguage language, @Cached.Shared @CachedLibrary(limit="3") InteropLibrary lib, @Cached.Shared @Cached(inline=false) GilNode gil) {
            assert (!lib.isBoolean(obj));
            gil.release(true);
            try {
                PInt pInt = PFactory.createInt(language, lib.asBigInteger(obj));
                return pInt;
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
            finally {
                gil.acquire();
            }
        }

        @Specialization(guards={"!lib.fitsInLong(obj)", "!lib.fitsInBigInteger(obj)", "lib.fitsInDouble(obj)"})
        double doDouble(Object obj, @Cached.Shared @CachedLibrary(limit="3") InteropLibrary lib, @Cached.Shared @Cached(inline=false) GilNode gil) {
            assert (!lib.isBoolean(obj));
            gil.release(true);
            try {
                double d = lib.asDouble(obj);
                return d;
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
            finally {
                gil.acquire();
            }
        }

        @Fallback
        public static Object doGeneric(Object left) {
            return null;
        }
    }
}

