/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable.commandline;

import java.util.Objects;
import java.util.StringJoiner;

public class PluginCommandOption {
    private final String[] helpText;
    private final String name;
    private final Class<?> valueClass;

    PluginCommandOption(String name, Class<?> valueClass, String ... helpText) {
        this.name = Objects.requireNonNull(name, "No option name provided");
        this.helpText = helpText == null ? new String[0] : helpText;
        this.valueClass = valueClass == null ? String.class : valueClass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PluginCommandOption)) {
            return false;
        }
        PluginCommandOption that = (PluginCommandOption)o;
        return Objects.equals(this.getName(), that.getName());
    }

    public String[] getHelpText() {
        return this.helpText;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getValueClass() {
        return this.valueClass;
    }

    public int hashCode() {
        return Objects.hash(this.getName());
    }

    public String toString() {
        return new StringJoiner(", ", PluginCommandOption.class.getSimpleName() + "[", "]").add("name='" + this.name + "'").add("valueClass=" + this.valueClass.getCanonicalName()).toString();
    }
}

