/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider;

import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.zaproxy.zap.spider.SpiderParam;
import org.zaproxy.zap.spider.URLResolver;

@Deprecated
public final class URLCanonicalizer {
    private static final Logger log = LogManager.getLogger(URLCanonicalizer.class);
    private static final String HTTP_SCHEME = "http";
    private static final int HTTP_DEFAULT_PORT = 80;
    private static final String HTTPS_SCHEME = "https";
    private static final int HTTPS_DEFAULT_PORT = 443;
    private static final Set<String> IRRELEVANT_PARAMETERS = new HashSet<String>(3);
    private static final Predicate<String> DEFAULT_IRRELEVANT_PARAMETERS;
    private static final Pattern patternResourceIdentifierUnquoted;
    private static final Pattern patternResourceMultipleIdentifier;
    private static final Pattern patternResourceMultipleIdentifierDetail;

    private URLCanonicalizer() {
    }

    public static String getCanonicalURL(String url) {
        return URLCanonicalizer.getCanonicalURL(url, null);
    }

    public static String getCanonicalURL(String url, String baseURL) {
        return URLCanonicalizer.getCanonicalURL(url, baseURL, DEFAULT_IRRELEVANT_PARAMETERS);
    }

    public static String getCanonicalURL(String url, String baseURL, Predicate<String> irrelevantParameter) {
        if ("javascript:".equals(url)) {
            return null;
        }
        try {
            Object queryString;
            java.net.URI canonicalURI;
            String resolvedURL = URLResolver.resolveUrl(baseURL == null ? "" : baseURL, url);
            log.debug("Resolved URL: {}", (Object)resolvedURL);
            try {
                canonicalURI = new java.net.URI(resolvedURL);
            }
            catch (Exception e) {
                canonicalURI = new java.net.URI(URIUtil.encodeQuery((String)resolvedURL));
            }
            if (canonicalURI.getScheme() == null) {
                log.warn("Protocol could not be reliably evaluated from uri: {} and base url: {}", (Object)canonicalURI, (Object)baseURL);
                return null;
            }
            if (canonicalURI.getRawAuthority() == null) {
                log.debug("Ignoring URI with no authority (host[\":\"port]): {} (on base {})", (Object)canonicalURI, (Object)baseURL);
                return null;
            }
            if (canonicalURI.getHost() == null) {
                log.warn("Host could not be reliably evaluated from: {} (on base {})", (Object)canonicalURI, (Object)baseURL);
                return null;
            }
            Object path = canonicalURI.normalize().getRawPath();
            int idx = ((String)path).indexOf("//");
            while (idx >= 0) {
                path = ((String)path).replace("//", "/");
                idx = ((String)path).indexOf("//");
            }
            while (((String)path).startsWith("/../")) {
                path = ((String)path).substring(3);
            }
            path = ((String)path).trim();
            SortedSet<QueryParameter> params = URLCanonicalizer.createSortedParameters(canonicalURI.getRawQuery());
            String canonicalParams = URLCanonicalizer.canonicalize(params, irrelevantParameter);
            Object object = queryString = canonicalParams.isEmpty() ? "" : "?" + canonicalParams;
            if (((String)path).length() == 0) {
                path = "/" + (String)path;
            }
            int port = canonicalURI.getPort();
            if (URLCanonicalizer.isDefaultPort(canonicalURI.getScheme(), port)) {
                port = -1;
            }
            String protocol = canonicalURI.getScheme().toLowerCase();
            String host = canonicalURI.getHost().toLowerCase();
            String pathAndQueryString = URLCanonicalizer.normalizePath((String)path) + (String)queryString;
            URL result = new URL(protocol, host, port, pathAndQueryString);
            return result.toExternalForm();
        }
        catch (Exception ex) {
            log.warn("Error while Processing URL [{}] in the spidering process (on base {}): {}", (Object)url, (Object)baseURL, (Object)ex.getMessage());
            return null;
        }
    }

    private static boolean isDefaultPort(String scheme, int port) {
        return HTTP_SCHEME.equalsIgnoreCase(scheme) && port == 80 || HTTPS_SCHEME.equalsIgnoreCase(scheme) && port == 443;
    }

    public static String buildCleanedParametersURIRepresentation(URI uri, SpiderParam.HandleParametersOption handleParameters, boolean handleODataParametersVisited) throws URIException {
        return URLCanonicalizer.buildCleanedParametersURIRepresentation(uri, handleParameters, handleODataParametersVisited, DEFAULT_IRRELEVANT_PARAMETERS);
    }

    static String buildCleanedParametersURIRepresentation(URI uri, SpiderParam.HandleParametersOption handleParameters, boolean handleODataParametersVisited, Predicate<String> irrelevantParameter) throws URIException {
        if (handleParameters.equals((Object)SpiderParam.HandleParametersOption.USE_ALL)) {
            return uri.toString();
        }
        if (handleParameters.equals((Object)SpiderParam.HandleParametersOption.IGNORE_COMPLETELY)) {
            return URLCanonicalizer.createBaseUriWithCleanedPath(uri, handleParameters, handleODataParametersVisited);
        }
        if (handleParameters.equals((Object)SpiderParam.HandleParametersOption.IGNORE_VALUE)) {
            StringBuilder retVal = new StringBuilder(URLCanonicalizer.createBaseUriWithCleanedPath(uri, handleParameters, handleODataParametersVisited));
            String cleanedQuery = URLCanonicalizer.getCleanedQuery(uri.getEscapedQuery(), irrelevantParameter);
            if (cleanedQuery.length() > 0) {
                retVal.append('?').append(cleanedQuery);
            }
            return retVal.toString();
        }
        return uri.toString();
    }

    private static String createBaseUriWithCleanedPath(URI uri, SpiderParam.HandleParametersOption handleParameters, boolean handleODataParametersVisited) throws URIException {
        StringBuilder uriBuilder = new StringBuilder(URLCanonicalizer.createBaseUri(uri));
        uriBuilder.append(URLCanonicalizer.getCleanedPath(uri.getEscapedPath(), handleParameters, handleODataParametersVisited));
        return uriBuilder.toString();
    }

    private static String createBaseUri(URI uri) throws URIException {
        StringBuilder baseUriBuilder = new StringBuilder();
        baseUriBuilder.append(uri.getScheme()).append("://").append(uri.getHost());
        if (uri.getPort() != -1) {
            baseUriBuilder.append(':').append(uri.getPort());
        }
        return baseUriBuilder.toString();
    }

    private static String getCleanedPath(String escapedPath, SpiderParam.HandleParametersOption handleParameters, boolean handleODataParametersVisited) {
        if (escapedPath == null) {
            return "";
        }
        String cleanedPath = handleODataParametersVisited ? URLCanonicalizer.cleanODataPath(escapedPath, handleParameters) : escapedPath;
        return cleanedPath;
    }

    private static String getCleanedQuery(String escapedQuery, Predicate<String> irrelevantParameter) {
        SortedSet<QueryParameter> params = URLCanonicalizer.createSortedParameters(escapedQuery);
        HashSet<String> parameterNames = new HashSet<String>();
        StringBuilder cleanedQueryBuilder = new StringBuilder();
        if (params != null && !params.isEmpty()) {
            for (QueryParameter parameter : params) {
                String name = parameter.getName();
                if (parameterNames.contains(name)) continue;
                parameterNames.add(name);
                if (irrelevantParameter.test(name)) continue;
                if (cleanedQueryBuilder.length() > 0) {
                    cleanedQueryBuilder.append('&');
                }
                cleanedQueryBuilder.append(name);
            }
        }
        return cleanedQueryBuilder.toString();
    }

    private static String cleanODataPath(String path, SpiderParam.HandleParametersOption handleParameters) {
        Object cleanedPath = path;
        if (SpiderParam.HandleParametersOption.USE_ALL.equals((Object)handleParameters)) {
            cleanedPath = path;
        } else {
            Matcher matcher = patternResourceIdentifierUnquoted.matcher(path);
            if (matcher.find()) {
                String resourceName = matcher.group(1);
                String resourceID = matcher.group(2);
                String subString = resourceName + "(" + resourceID + ")";
                int begin = path.indexOf(subString);
                int end = begin + subString.length();
                String beforeSubstring = path.substring(0, begin);
                String afterSubstring = path.substring(end);
                if (SpiderParam.HandleParametersOption.IGNORE_COMPLETELY.equals((Object)handleParameters) || SpiderParam.HandleParametersOption.IGNORE_VALUE.equals((Object)handleParameters)) {
                    StringBuilder sb = new StringBuilder(beforeSubstring);
                    sb.append(resourceName).append("()").append(afterSubstring);
                    cleanedPath = sb.toString();
                }
            } else {
                matcher = patternResourceMultipleIdentifier.matcher(path);
                if (matcher.find()) {
                    String multipleIdentifierSection = matcher.group(1);
                    int begin = path.indexOf(multipleIdentifierSection);
                    int end = begin + multipleIdentifierSection.length();
                    String beforeSubstring = path.substring(0, begin);
                    String afterSubstring = path.substring(end);
                    if (SpiderParam.HandleParametersOption.IGNORE_COMPLETELY.equals((Object)handleParameters)) {
                        cleanedPath = beforeSubstring + afterSubstring;
                    } else {
                        StringBuilder sb = new StringBuilder(beforeSubstring);
                        matcher = patternResourceMultipleIdentifierDetail.matcher(multipleIdentifierSection);
                        int i = 1;
                        while (matcher.find()) {
                            if (i > 1) {
                                sb.append(',');
                            }
                            String paramName = matcher.group(1);
                            sb.append(paramName);
                            ++i;
                        }
                        sb.append(afterSubstring);
                        cleanedPath = sb.toString();
                    }
                }
            }
        }
        return cleanedPath;
    }

    private static SortedSet<QueryParameter> createSortedParameters(String queryString) {
        if (queryString == null || queryString.isEmpty()) {
            return null;
        }
        String[] pairs = queryString.split("&");
        TreeSet<QueryParameter> params = new TreeSet<QueryParameter>();
        block4: for (String pair : pairs) {
            if (pair.length() == 0) continue;
            String[] tokens = pair.split("=", 2);
            switch (tokens.length) {
                case 1: {
                    if (pair.charAt(0) == '=') {
                        params.add(new QueryParameter("", tokens[0]));
                        continue block4;
                    }
                    params.add(new QueryParameter(tokens[0], ""));
                    continue block4;
                }
                case 2: {
                    params.add(new QueryParameter(tokens[0], tokens[1]));
                }
            }
        }
        return params;
    }

    private static String canonicalize(SortedSet<QueryParameter> sortedParameters, Predicate<String> irrelevantParameter) {
        if (sortedParameters == null || sortedParameters.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(100);
        for (QueryParameter parameter : sortedParameters) {
            String name = parameter.getName().toLowerCase();
            if (irrelevantParameter.test(name)) continue;
            if (sb.length() > 0) {
                sb.append('&');
            }
            sb.append(parameter.getName());
            if (parameter.getValue().isEmpty()) continue;
            sb.append('=');
            sb.append(parameter.getValue());
        }
        return sb.toString();
    }

    private static String normalizePath(String path) {
        return path.replace("%7E", "~").replace(" ", "%20");
    }

    static {
        IRRELEVANT_PARAMETERS.add("jsessionid");
        IRRELEVANT_PARAMETERS.add("phpsessid");
        IRRELEVANT_PARAMETERS.add("aspsessionid");
        DEFAULT_IRRELEVANT_PARAMETERS = name -> IRRELEVANT_PARAMETERS.contains(name) || name.startsWith("utm_");
        patternResourceIdentifierUnquoted = Pattern.compile("/([\\w%]*)\\(([\\w']*)\\)");
        patternResourceMultipleIdentifier = Pattern.compile("/[\\w%]*\\((.*)\\)");
        patternResourceMultipleIdentifierDetail = Pattern.compile("([\\w%]*)=([\\w']*)");
    }

    private static class QueryParameter
    implements Comparable<QueryParameter> {
        private final String name;
        private final String value;

        public QueryParameter(String name, String value) {
            if (name == null) {
                throw new IllegalArgumentException("Parameter name must not be null.");
            }
            if (value == null) {
                throw new IllegalArgumentException("Parameter value must not be null.");
            }
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        @Override
        public int compareTo(QueryParameter other) {
            if (other == null) {
                return 1;
            }
            int result = this.name.compareTo(other.name);
            if (result != 0) {
                return result;
            }
            return this.value.compareTo(other.value);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.name.hashCode();
            result = 31 * result + this.value.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            QueryParameter other = (QueryParameter)obj;
            if (!this.name.equals(other.name)) {
                return false;
            }
            return this.value.equals(other.value);
        }
    }
}

